/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace CyPhy2Verification
{
    public partial class VerificationSettings : Form
    {
        public VerificationSettings()
        {
            InitializeComponent();

            txtQRMCorePath.Text = CyPhy2Verification.Properties.Settings.Default.QRMCorePath;
            chbRunQR.Checked = CyPhy2Verification.Properties.Settings.Default.RunQR;
        }

        private void btnBrowseQRMCorePath_Click(object sender, EventArgs e)
        {
            string selectedPath = Directory.Exists(txtQRMCorePath.Text) ?
                Path.GetFullPath(txtQRMCorePath.Text) :
                "";

            using (META.FolderBrowserDialog fbd = new META.FolderBrowserDialog()
            {
                SelectedPath = selectedPath,
                //ShowNewFolderButton = false,
            })
            {

                var dr = fbd.ShowDialog();

                if (dr == System.Windows.Forms.DialogResult.OK)
                {
                    txtQRMCorePath.Text = fbd.SelectedPath;
                }
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            CyPhy2Verification.Properties.Settings.Default.QRMCorePath = txtQRMCorePath.Text;
            CyPhy2Verification.Properties.Settings.Default.RunQR = chbRunQR.Checked;

            CyPhy2Verification.Properties.Settings.Default.Save();

            this.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.Close();
        }
    }
}
