/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CyPhyCheckerLib
{
    public class Message
    {

        public int Id { get; set; }
        
        public MessageType Type { get; set; }
        public enum MessageType
        {
            None,
            Info,
            Warning,
            Error
        }

        public string Name { get; set; }
        public string Description { get; set; }
        public string FullDescription { get; set; }
        public string MethodName { get; set; }

        public string Hint { get; set; }

        public override string ToString()
        {
            return string.Format("ID: {0} Name: {1}  Description: {2}  Hint: {3}  MethodName: {4}",
                Id,
                Name,
                Description,
                Hint,
                MethodName);
        }

        public string NameString
        {
            get
            {
                return Name;
            }
        }

        public string DescriptionString
        {
            get
            {
                return string.Format("Description: {0}", Description);
            }
        }

        public string HintString
        {
            get
            {
                return string.Format("Hint: {0}", Hint);
            }
        }

        public string MethodNameString
        {
            get
            {
                return string.Format("MethodName: {0}", MethodName);
            }
        }
    }
}
