/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿// -----------------------------------------------------------------------
// <copyright file="ComponentItem.cs" company="">
// TODO: Update copyright text.
// </copyright>
// -----------------------------------------------------------------------

namespace CyPhyComponentFidelitySelector
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using GME.MGA;
    using System.ComponentModel;

    /// <summary>
    /// TODO: Update summary.
    /// </summary>
    public class ComponentItem
    {
        internal IMgaModel component { get; set; }

        public string Classification { get; set; }
        public List<IMgaModel> ModelicaModel { get; set; }

        public BindingList<ModelicaModel> ModelicaModelOptions { get; set; }

        public string Guid { get; set; }

        public ComponentItem()
        {

        }

        public ComponentItem(IMgaModel component)
        {
            this.component = component;
            ModelicaModel = new List<IMgaModel>();
            ModelicaModelOptions = new BindingList<ModelicaModel>();

            Classification = component.StrAttrByName["Classifications"];

            component
                .ChildFCOs
                .Cast<IMgaFCO>()
                .Where(x => x.Meta.Name == "ModelicaModel")
                .ToList()
                .ForEach(x => ModelicaModel.Add(x as IMgaModel));

            ModelicaModel.Sort((x, y) => x.GetGuidDisp().CompareTo(y.GetGuidDisp()));
            int id = 0;

            ModelicaModel.ForEach(x => 
                {
                    var opt = new CyPhyComponentFidelitySelector.ModelicaModel()
                    {
                        Key = id++,
                        Name = x.Name,
                        Guid = x.GetGuidDisp()
                    };
                    ModelicaModelOptions.Add(opt);
                });


            Guid = component.GetGuidDisp();
        }
    }
}
