import sys
import getopt
import json
import os
import glob
import shutil
import urllib
import urlparse
import zipfile
import re

import ISIS
import ISIS.vfinterface
vfinterface = ISIS.vfinterface
#try:
#    import simplejson as json
#except ImportError:
#    import json

def EnsureDir(s_path):
    d = os.path.dirname(s_path)
    if not os.path.exists(d):
        os.makedirs(d)
    elif not os.path.isdir(d):
        sendRequest( { "ERROR" : "Could not create directory \"" + s_path + "\" for component import: path already exists and is not a directory." } )
        sys.exit(1)
    return(s_path)


class Usage(Exception):
    def __init__(self, msg):
        self.msg = msg


def tryGetValue( classObject, methodName ):
    try:
        return getattr( classObject, methodName )()
    except:
        pass
    
    return None


def getZipFileComponentJSONInputStream( zipfileObject ):
    
    componentJSONFileNames = []
    for zippedFileName in zipfileObject.namelist():
        if zippedFileName.endswith( ".component.json" ):
            componentJSONFileNames.append( zippedFileName )

    if len( componentJSONFileNames ) < 1:
        sendRequest( { "ERROR" : zipfileObject.filename + ": could not find component JSON file in zip file." } )
        sys.exit(1)
    
    if len( componentJSONFileNames ) > 1:
        errorMessage = zipfileObject.filename + ":  Cannot import component:  More than one component JSON file found in zip file \"" + zipfileObject.filename + "\".  Files found are:"
        for componentJSONFileName in componentJSONFileNames:
            errorMessage += "\n" + componentJSONFileName
        sendRequest( { "ERROR" : errorMessage } )
        sys.exit(1)
            
        return None
    
    componentJSONFileName = componentJSONFileNames[0]
    return zipfileObject.open( componentJSONFileName, "r" )
    
    
def getUsesLibraryList( meta_object ):
    
    features = tryGetValue( meta_object , "get_Features" )
    if features == None:
        return None
    
    return filter( lambda x: x.__module__ + "." + x.__class__.__name__ == "AVM.UsesLibrary", features )
                
         
def getRevisionPath( vf_path ):
    if vf_path == None or vf_path == "":
        return ""
    if vf_path[-1] == "/":
        vf_path = vf_path[0:-1]
    lastSlashPos = vf_path.rfind( "/" )
    if lastSlashPos == -1:
        return ""
    return vf_path[0:lastSlashPos]
    

def sendRequest( request ):
    json.dump( request, sys.stdout )
    print
    sys.stdout.flush()
            
def getResponse():
    return json.loads( sys.stdin.readline() )
        
def add(JSONPath, projroot, token):
    # To add, parse the JSON
    # Read all the file references
    # Copy the JSON + all files to project/ComponentLib


    try:
        f = open(JSONPath, "rb")
    except Exception as e:
        sendRequest( { "ERROR" : "Unable to open \"" + JSONPath + "\": " + str( e ) } )
        sys.exit(1)
        
    myzipfile = None

    if zipfile.is_zipfile(f):
        myzipfile = zipfile.ZipFile(f)
        componentJSONInputStream = getZipFileComponentJSONInputStream( myzipfile )
        if componentJSONInputStream == None:
            sendRequest( { "ERROR" : "Unable to read zip file \"" + JSONPath + "\"" })
            sys.exit(1)
        
    else:
        f.seek(0) # BECAUSE OF "zipfile.is_zipfile(f)" ABOVE
        componentJSONInputStream = f

    componentJSONData = componentJSONInputStream.read()
    componentJSONInputStream.close()
    
    try:
        componentJSON = json.loads( componentJSONData )
    except Exception as e:
        sendRequest( { "ERROR" : "Component JSON from file \"" + JSONPath + "\" has invalid syntax." } )
        sys.exit(1)
        
    meta_object = ISIS.JSONDeserializeHelper.deserialize( componentJSON )


    # Get needed data from component model
    s_Name = meta_object.get_Name()
    s_Revision = tryGetValue(meta_object, "get_Revision") or ""
    s_Version = tryGetValue(meta_object, "get_Version") or ""
    s_AVMID = meta_object.get_AVMID()    
    af_Files = tryGetValue( meta_object, "get_Files" ) or []
    usesLibraryList = getUsesLibraryList( meta_object )


    p_SrcBasePath = os.path.dirname(JSONPath)

    s_AVMID_safe = s_AVMID.replace(':','-')
    p_DstBasePath = projroot + "/components/" + s_Name + "/" + str(s_AVMID_safe)    
    p_DstBasePath += "v" + str(s_Version) if s_Version != "" else ""    
    p_DstBasePath += "r" + str(s_Revision) if s_Revision != "" else ""

    # Create target folder
    EnsureDir(p_DstBasePath + "/")

    # Copy JSON file
    p_DstJSONFile = p_DstBasePath + "/ComponentData.component.json"
    
    try:
        componentJSONOutputStream = open( p_DstJSONFile, "wb" )
    except Exception as e:
        sendRequest( { "ERROR" : "Could not open file \"" + p_DstJSONFile + "\" for storing component data: " + str( e ) } )
        sys.exit(1)
        
    componentJSONOutputStream.write( componentJSONData )
    componentJSONOutputStream.close()

    sendRequest( { "FILE" : p_DstJSONFile } )

    # Copy rest of objects in FILE reference
    for myfile in af_Files:
        p_RelativePath = str(myfile.get_Location())
        p_RelativePath = p_RelativePath.replace( "\\", "/" )

        if myzipfile:
            if not p_RelativePath in myzipfile.namelist():
                sendRequest( { "WARNING" : "Could not copy \"" + p_RelativePath + "\" from zip archive \"" + myzipfile.filename + "\": file does not exist." } )
                continue
            try:
                p_Src = myzipfile.open( p_RelativePath, "r" )
            except Exception as e:
                sendRequest( { "WARNING" : "Could not open \"" + p_RelativePath + "\" in zip archive \"" + myzipfile.filename + "\" for reading in order to copy: " + str( e ) } )
                continue
        else:
            p_SrcFullPath = str(p_SrcBasePath + "/" + p_RelativePath)
            if not os.path.exists( p_SrcFullPath ):
                sendRequest( { "WARNING" : "Could not copy \"" + p_SrcFullPath + "\": file does not exist." } )
                continue
            filename = str(p_SrcBasePath + "/" + p_RelativePath)
            try:
                p_Src = open( filename, "rb" )
            except Exception as e:
                sendRequest( { "WARNING" : "Could not open \"" + filename + "\" for reading in order to copy: " + str( e ) } )
                continue
            
        p_DstFullPath = str(p_DstBasePath + "/" + p_RelativePath)

        p_DstFullPathFolder = os.path.dirname(p_DstFullPath)
        EnsureDir(p_DstFullPathFolder + "/")
        
        try:
            p_Dst = open( p_DstFullPath, "wb" )
        except Exception as e:
            sendRequest( { "WARNING" : "Could not open \"" + p_DstFullPath + "\" for writing during file copy: " + str( e ) } )
            continue
        shutil.copyfileobj( p_Src, p_Dst )
        p_Src.close()
        p_Dst.close()


    for usesLibrary in usesLibraryList:

        vf_url = usesLibrary.get_Path()
        if vf_url == "":
            continue
        if vf_url[-1] == "/":
            vf_path = vf_url[0:-1]

        vf_url_data = urlparse.urlparse( vf_url )
        vf_host = vf_url_data.netloc
        vf_path = vf_url_data.path
        vf_path_quoted = urllib.quote( urllib.unquote( vf_path )  )

        version = usesLibrary.get_Version()

        libraryName = usesLibrary.get_Name()

        libraryJSONPath = getRevisionPath(vf_path_quoted)
        if libraryJSONPath == "":
            sendRequest( { "WARNING" : JSONPath + ": Could not get revision path for \"" + vf_url + "\"" } )
            continue
        
        vf_face = vfinterface.VehicleForgeInterface(vf_host)
        
        auth_type = "REQUEST"
        
        cancelled = False


        if token == "":

            while True:

                sendRequest( { "AUTH" : auth_type } )
                response = getResponse()
                
                if "CANCEL" in response:
                    cancelled = True
                    break;
                
                try:
                    with vf_face.login( response[ "USERNAME" ], response[ "PASSWORD" ] ):
                        token = vf_face.get_api_token()
                        sendRequest( { "TOKEN" : token } )
                    break
                except Exception as e:
                    error_message = str( e )
                    if error_message != "Credentials incorrect":
                        error_message = "Communication problem with VehicleForge"
                    sendRequest( { "WARNING" : JSONPath + ": UNABLE TO AUTHENTICATE TO VEHICLEFORGE: " + error_message } )
                    sendRequest( { "INFO" : "Attempting to authenticate again"})


        if cancelled:
            sendRequest( { "WARNING" : JSONPath + ": AUTHENTICATICATION TO VEHICLEFORGE CANCELLED.  VEHICLEFORGE LIBRARY DATA WILL BE MISSING FROM YOUR PROJECT, SO YOU MAY NOT BE ABLE TO SIMULATE THIS COMPONENT IN MODELICA." } )
            break


        response_buffer = None
                            
        try:
            response_buffer = vf_face.open( libraryJSONPath + "?service_token=" + token )
        except Exception as e:
            response_buffer = None

        if response_buffer == None:
            sendRequest( { "ERROR" : JSONPath + ": UNABLE TO RETRIEVE LIBRARY DATA FROM VEHICLEFORGE.  VEHICLEFORGE LIBRARY DATA WILL BE MISSING FROM YOUR PROJECT, SO YOU MAY NOT BE ABLE TO SIMULATE THIS COMPONENT IN MODELICA." } )
            break
        
        libraryJSONData = ""
        newData = response_buffer.read()
        while newData != "":
            libraryJSONData += newData
            newData = response_buffer.read()
        try:
            libraryJSON = json.loads( libraryJSONData )
        except:
            sendRequest( { "WARNING" : "DATA RETRIEVED FROM VEHICLEFORGE (\"https://" + vf_host + vf_path + "\") IS INCORRECT OR CORRUPT.  THIS DATA WILL BE MISSING FROM YOUR PROJECT, SO YOU MAY NOT BE ABLE TO SIMULATE THIS COMPONENT IN MODELICA." } )
            continue
        
        if "file_name" in libraryJSON:
            fileName = libraryJSON["file_name"]
        else:
            sendRequest( { "WARNING" : JSONPath + ": Could not get file_name of library zip file to download.  Using generic name \"vf_library.zip\"" } )
            fileName = "vf_library.zip"
        
        libraryDir = projroot + "/shared_libraries/" + libraryName + "/" + version
        libraryFile =  libraryDir + "/" + fileName
        EnsureDir( libraryFile )
        
        try:
            libraryFileDescriptor = os.open( libraryFile, os.O_WRONLY | os.O_CREAT | os.O_EXCL | os.O_BINARY )
            libraryFileStream = os.fdopen( libraryFileDescriptor, "wb" )
        except OSError as error:
            if error.errno != 17:
                sendRequest( { "WARNING" : "Could not open library file \"" + libraryFile + "\": " + str( error ) } )
            continue

        response_buffer = vf_face.open( vf_path_quoted + "?service_token=" + token )
        shutil.copyfileobj( response_buffer, libraryFileStream )
        libraryFileStream.close()

        libraryZipFile = zipfile.ZipFile( libraryFile, "r" )
        for name in libraryZipFile.namelist():
            destination_file = libraryDir + "/" + name
            
            # DON'T PROCESS DIRECTORIES
            if destination_file[-1] == "/":
                continue
            
            p_DstFullPathFolder = os.path.dirname(destination_file)
            EnsureDir(p_DstFullPathFolder + "/")
            
            # MAKE SURE FILE IS NOT A DIRECTORY
            if os.path.isdir( destination_file ):
                continue
            
            p_Src = libraryZipFile.open( name, "r" )
            p_Dst = open( destination_file, "wb" )
            shutil.copyfileobj( p_Src, p_Dst )
            p_Src.close()
            p_Dst.close()
            

    ap_ProjFiles = glob.glob(projroot + '\\*.project.json')
    # If no proj file exists, create one
    if len(ap_ProjFiles) == 0:
        p_ProjFile = projroot + '\\manifest.project.json'

        d_ProjDict = dict()
        d_ProjDict["DesignSpaceModels"] = []
        d_ProjDict["Configurations"] = []
        d_ProjDict["TestBenches"] = []
        d_ProjDict["Results"] = dict()
        d_ProjDict["Results"]["UrlHints"] = []
        d_ProjDict["Requirements"] = dict()
        d_ProjDict["Requirements"]["UrlHints"] = []

        d_ProjRoot = dict()
        d_ProjRoot["Project"] = d_ProjDict

        f_Proj = open(p_ProjFile,"wb")
        json.dump(d_ProjRoot,f_Proj,indent=2)
        f_Proj.close()

        ap_ProjFiles = [p_ProjFile]

    # Create entry in any .project.json files that exist
    for p_ProjFile in ap_ProjFiles:
        # This is out project file.
        f_Proj = open(p_ProjFile,"rb")
        proj = json.load( f_Proj )
        f_Proj.close()

        if not "Project" in proj:
            proj[ "Project" ] = dict()
        projRootDict = proj["Project"]

        if not "Components" in projRootDict:
            projRootDict[ "Components" ] = []
        compsRoot = projRootDict["Components"]

        # ADD STANZA TO "project" FILE IF IT'S NOT ALREADY IN "project" FILE.
        NewCompDict = dict()
        NewCompDict["avmid"] = s_AVMID
        NewCompDict["name"] = s_Name
        NewCompDict["version"] = s_Version
        NewCompDict["revision"] = s_Revision
        regex = re.compile( r"^" + re.escape( projroot ) + r"[/\\]" )
        NewCompDict["modelpath"] = re.sub( regex, "", p_DstJSONFile )

        b_foundMatch = 0
        for compDict in compsRoot:
            if compDict == NewCompDict:
                b_foundMatch = 1
        if b_foundMatch == 0:
            compsRoot.append(NewCompDict)

        os.remove( p_ProjFile )
        f_Proj = open(p_ProjFile,"wb")
        json.dump( proj, f_Proj )
        f_Proj.close()


def main(argv=None):
    
    if argv is None:
        argv = sys.argv

    try:
        try:
            opts, _ = getopt.getopt(argv[1:], ["h", "a=", "r=", "p=", "t="], ["help", "add=", "projroot=", "project=", "token="])

            # PROCESS "projroot" OPTION FIRST
            p_token = ""
            for k, v in opts:
                if (k == "--p" or k == "--projroot"):
                    p_projroot = v
                if (k == "--t" or k == "--token"):
                    p_token = v

            # opts is [option value] pairs
            # args is everything not preceeded by an option
            for k, v in opts:
                if k == "--add":
                    add(v, p_projroot, p_token)
#                    p_NewJSONPath = add(v, p_projroot, p_token)
#                    print(p_NewJSONPath)


        except getopt.error, msg:
            raise Usage(msg)
    except Usage as err:
        sendRequest( { "ERROR" : "Could not execute: " + str( err ) } )
        return 2

    return 0

try:
    if __name__ == "__main__":
        sys.exit(main(sys.argv))
except Exception as e:
    sendRequest( { "ERROR" : "Program encountered an exception: " + str( e ) } )
    sys.exit( 1 )
