/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// UdmApp.cpp: implementation of the CUdmApp class.
// This file was automatically generated as UdmApp.cpp
// by UDM Interpreter Wizard on Thursday, March 27, 2008 10:37:31
#include "stdafx.h"
#include "UdmApp.h"
#include "UdmConfig.h"
#include "Uml.h"
#include "CyPhyML.h"
#include "UdmUtil.h"
#include "CyphyDSEConverter.h"
#include "UdmConsole.h"

#include "CyPhyElaborate.h"
#include "DSRefactorDialog.h"
#include "CARefactorDialog.h"

using namespace CyPhyML;

CString CUdmApp::mgaPath = "";

// converts jdlk_jasf__afsdf__Fsda___ => jdlk_jasf
std::string StripComponentNameSuffix(std::string inputName)
{
	auto result = inputName;
	size_t pos = inputName.find("__");
	if (pos != string::npos)
	{
		result = inputName.substr(0, int(pos));
	}
	return result;
}

std::string getFileNameNoExt(const std::string &fullpath)
{
	std::string ret = fullpath;
	size_t pos = ret.rfind("\\");
	if(pos!=string::npos)
		ret = ret.substr(pos+1);
	pos = ret.find(".");
	if(pos!=string::npos)
		ret = ret.substr(0, pos);
	return ret;
}

std::string appendObjLink(const Udm::Object &obj)
{
	if (!obj)
		return "null";
	return ("<A HREF=\"mga:"+ UdmGme::UdmId2GmeId(obj.uniqueId()) + "\">" + UdmUtil::ExtractName(obj) + "</A>");
}

void showUsage()
{
	CString usage("CyPhyDSEConverter interpreter cannot be invoked. Please see its usage as below: \r\n");
	usage.Append("1. Invoke interpreter inside a ComponentAssembly/TestBench model and convert this model into DesignContainer of compound type.\r\n");
	usage.Append("2. Invoke interpreter inside a DesignContainer model, select an object or a group of objects and ");
	usage.Append("convert them into a DesignContainer or ComponentAssembly and still keep the port connection.\r\n");
	AfxMessageBox(usage,MB_ICONINFORMATION);				
}

void generateDesignContainerFromCA(CyPhyML::RootFolder &cyphy_rf, CyPhyML::ComponentAssembly &cyphy_ca)
{
		CyPhyDSEConverter converter(cyphy_rf);
		converter.startProgressBar();
		Udm::Object ca_parent = cyphy_ca.parent();
		CyPhyML::DesignContainer newdc;
		if(ca_parent.type()==CyPhyML::DesignContainer::meta)
		{
			converter.initCopyMap();
			CyPhyML::DesignContainer currdc = CyPhyML::DesignContainer::Cast(ca_parent);
			// Try to generate a safe name for downstream tools
			std::string newdcname = (std::string)cyphy_ca.name();
			newdc = converter.createNewDesignContainer(currdc, newdcname, false);
			// set the position of the generated container to the position of CA
			newdc.position() = cyphy_ca.position();
			converter.createCACopy(cyphy_ca, newdc);
			converter.reconstructAssociations(currdc);
			cyphy_ca.DeleteObject();
		}
		else
		{
			CyPhyML::DesignSpace dsFolder = CyPhyML::DesignSpace::Create(cyphy_rf);
			dsFolder.name() = "DesignSpace " + (std::string)cyphy_ca.name();
			newdc = converter.createNewDesignContainer(dsFolder, (std::string)cyphy_ca.name());
			converter.createDSFromCA(cyphy_ca);
		}
		converter.endProgressBar();

		std::string addlog("New DesignContainer: "+appendObjLink(newdc)+" is generated for ComponentAssembly: "+appendObjLink(cyphy_ca));
		GMEConsole::Console::Out::writeLine(addlog);
}

void generateDesignContainerFromCARef(CyPhyML::RootFolder &cyphy_rf, CyPhyML::ComponentAssembly &cyphy_ca, CyPhyML::ComponentRef &cyphy_comref)
{
		CyPhyDSEConverter converter(cyphy_rf);
		converter.startProgressBar();
		Udm::Object ca_parent = cyphy_ca.parent();
		if(cyphy_comref!=Udm::null)
			ca_parent = cyphy_comref.parent();
		CyPhyML::DesignContainer newdc;
		if(ca_parent.type()==CyPhyML::DesignContainer::meta)
		{
			CyPhyML::DesignContainer currdc = CyPhyML::DesignContainer::Cast(ca_parent);
			// Try to generate a safe name for downstream tools
			std::string newdcname = (std::string)cyphy_ca.name();
			newdc = converter.createNewDesignContainer(currdc, newdcname, false);
			// set the position of the generated container to the position of CA
			newdc.position() = cyphy_comref.position();
			converter.createCACopy(cyphy_ca, newdc);
			converter.addCopyMapInput(cyphy_comref, newdc);
			converter.reconstructAssociations(currdc);
			cyphy_comref.DeleteObject();
		}
		else
		{
			CyPhyML::DesignSpace dsFolder = CyPhyML::DesignSpace::Create(cyphy_rf);
			dsFolder.name() = "DesignSpace " + (std::string)cyphy_ca.name();
			newdc = converter.createNewDesignContainer(dsFolder, (std::string)cyphy_ca.name());
			converter.createDSFromCA(cyphy_ca);
		}
		converter.endProgressBar();

		std::string addlog("New DesignContainer: "+appendObjLink(newdc)+" is generated for ComponentAssembly: "+appendObjLink(cyphy_ca));
		GMEConsole::Console::Out::writeLine(addlog);
}

/*********************************************************************************/
/* Initialization function. The framework calls it before preparing the backend. */
/* Initialize here the settings in the config global object.					  */
/* Return 0 if successful.														  */
/*********************************************************************************/
int CUdmApp::Initialize()
{

	// TODO: Your initialization code comes here...
	return 0;
}



/* 
Remarks to CUdmApp::UdmMain(...):
0.	The p_backend points to an already open backend, and the framework 
	closes it automatically. DO NOT OPEN OR CLOSE IT!
	To commit changes use p_backend->CommitEditSequence().
	To abort changes use p_backend->AbortEditSequence().
	To save changes to a different file use p_backend->SaveAs() or p_backend->CloseAs().

1.	Focus is the currently open model.

2.	The possible values for param (from GME DecoratorLib.h component_startmode_enum):
	GME_MAIN_START			=   0,
	GME_BROWSER_START		=   1,
	GME_CONTEXT_START		=   2,
	GME_EMBEDDED_START		=   3,
	GME_MENU_START			=  16,
	GME_BGCONTEXT_START		=  18,
	GME_ICON_START			=  32,
	METAMODEL_CHECK_SYNTAX	= 101

 3. The framework catches all the exceptions and reports the error in a message box,
	clean up and close the transactions aborting the changes. You can override this 
	behavior by catching udm_exception. Use udm_exception::what() to form an error 
	message.
*/

/***********************************************/
/* Main entry point for Udm-based Interpreter  */
/***********************************************/
void CUdmApp::UdmMain(
					 Udm::DataNetwork* p_backend,		// Backend pointer(already open!)
					 Udm::Object focusObject,			// Focus object
					 set<Udm::Object> selectedObjects,	// Selected objects
					 long param)						// Parameters
{	
	if(focusObject==Udm::null)
	{
		showUsage();	
		return;
	}

	try{	
		CyPhyML::RootFolder cyphy_rf = CyPhyML::RootFolder::Cast(p_backend->GetRootObject());

		bool showDlg = true;
		
		if(selectedObjects.size()==1)
		{
			Udm::Object obj = *(selectedObjects.begin());
			Udm::Object obj_parent = obj.GetParent();
			if(Uml::IsDerivedFrom(obj_parent.type(), CyPhyML::ComponentAssembly::meta) || 
				Uml::IsDerivedFrom(obj_parent.type(), CyPhyML::DesignContainer::meta))
			{
				CyPhyML::ComponentAssembly cyphy_ca;
				CyPhyML::ComponentRef cyphy_comref;
				if(Uml::IsDerivedFrom(obj.type(), CyPhyML::ComponentAssembly::meta))
				{
					cyphy_ca = CyPhyML::ComponentAssembly::Cast(obj);
				}
				else if(Uml::IsDerivedFrom(obj.type(), CyPhyML::ComponentRef::meta))
				{
					cyphy_comref = CyPhyML::ComponentRef::Cast(obj);
					CyPhyML::DesignElement ref_elem = cyphy_comref.ref();
					if(Uml::IsDerivedFrom(ref_elem.type(), CyPhyML::ComponentAssembly::meta))
						cyphy_ca = CyPhyML::ComponentAssembly::Cast(ref_elem);
				}

				bool finish = false;
				if(cyphy_ca!=Udm::null)
				{
					CCARefactorDialog dlg;
					if(dlg.DoModal()==IDCANCEL)
						return;

					switch(dlg.rt)
					{
					case genDC:
						{
							if(cyphy_comref == Udm::null)
								generateDesignContainerFromCA(cyphy_rf, cyphy_ca);
							else
								generateDesignContainerFromCARef(cyphy_rf, cyphy_ca, cyphy_comref);
							finish = true;
						}
						break;

					case genCA:
						{
							if(cyphy_comref==Udm::null)
							{
								CyPhyDSEConverter converter(cyphy_rf);
								converter.startProgressBar();
								converter.initCopyMap(obj_parent);
								std::string newcaname = StripComponentNameSuffix(UdmUtil::ExtractName(cyphy_ca));
								CyPhyML::ComponentAssembly newca = converter.createNewCA(focusObject, newcaname);							
								newca.position() = cyphy_ca.position();
								converter.createNewObject(cyphy_ca, cyphy_comref==Udm::null);
								converter.reconstructAssociations(focusObject);
								converter.deleteConvertedObjs();
								converter.endProgressBar();
			
								std::string addlog("New ComponentAssembly: "+ appendObjLink(newca)+" is generated.");
								GMEConsole::Console::Out::writeLine(addlog);
								finish = true;
							}
							else 
								showDlg = false;
						}
						break;

					case extract:
						{
							CyPhyDSEConverter converter(cyphy_rf);
							converter.startProgressBar();
							converter.gatherConnections_tobe_reconstruce(cyphy_ca, obj_parent);
							converter.createCACopy(cyphy_ca, obj_parent);
							converter.reconstructExtractCAAssociations(obj_parent);
							if(cyphy_comref==Udm::null)
								cyphy_ca.DeleteObject();
							else
								cyphy_comref.DeleteObject();
							converter.endProgressBar();
							finish = true;
						}
						break;
					}
					if(finish)
						return;
				}
			}
		}

		if(selectedObjects.empty())
		{
			if(Uml::IsDerivedFrom(focusObject.type(), CyPhyML::ComponentAssembly::meta))
			{	
				CyPhyML::ComponentAssembly cyphy_ca = CyPhyML::ComponentAssembly::Cast(focusObject);
				generateDesignContainerFromCA(cyphy_rf, cyphy_ca);
			}
			else
			{
				showUsage();
				return;
			}
		}
		else
		{
			if(focusObject.isInstance())
			{
				CString msg("The current DesignContainer is instance itself and it cannot be modified.");
				AfxMessageBox(msg,MB_ICONINFORMATION);				
				return;
			}

			//get first selected DesignEntity type object for position setting
			Udm::Object firstObj;
			for(set<Udm::Object>::iterator it=selectedObjects.begin();it!=selectedObjects.end();++it)
			{
				if(Uml::IsDerivedFrom((*it).type(), CyPhyML::DesignEntity::meta))
				{
					firstObj = *it;
					break;
				}
			}

			if(firstObj==Udm::null)
			{
				showUsage();
				return;
			}

			if(Uml::IsDerivedFrom(focusObject.type(), CyPhyML::ComponentAssembly::meta) 
				|| Uml::IsDerivedFrom(focusObject.type(), CyPhyML::DesignContainer::meta)
				|| Uml::IsDerivedFrom(focusObject.type(), CyPhyML::TestBench::meta))
			{
				CyPhyDSEConverter converter(cyphy_rf);
				converter.startProgressBar();
			
				bool insideTB = false;
				bool genCA = true;
				if(Uml::IsDerivedFrom(focusObject.type(), CyPhyML::DesignContainer::meta))
				{
					converter.initCopyMap(focusObject);
					if(showDlg)
					{
						CDSRefactorDialog dlg;
						if (dlg.DoModal() == IDOK)
							genCA = dlg.m_genCA;
						else 
							return;
					}
				}
				else if(Uml::IsDerivedFrom(focusObject.type(), CyPhyML::TestBench::meta))
					insideTB = true;

				std::string newcaname = "new ComponentAssembly";
				std::string newdcname = "new DesignContainer";
				std::string newlink;
				CyPhyML::ComponentAssembly newca;
				CyPhyML::DesignContainer newdc;

				if(selectedObjects.size()==1)
					newcaname = newdcname = StripComponentNameSuffix(UdmUtil::ExtractName(firstObj));

				if(genCA)
				{
					newca = converter.createNewCA(focusObject, newcaname);
					newca.position() = CyPhyML::DesignEntity::Cast(firstObj).position();
					newlink = "New ComponentAssembly: "+ appendObjLink(newca);
				}
				else
				{
					CyPhyML::DesignContainer currdc = CyPhyML::DesignContainer::Cast(focusObject);
					if(selectedObjects.size()==1)
						newdc = converter.createNewDesignContainer(currdc, newdcname, firstObj.type()!=CyPhyML::ComponentAssembly::meta);
					else
						newdc = converter.createNewDesignContainer(currdc, newdcname, false);

					newdc.position() = CyPhyML::DesignEntity::Cast(firstObj).position();
					newlink = "New DesignContainer: "+ appendObjLink(newdc);
				}

				set<Udm::Object>::iterator i;
				if(insideTB)
				{
					for(set<Udm::Object>::iterator i=selectedObjects.begin();i!=selectedObjects.end();++i)
					{
						Udm::Object currObj = *i;
						if(Uml::IsDerivedFrom(currObj.type(), CyPhyML::Component::meta) 
							|| Uml::IsDerivedFrom(currObj.type(), CyPhyML::ComponentAssembly::meta)
							|| Uml::IsDerivedFrom(currObj.type(), CyPhyML::ComponentRef::meta))
							converter.createNewObject(currObj);
					}
				}
				else
				{
					for(i=selectedObjects.begin();i!=selectedObjects.end();++i)
					{
						Udm::Object currObj = *i;
						std::string objpath = currObj.getPath2();
						if(genCA && Uml::IsDerivedFrom(currObj.type(), CyPhyML::DesignContainer::meta))
							continue;
						converter.createNewObject(currObj);
					}
				}

				for(i=selectedObjects.begin();i!=selectedObjects.end();++i)
				{
					Udm::Object currObj = *i;
					if(currObj.type() == CyPhyML::DesignContainer::meta)
						converter.reconstructReference(CyPhyML::DesignContainer::Cast(currObj));
					else if(Uml::IsDerivedFrom(currObj.type(), CyPhyML::DesignElement::meta))
						converter.reconstructReference(CyPhyML::DesignElement::Cast(currObj));
				}
				//reconstructReference
				converter.reconstructAssociations(focusObject);
				converter.deleteConvertedObjs();
				converter.endProgressBar();
			
				std::string addlog(newlink +" is generated.");
				GMEConsole::Console::Out::writeLine(addlog);
			}
			else
			{
				showUsage();
				return;
			}
		}
	}
	catch(udm_exception &exc)
	{
		throw exc;
	}
	catch(...)
	{
		throw;
	}
}