/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef CYPHYDSREFINER_H
#define CYPHYDSREFINER_H

#include "CyPhyML.h"
#include "UdmUtil.h"
#include "StatusDialog.h"

class CyPhyDSRefiner
{
public:
	CyPhyDSRefiner();
	CyPhyDSRefiner(CyPhyML::Configurations &cfgs);
	CyPhyDSRefiner(CyPhyML::Configurations &cfgs, set<CyPhyML::CWC> &cwcs);
	//~CyPhyDSRefiner();

	void runDSRefiner();
	CyPhyML::DesignContainer getRefinedDS();
	void startProgressBar();
	void endProgressBar();

private:
	CyPhyML::Configurations _cfgsModel;
	CyPhyML::DesignContainer _rootDS;
	CyPhyML::DesignContainer _newDS;
	set<CyPhyML::CWC> _cwcs;
	CStatusDialog prgDlg;

	UdmUtil::copy_assoc_map _udmcopyMap;
//	map<CyPhyML::DesignEntity, set<CyPhyML::DesignEntityRef> > designElemRefMap;
	set<CyPhyML::DesignEntity> _activeDesignEntities;
	set<CyPhyML::DecisionGroup> _allDecisionGroups;
	set<CyPhyML::DesignEntity> _groupEntities;
	set<CyPhyML::DesignContainer> _optionalContainers;

	void preProcessDS(CyPhyML::DesignContainer &dc);
	void createConstraint();
	void analyseDS(CyPhyML::DesignContainer &dc, set<CyPhyML::DesignEntity> &allDesignEntities);
	void processDecisionGroup(CyPhyML::DesignContainer &dc);
	void cleanDecisionGroup();

	Udm::Object getMappedObject(const Udm::Object &src_obj);
};

#endif