/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "EquHelper.h"

extern vector<TBGNode> BGNodeList; // flat bond graph

string EquHelper::GetOnCondition(CyPhyML::Junction junction)
{
	return EquHelper::replaceJunctionExpression(junction.OnCondition(), junction);
}

string EquHelper::GetOffCondition(CyPhyML::Junction junction)
{
	return EquHelper::replaceJunctionExpression(junction.OffCondition(), junction);
}

string EquHelper::replaceJunctionExpression(string value, CyPhyML::Junction junction)
{
	string ret = value;
	tr1::regex rx("");
	string fmt = "";

	set<CyPhyML::Switching2Junction> sw2j = junction.srcSwitching2Junction();

	for (set<CyPhyML::Switching2Junction>::const_iterator it = sw2j.begin();
		it != sw2j.end();
		++it)
	{
		rx = string(CyPhyML::MgaObject::Cast(it->srcSwitching2Junction_end()).name());
		fmt = EquHelper::getFunctionName(CyPhyML::MgaObject::Cast(it->srcSwitching2Junction_end()));
		ret = string(tr1::regex_replace(ret, rx, fmt));
	}

	set<CyPhyML::Signal2Junction> sig2j = junction.srcSignal2Junction();
	for (set<CyPhyML::Signal2Junction>::const_iterator it = sig2j.begin();
		it != sig2j.end();
		++it)
	{
		rx = string(CyPhyML::MgaObject::Cast(it->srcSignal2Junction_end()).name());
		fmt = EquHelper::getFunctionName(CyPhyML::MgaObject::Cast(it->srcSignal2Junction_end()));
		ret = string(tr1::regex_replace(ret, rx, fmt));
	}
	return ret;
}

string EquHelper::replaceExpression(CyPhyML::Switching sw)
{
	string ret = sw.SwExpression();
	tr1::regex rx("");
	string fmt = "";

	set<CyPhyML::Junction2Switching> j2sw = sw.srcJunction2Switching();
	for (set<CyPhyML::Junction2Switching>::const_iterator it = j2sw.begin();
		it != j2sw.end();
		++it)
	{
		CyPhyML::Junction junction = CyPhyML::Junction::Cast(it->srcJunction2Switching_end());

		stringstream ss;
		int bondId = -1;
		for (vector<TBGNode>::iterator itBGNodeList = BGNodeList.begin();
			itBGNodeList != BGNodeList.end();
			++itBGNodeList)
		{
			if (*(itBGNodeList->Ref) == junction)
			{
				bondId = itBGNodeList->BondMap.begin()->second.first->bondID;
				break;
			}
		}

		if (junction.type() == CyPhyML::ZeroJunction::meta)
		{
			ss << "e";
		}
		else if (junction.type() == CyPhyML::OneJunction::meta)
		{
			ss << "f";
		}
		ss << bondId;

		rx = string(CyPhyML::MgaObject::Cast(it->srcJunction2Switching_end()).name());
		fmt = ss.str();
		ret = string(tr1::regex_replace(ret, rx, fmt));
	}

	return ret;
}

string EquHelper::replaceExpression(CyPhyML::Modulation sw)
{
	string ret = sw.Expression();
	tr1::regex rx("");
	string fmt = "";

	set<CyPhyML::Junction2Modulation> j2sw = sw.srcJunction2Modulation();
	for (set<CyPhyML::Junction2Modulation>::const_iterator it = j2sw.begin();
		it != j2sw.end();
		++it)
	{
		CyPhyML::Junction junction = CyPhyML::Junction::Cast(it->srcJunction2Modulation_end());

		stringstream ss;
		int bondId = -1;
		for (vector<TBGNode>::iterator itBGNodeList = BGNodeList.begin();
			itBGNodeList != BGNodeList.end();
			++itBGNodeList)
		{
			if (*(itBGNodeList->Ref) == junction)
			{
				bondId = itBGNodeList->BondMap.begin()->second.first->bondID;
				break;
			}
		}

		if (junction.type() == CyPhyML::ZeroJunction::meta)
		{
			ss << "e";
		}
		else if (junction.type() == CyPhyML::OneJunction::meta)
		{
			ss << "f";
		}
		ss << bondId;

		rx = string(CyPhyML::MgaObject::Cast(it->srcJunction2Modulation_end()).name());
		fmt = ss.str();
		ret = string(tr1::regex_replace(ret, rx, fmt));
	}

	return ret;
}


string EquHelper::getFunctionName(CyPhyML::MgaObject obj)
{
	stringstream ss;
	ss << GetModifiedName(obj) << "_" << obj.uniqueId();
	return ss.str();
}

map<CyPhyML::Switching, string> EquHelper::GetBooleanParameters(CyPhyML::Junction junction)
{
	map<CyPhyML::Switching, string> ret;

	tr1::regex rx("");
	string fmt = "";
	string name = junction.name();
	set<CyPhyML::Switching2Junction> sw2j = junction.srcSwitching2Junction();

	for (set<CyPhyML::Switching2Junction>::const_iterator it = sw2j.begin();
		it != sw2j.end();
		++it)
	{
		CyPhyML::Switching sw = CyPhyML::Switching::Cast(it->srcSwitching2Junction_end());

		//rx = string(CyPhyML::MgaObject::Cast(it->srcSwitching2Junction_end()).name());
		//fmt = EquHelper::getFunctionName(CyPhyML::MgaObject::Cast(it->srcSwitching2Junction_end()));
		ret.insert(make_pair<CyPhyML::Switching, string>(sw, EquHelper::replaceExpression(sw)));// string(tr1::regex_replace(ret, rx, fmt));
	}

	//set<CyPhyML::Signal2Junction> sig2j = junction.srcSignal2Junction();
	//for (set<CyPhyML::Signal2Junction>::const_iterator it = sig2j.begin();
	//	it != sig2j.end();
	//	++it)
	//{
	//	rx = string(CyPhyML::MgaObject::Cast(it->srcSignal2Junction_end()).name());
	//	fmt = EquHelper::getFunctionName(CyPhyML::MgaObject::Cast(it->srcSignal2Junction_end()));
	//	ret.insert(make_pair<string, string>("", ""));// string(tr1::regex_replace(ret, rx, fmt));
	//}

	return ret;
}

map<string, string> EquHelper::GetFunctions(CyPhyML::Junction junction)
{
	map<string, string> ret;




	return ret;
}

// TODO: implement these functions as well
map<CyPhyML::Modulation, string> EquHelper::GetModulations(CyPhyML::BGModulatedElement modElement)
{
	map<CyPhyML::Modulation, string> ret;

	tr1::regex rx("");
	string fmt = "";
	set<CyPhyML::Modulation2BGMElement> sw2j = modElement.srcModulation2BGMElement();

	for (set<CyPhyML::Modulation2BGMElement>::const_iterator it = sw2j.begin();
		it != sw2j.end();
		++it)
	{
		CyPhyML::Modulation mod = CyPhyML::Modulation::Cast(it->srcModulation2BGMElement_end());
		ret.insert(make_pair<CyPhyML::Modulation, string>(mod, EquHelper::replaceExpression(mod)));
	}

	return ret;
}

string EquHelper::GetScope(CyPhyML::Junction junction)
{
	string ret = "";

	if (junction.type() == CyPhyML::OneJunction::meta)
	{
		CyPhyML::OneJunction one = CyPhyML::OneJunction::Cast(junction);

		set<CyPhyML::OneJunction2MonitorFlow> o2m = one.dstOneJunction2MonitorFlow();
		if (o2m.size() > 0)
		{
			ret = EquHelper::GetVariable(junction);
		}
	}
	else if (junction.type() == CyPhyML::ZeroJunction::meta)
	{
		CyPhyML::ZeroJunction zero = CyPhyML::ZeroJunction::Cast(junction);

		zero.dstZeroJunction2MonitorEffort();
		set<CyPhyML::ZeroJunction2MonitorEffort> o2m = zero.dstZeroJunction2MonitorEffort();
		if (o2m.size() > 0)
		{
			ret = EquHelper::GetVariable(junction);
		}
	}

	return ret;
}


string EquHelper::GetVariable(CyPhyML::Junction junction)
{
	stringstream ret;

	if (junction.type() == CyPhyML::OneJunction::meta)
	{
		ret << "f";
	}
	else if (junction.type() == CyPhyML::ZeroJunction::meta)
	{
		ret << "e";
	}

	for (vector<TBGNode>::const_iterator it = BGNodeList.begin();
		it != BGNodeList.end();
		++it)
	{
		if (*(it->Ref) == CyPhyML::BGNode::Cast(junction))
		{
			ret << it->BondMap.begin()->second.first->bondID;
			break;
		}
	}

	return ret.str();
}

map<CyPhyML::MgaObject, CyPhyML::MgaObject> EquHelper::GetSignalVariables(CyPhyML::Junction junction)
{
	map<CyPhyML::MgaObject, CyPhyML::MgaObject> ret;

	set<CyPhyML::Signal2Junction> sig2e = junction.srcSignal2Junction();

	for (set<CyPhyML::Signal2Junction>::const_iterator it = sig2e.begin();
		it != sig2e.end();
		++it)
	{
		CyPhyML::Signal sig = it->srcSignal2Junction_end();
		//ret.insert(make_pair<string, string>(EquHelper::getFunctionName(sig), ""));
		map<CyPhyML::MgaObject, CyPhyML::MgaObject> mm;
		mm = GetSignalVariables(sig, sig);
		for (map<CyPhyML::MgaObject, CyPhyML::MgaObject>::const_iterator itm = mm.begin();
			itm != mm.end();
			++itm)
		{
			ret.insert(*itm);
		}
	}

	return ret;
}

map<CyPhyML::MgaObject, CyPhyML::MgaObject> EquHelper::GetSignalVariables(CyPhyML::BGModulatedElement mod)
{
	map<CyPhyML::MgaObject, CyPhyML::MgaObject> ret;

	set<CyPhyML::Signal2BGMElement> sig2e = mod.srcSignal2BGMElement();

	for (set<CyPhyML::Signal2BGMElement>::const_iterator it = sig2e.begin();
		it != sig2e.end();
		++it)
	{
		CyPhyML::Signal sig = it->srcSignal2BGMElement_end();
		//ret.insert(make_pair<string, string>(EquHelper::getFunctionName(sig), GetParameterName(CyPhyML::BGElement::Cast(mod))));
		map<CyPhyML::MgaObject, CyPhyML::MgaObject> mm;
		mm = GetSignalVariables(sig, sig);
		for (map<CyPhyML::MgaObject, CyPhyML::MgaObject>::const_iterator itm = mm.begin();
			itm != mm.end();
			++itm)
		{
			ret.insert(*itm);
		}
	}

	return ret;
}

map<CyPhyML::MgaObject, CyPhyML::MgaObject> EquHelper::GetSignalVariables(CyPhyML::Signal signal, CyPhyML::Signal origin)
{
	map<CyPhyML::MgaObject, CyPhyML::MgaObject> ret;

	bool hasLoop = false;

	// go through all connected signal
	set<CyPhyML::SignalConnection> sig2e = signal.srcSignalConnection();

	for (set<CyPhyML::SignalConnection>::const_iterator it = sig2e.begin();
		it != sig2e.end();
		++it)
	{
		CyPhyML::Signal sig = it->srcSignalConnection_end();
		if (sig == origin)
		{
			hasLoop = true;
			break;
		}
		ret.insert(make_pair<CyPhyML::MgaObject, CyPhyML::MgaObject>(signal, sig));
		map<CyPhyML::MgaObject, CyPhyML::MgaObject> mm;
		mm = GetSignalVariables(sig, origin);
		for (map<CyPhyML::MgaObject, CyPhyML::MgaObject>::const_iterator itm = mm.begin();
			itm != mm.end();
			++itm)
		{
			ret.insert(*itm);
		}

	}

	// get sensing (De Df) elements
	set<CyPhyML::Sensing2Signal> sensing = signal.srcSensing2Signal();

	for (set<CyPhyML::Sensing2Signal>::const_iterator it = sensing.begin();
		it != sensing.end();
		++it)
	{
		CyPhyML::Sensing sense = it->srcSensing2Signal_end();
		if (sense.type() == CyPhyML::De::meta)
		{
			set<CyPhyML::ZeroJunction2De> zj2de = CyPhyML::De::Cast(sense).srcZeroJunction2De();
			if (zj2de.size() == 1)
			{
				CyPhyML::Junction junction = zj2de.begin()->srcZeroJunction2De_end();
				ret.insert(make_pair<CyPhyML::MgaObject, CyPhyML::MgaObject>(sense, junction));
				ret.insert(make_pair<CyPhyML::MgaObject, CyPhyML::MgaObject>(signal, sense));
			}
			else
			{
				// TODO: handling error
			}
		}
		else if (sense.type() == CyPhyML::Df::meta)
		{
			set<CyPhyML::OneJunction2Df> oj2df = CyPhyML::Df::Cast(sense).srcOneJunction2Df();
			if (oj2df.size() == 1)
			{
				CyPhyML::Junction junction = oj2df.begin()->srcOneJunction2Df_end();
				ret.insert(make_pair<CyPhyML::MgaObject, CyPhyML::MgaObject>(sense, junction));
				ret.insert(make_pair<CyPhyML::MgaObject, CyPhyML::MgaObject>(signal, sense));
			}
			else
			{
				// TODO: handling error
			}
		}
	}


	// go through the control functions
	set<CyPhyML::ControlFunction2Signal> sf2sig = signal.srcControlFunction2Signal();

	for (set<CyPhyML::ControlFunction2Signal>::const_iterator it = sf2sig.begin();
		it != sf2sig.end();
		++it)
	{
		CyPhyML::ControlFunction cf = it->srcControlFunction2Signal_end();

		set<CyPhyML::Signal2ControlFunction> s2cf = cf.srcSignal2ControlFunction();
		
		string parameters = ""; // stores the function call input parameters

		for (set<CyPhyML::Signal2ControlFunction>::const_iterator itt = s2cf.begin();
			itt != s2cf.end();
			++itt)
		{
			CyPhyML::Signal sig = itt->srcSignal2ControlFunction_end();
			map<CyPhyML::MgaObject, CyPhyML::MgaObject> mm;
			mm = GetSignalVariables(sig, origin);

			for (map<CyPhyML::MgaObject, CyPhyML::MgaObject>::const_iterator itm = mm.begin();
				itm != mm.end();
				++itm)
			{
				ret.insert(*itm);
			}
			if (mm.empty())
			{
				ret.insert(make_pair<CyPhyML::MgaObject, CyPhyML::MgaObject>(sig, NULL));
			}

		}

		ret.insert(make_pair<CyPhyML::MgaObject, CyPhyML::MgaObject>(signal, cf));
	}

	if (Udm::IsDerivedFrom(signal.type(), CyPhyML::InSignal::meta))
	{
		// Parameters/Properties
		set<CyPhyML::ValueFlow2SignalPort> vf2s = CyPhyML::InSignal::Cast(signal).srcValueFlow2SignalPort();
		for (set<CyPhyML::ValueFlow2SignalPort>::const_iterator it = vf2s.begin();
			it != vf2s.end();
			++it)
		{
			ret.insert(make_pair<CyPhyML::MgaObject, CyPhyML::MgaObject>(it->srcValueFlow2SignalPort_end(), signal));
		}

	}
	ret.insert(make_pair<CyPhyML::MgaObject, CyPhyML::MgaObject>(signal, NULL));
	return ret;
}

string EquHelper::GetParameterName(CyPhyML::BGElement element)
{
	stringstream ss;
	ss << "Parameter_" << element.uniqueId() << "_" << GetModifiedName(element);
	return ss.str();
}


//map<string, string> EquHelper::GetFunctions(CyPhyML::BGModulatedElement modElement)
//{
//	map<string, string> ret;
//
//
//
//
//	return ret;
//}