/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "Log.h"
#include "Message.h"
#include <queue>

extern ScriptFile sfFile; // output script file and datastructure file
extern priority_queue<Message> pqMessages;

Log::Log()
{
	this->Init();
}

Log::~Log()
{
	if (this->log_file_.is_open())
	{
		// footer
		string szNewLine;

		szNewLine =  "============================================================";
		GMEConsole::Console::Out::writeLine(szNewLine);
		this->log_file_ << szNewLine;
		this->log_file_ << endl;
		szNewLine = "Summary: ";

		char buff[33];
		int r=10;
		_itoa_s(this->uinError, buff, r);
		szNewLine += string(buff);
		szNewLine += " error";
		if (this->uinError > 1)
		{
			szNewLine += "s";
		}
		szNewLine += ", ";
		_itoa_s(this->uinWarning, buff, r);
		szNewLine += string(buff);
		szNewLine += " warning";
		if (this->uinWarning > 1)
		{
			szNewLine += "s";
		}
		szNewLine += ", ";
		_itoa_s(this->uinInfo, buff, r);
		szNewLine += string(buff);
		szNewLine += " info";
		if (this->uinInfo > 1)
		{
			szNewLine += "s";
		}
		szNewLine += ", ";
		_itoa_s(this->uinNormal, buff, r);
		szNewLine += string(buff);
		szNewLine += " message";
		if (this->uinNormal > 1)
		{
			szNewLine += "s";
		}
		szNewLine += ".";
		GMEConsole::Console::Out::writeLine(szNewLine);
		this->log_file_ << szNewLine;
		this->log_file_ << endl;
		szNewLine = "============================================================";
		GMEConsole::Console::Out::writeLine(szNewLine);
		this->log_file_ << szNewLine;
		this->log_file_ << endl;
		if (this->uinError > 1)
		{
			// TODO: sfFile should be deleted
			// TODO: delete generated files if necessary
			szNewLine = "====ERROR OCCURED - NO OUTPUT FILES HAVE BEEN GENERATED!====";
			GMEConsole::Console::Out::writeLine(szNewLine);
			this->log_file_ << szNewLine;
			this->log_file_ << endl;
			szNewLine = "============================================================";
			GMEConsole::Console::Out::writeLine(szNewLine);
			this->log_file_ << szNewLine;
			this->log_file_ << endl;
		}

		this->log_file_.close();
	}
}

void Log::Init()
{
	string szNewLine;

	this->uinError = 0;
	this->uinInfo = 0;
	this->uinNormal = 0;
	this->uinWarning = 0;

	if ((sfFile.szModelName != "") &&
			(!(this->log_file_.is_open())))
	{
		// szModelName is specified
		string szLogFile;

		szLogFile = sfFile.szModelName;
		szLogFile += ".log";												// extension
		szLogFile = sfFile.OutputDirectory + szLogFile;
		remove(szLogFile.c_str());									// delete file if exists
		this->log_file_.open(szLogFile.c_str()); // create the new file

		// header
		//string szNewLine;

		szNewLine =  "============================================================";
		// TODO: separate the case when GME is not running
		GMEConsole::Console::Out::writeLine(szNewLine);
		this->log_file_ << szNewLine;
		this->log_file_ << endl;
		szNewLine = "======== Starting CyPhyDynamics interpreter =============";
		GMEConsole::Console::Out::writeLine(szNewLine);
		this->log_file_ << szNewLine;
		this->log_file_ << endl;
		szNewLine = "============================================================";
		GMEConsole::Console::Out::writeLine(szNewLine);
		this->log_file_ << szNewLine;
		this->log_file_ << endl;
	}
}

void Log::Flush()
{
	this->Init();
	// TODO: separate the case when GME is not running
	this->log_file_ << endl;

	while(!pqMessages.empty())
	{
		GMEConsole::Console::writeLine( pqMessages.top().GetMessageA(),
																		pqMessages.top().GetPriority());

		this->log_file_ << pqMessages.top().GetMessageA();
		this->log_file_ << endl;

		switch (pqMessages.top().GetPriority())
		{
			case MSG_NORMAL:
				this->uinNormal++;
				break;		
			case MSG_INFO:
				this->uinInfo++;
				break;
			case MSG_WARNING:
				this->uinWarning++;
				break;
			case MSG_ERROR:
				this->uinError++;
				break;
		}
		pqMessages.pop();
	}
}
