/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef _LOG_H_
#define _LOG_H_

#include <fstream>
#include "ScriptFile.h"

// This class creates the logs into the GME console and into a specific logfile
class Log
{
public:
	/// <summary> # of Normal messages </summary>
	unsigned int uinNormal;  // # of Normal messages
	/// <summary> # of Warning messages </summary>
	unsigned int uinWarning; // # of Warning messages
	/// <summary> # of Info messages </summary>
	unsigned int uinInfo;    // # of Info messages
	/// <summary> # of Error messages </summary>
	unsigned int uinError;   // # of Error messages
	
	// Constructor:
	// Call the Init function.
	Log();

	// Destructor:
	// If the file is open, write the footer and the summary, then close
	// the file stream.
	~Log();

	// Write all the messages from the pqMessages into the log file and
	// into the GME Console.
	void Flush();

private:
	ofstream log_file_; // log file

	// creates the log file, initializes the variables, prints the header
	// into GME and into the log file
	void Init();
};

#endif // _LOG_H_