/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// MDAODialog.cpp : implementation file
//

#include "stdafx.h"
#include "MDAODialog.h"
#include "afxdialogex.h"
#include "Graph.h"
#include <iostream>
#include <fstream>
#include <string>

extern map<string, string> MDAOInput;   // Tunable parameters of the system (current)
extern set<string> MDAOParameter;   // Tunable parameters of the system (OLD)
extern map<string, string> MDAOOutput;      // MDAO Output final output variables after the postprocessing
extern set<string> SimulinkSystemNames; // Referenced simulink block/system names

// MDAODialog dialog

IMPLEMENT_DYNAMIC(MDAODialog, CDialog)

MDAODialog::MDAODialog(CWnd* pParent /*=NULL*/)
	: CDialog(MDAODialog::IDD, pParent)
{

}

MDAODialog::~MDAODialog()
{
}

void MDAODialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_INPUT, InputParameters);
	DDX_Control(pDX, IDC_EDIT_OUTPUT, OutputParameters);
	DDX_Control(pDX, IDC_STATIC_LIST_OUT, DetectedOutput);
}

BOOL MDAODialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	LPCSTR strDetected = "";
	string szLines = "";
	for (map<string, string>::iterator it = MDAOInput.begin();
		it != MDAOInput.end();
		++it)
	{
		szLines += it->first;
		szLines += "\r\n";
	}

	strDetected = (LPCTSTR)szLines.c_str();
	this->InputParameters.SetWindowTextA(strDetected);

	szLines = "";
	for (map<string, string>::iterator it = MDAOOutput.begin();
		it != MDAOOutput.end();
		++it)
	{
		szLines += it->first;
		szLines += "\r\n";
	}
	strDetected = (LPCTSTR)szLines.c_str();
	this->OutputParameters.SetWindowTextA(strDetected);
	return TRUE;
}

BEGIN_MESSAGE_MAP(MDAODialog, CDialog)
	ON_BN_CLICKED(IDOK, &MDAODialog::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BTN_DISCOVER, &MDAODialog::OnBnClickedBtnDiscover)
END_MESSAGE_MAP()


// MDAODialog message handlers


void MDAODialog::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here
	CString szInput;
	CString szOutput;
	this->InputParameters.GetWindowTextA(szInput);
	this->OutputParameters.GetWindowTextA(szOutput);

	if (szInput == "")
	{
		AfxMessageBox("There is no input parameter defined. Please provide at least one input parameter!");
		return;
	}
	CDialog::OnOK();

	CAtlString resToken;
	int curPos = 0;

	MDAOParameter.clear();

	resToken= szInput.Tokenize(_T("\n\r"), curPos);
	while (resToken != _T(""))
	{
		if (resToken != "")
		{
			MDAOParameter.insert(resToken);
		}
		resToken = szInput.Tokenize(_T("\n\r"), curPos);
	};
	
	curPos = 0;

	MDAOOutput.clear();

	resToken= szOutput.Tokenize(_T("\n\r"), curPos);
	while (resToken != _T(""))
	{
		if (resToken != "")
		{
			MDAOOutput.insert(make_pair<string, string>(resToken.GetString(), ""));
		}
		resToken = szOutput.Tokenize(_T("\n\r"), curPos);
	};
}

void MDAODialog::OnBnClickedBtnDiscover()
{
	// TODO: Add your control notification handler code here

	ofstream ofDiscover ("Discover_Systems.tmp");
	if (ofDiscover.is_open())
	{
		for (set<string>::iterator it = SimulinkSystemNames.begin();
			it != SimulinkSystemNames.end();
			++it)
		{
			ofDiscover << *it;
			ofDiscover << endl;
		}
		ofDiscover.close();
	}
	else
	{
		// TODO: Unable to open file
	}

	string szCommand = "";
	szCommand = "matlab -nosplash -nodesktop -wait -r Discover_MDAO_Inputs_Outputs";
	int error_code = system(szCommand.c_str());
	if (error_code != 0)
	{
		string szExceptionTxt = "";
		szExceptionTxt += "The following command failed: \r\n";
		szExceptionTxt += szCommand;
		szExceptionTxt += "\r\n\r\nMake sure that MatLab is installed on your machine.";
		szExceptionTxt += " If it is not, you cannot use this feature.";
		AfxMessageBox(szExceptionTxt.c_str());
		//throw udm_exception(szExceptionTxt);
		return;
	}

	string line;
	string szLines = "";
	LPCSTR strDetected;
	ifstream ifDetectedOut("Discover_MDAO_Outputs_Default.txt");
	if (ifDetectedOut.is_open())
	{
		int i = 0;
		while ( ifDetectedOut.good() )
		{
			getline(ifDetectedOut, line);
			szLines += line;
			szLines += "\r\n";
		}
		ifDetectedOut.close();
	}
	else
	{
		// TODO: Unable to open file
	}

	strDetected = (LPCTSTR)szLines.c_str();
	this->OutputParameters.SetWindowTextA(strDetected);
	//this->DetectedOutput.SetWindowTextA(strDetected);

	szLines = "";
	ifstream ifDetectedIn("Discover_MDAO_Inputs_Default.txt");
	if (ifDetectedIn.is_open())
	{
		int i = 0;
		while ( ifDetectedIn.good() )
		{
			getline(ifDetectedIn, line);
			if (MDAOInput.find(line) == MDAOInput.end())
			{
				szLines += line;
				szLines += "\r\n";
			}
		}
		ifDetectedIn.close();
	}
	else
	{
		// TODO: Unable to open file
	}
	if (szLines != "")
	{
		szLines = szLines.substr(0, szLines.length()-2);
	}

	for (map<string, string>::iterator it = MDAOInput.begin();
		it != MDAOInput.end();
		++it)
	{
		szLines += it->first;
		szLines += "\r\n";
	}

	strDetected = (LPCTSTR)szLines.c_str();
	this->InputParameters.SetWindowTextA(strDetected);

}
