/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "MdaoBase.h"
#include <direct.h>

extern string OutputDir;

MdaoBase::MdaoBase(void)
{
	if (RelPath == "")
	{
		RelPath = "python";
	}
	InitBaseClasses();
	InitImports();
}

MdaoBase::MdaoBase(string SubDirName)
{
	if (RelPath == "")
	{
		RelPath = SubDirName;
	}
	MdaoBase::MdaoBase();
}

MdaoBase::~MdaoBase(void)
{
}

void MdaoBase::InitBaseClasses()
{
	//BaseClasses.push_back("BaseTest");
}

void MdaoBase::InitImports()
{
	Imports.insert(make_pair("Float", "openmdao.lib.datatypes.api"));
}

void MdaoBase::PrintImports()
{
	for (map<string, string>::iterator it = Imports.begin();
		it != Imports.end();
		++it)
	{
		py.CreateImport(it->first, it->second);
	}
	//py.CreateEmptyLine();
}

void MdaoBase::PrintClassDef()
{
	py.CreateClass(Name, BaseClasses);
	py.CreateDocComment("Documentation comment for this Assembly.");
	py.CreateEmptyLine();
}

void MdaoBase::PrintPython()
{
	py.CreateFile(OutputDir + RelPath, Name);
	py.CreateComment(Python::HorizontalDelimiter);
	py.CreateComment("Auto generated python code for OpenMDAO");
	py.CreateComment(Python::HorizontalDelimiter);
}

void MdaoBase::PrintInputs()
{
	string Code = "";
	py.CreateComment("input (parameters) definitions");
	for (map<string, string>::iterator it = Inputs.begin();
		it != Inputs.end();
		++it)
	{
		Code = "";
		Code += it->first;
		Code += " = Float(";
		if (it->second == "")
		{
			Code += "0.0";
		}
		else
		{
			Code += it->second;
			if (it->second.find(".") == string::npos)
			{
				Code += ".0";
			}
		}
		Code += ", iotype='in', desc='";
		Code += it->first;
		Code += "')";

		py.CreateCodeLine(Code);
	}
	py.CreateEmptyLine();
}

void MdaoBase::PrintOutputs()
{
	string Code = "";
	py.CreateComment("output (parameters) definitions");
	for (map<string, string>::iterator it = Outputs.begin();
		it != Outputs.end();
		++it)
	{
		Code = "";
		Code += it->first;
		Code += " = Float(";
		if (it->second == "")
		{
			Code += "0.0";
		}
		else
		{
			Code += it->second;
			if (it->second.find(".") == string::npos)
			{
				Code += ".0";
			}
		}
		Code += ", iotype='out', desc='";
		Code += it->first;
		Code += "')";

		py.CreateCodeLine(Code);
	}
	py.CreateEmptyLine();
}
