/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#pragma once
#include <string>
#include <map>
#include <vector>
#include <iostream>
#include <fstream>
#include "Python.h"

using namespace std;

class MdaoBase
{
public:
  MdaoBase(void);

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Initializes a new instance of the MdaoBase class. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ///
  /// <param name="SubDirName"> Pathname of the sub directory. </param>
  ////////////////////////////////////////////////////////////////////////////////

  MdaoBase(string SubDirName);
  ~MdaoBase(void);

  /// <summary> The imports [class name, filename/namespace] </summary>
  map<string, string> Imports;

  /// <summary> The name </summary>
  string Name;

  /// <summary> Name of the instance </summary>
  string InstanceName;

  /// <summary> The inputs [name, default value]</summary>
  map<string, string> Inputs;
  // 
  /// <summary> The outputs [name, default value]</summary>
  map<string, string> Outputs;

  /// <summary> The base classes </summary>
  vector<string> BaseClasses;

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Print python. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ////////////////////////////////////////////////////////////////////////////////

  void PrintPython();

protected:
  /// <summary> Path of the output directory </summary>
  string RelPath;

  /// <summary> Python object to create the python script. </summary>
  Python py;

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Initialises the base classes. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ////////////////////////////////////////////////////////////////////////////////

  void InitBaseClasses();

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Initialises the imports. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ////////////////////////////////////////////////////////////////////////////////

  void InitImports();

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Print imports. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ////////////////////////////////////////////////////////////////////////////////

  void PrintImports();

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Print class definition for this class call it ONLY once. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ////////////////////////////////////////////////////////////////////////////////

  void PrintClassDef();

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Print inputs. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ////////////////////////////////////////////////////////////////////////////////

  void PrintInputs();

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Print outputs. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ////////////////////////////////////////////////////////////////////////////////

  void PrintOutputs();
};

