/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef _MESSAGE_H_
#define _MESSAGE_H_

#include "UdmConsole.h"

// Priority queue message class for Error, Warning, Info, and Normal messages.
class Message
{
	friend ostream& operator<<(ostream&, const Message&);
public:
	typedef msgtype_enum priority_type; // typedef of the priority of the messages
private:
	string message; // message's text
	priority_type priority; // message's priority
public:
	Message(string message,
		priority_type priority=MSG_NORMAL):
	message(message),
		priority(priority)
	{}

	// comparison based on the priority
	bool operator < (const Message& right)const
	{
		return priority < right.priority;
	}

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> Gets the message. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	///
	/// <returns> The message. </returns>
	////////////////////////////////////////////////////////////////////////////////

	string GetMessage() { return message; }

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> Gets the priority. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	///
	/// <returns> The priority. </returns>
	////////////////////////////////////////////////////////////////////////////////

	priority_type GetPriority() { return priority; }
};

#endif // _MESSAGE_H_