/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// TODO: review
#pragma once
#include "CyPhyML.h"
#include "Graph.h"
#include "PortNumbers.h"

// This class helps to create the MatLab connections. Each element, which
// should be a port inside MatLab, has a PortNumber. If one would like to 
// make a connection between this element and another on a higher level.
// We can find the actual port number in this structure
// e.g.
//  ----------
// |          |
// |       P1 |
// |       P5-|---->Q2
// |          |
//  ----------
//    Comp1
// The connection between P5 and Q2:
//  - P5 has a parent called Comp1.
//  - P5 is mapped into the second (2) port.
// The connection is the following:
//  - Path: Q2.ParentPath
//  - Source: Comp1/2
//  - Destination: Q2/1

////////////////////////////////////////////////////////////////////////////////
/// <summary>
///  This class helps to create the MatLab connections. Each element, which 
///  should be a port inside MatLab, has a PortNumber. If one would like to 
///  make a connection between this element and another on a higher level. 
///  We can find the actual port number in this structure 
///  - ----------
///  - |          |
///  - |       P1 |
///  - |       P5-|---->Q2
///  - |          |
///  - ---------- 
///  -    Comp1
///  - The connection between P5 and Q2:
///   - P5 has a parent called Comp1. 
///   - P5 is mapped into the second (2) port.
///  - The connection is the following: 
///   - Path: Q2.ParentPath 
///   - Source: Comp1/2
///   - Destination: Q2/1.
/// </summary>
///
/// <remarks> Zsolt, 8/16/2011. </remarks>
////////////////////////////////////////////////////////////////////////////////

class PortMapping
{
private:
	long uniqueID;
	unsigned int PortNumber;
	std::string parentpath;
	std::string parentname;
	std::string name;
	std::string uniqueName;
public:
	PortMapping(long uniqueID,
				unsigned int PortNumber,
				std::string parentpath,
				std::string parentname,
				std::string name)
	{
		this->uniqueID = uniqueID;
		this->PortNumber = PortNumber;
		this->parentpath = parentpath;
		this->parentname = parentname;
		this->name = name;
		this->uniqueName = name;
	}

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> Gets the unique identifier. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	///
	/// <returns> The unique identifier. </returns>
	////////////////////////////////////////////////////////////////////////////////

	long GetUniqueID() {return this->uniqueID;}

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> Gets the port number. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	///
	/// <returns> The port number. </returns>
	////////////////////////////////////////////////////////////////////////////////

	unsigned int GetPortNumber() {return this->PortNumber;}

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> Gets the parent path. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	///
	/// <returns> The parent path. </returns>
	////////////////////////////////////////////////////////////////////////////////

	string GetParentPath() {return this->parentpath;}

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> Gets the path. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	///
	/// <returns> The path. </returns>
	////////////////////////////////////////////////////////////////////////////////

	string GetPath() {return (this->parentpath + "/" + this->parentname);}

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> Gets the parent name. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	///
	/// <returns> The parent name. </returns>
	////////////////////////////////////////////////////////////////////////////////

	string GetParentName() {return this->parentname;}

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> Gets the name. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	///
	/// <returns> The name. </returns>
	////////////////////////////////////////////////////////////////////////////////

	string GetName() {return this->name;}

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> Gets the unique name. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	///
	/// <returns> The unique name. </returns>
	////////////////////////////////////////////////////////////////////////////////

	string GetUniqueName() {return this->uniqueName;}
};