/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// TODO: review
#pragma once
#include "CyPhyML.h"

////////////////////////////////////////////////////////////////////////////////
/// <summary>
///  Used for storing the number of inputs and outputs of a subsystem
///  - o - Subsystem
///  - in/out - current # of contained powerports
///  - signalIN/signalOUT - current # of contained signal ports
/// </summary>
///
/// <remarks> Zsolt, 8/16/2011. </remarks>
////////////////////////////////////////////////////////////////////////////////

class PortNumbers
{
public:
	/// <summary> current # of contained powerports </summary>
	unsigned int in;
	/// <summary> current # of contained powerports must equal with in.</summary>
	unsigned int out;
	/// <summary> current # of contained input signal ports </summary>
	unsigned int signalIN;
	/// <summary> current # of contained output signal ports </summary>
	unsigned int signalOUT;
	/// <summary> The object which has these ports. </summary>
	Udm::Object o;
	PortNumbers(Udm::Object o) :
								in(0),
								out(0),
								o(o),
								signalIN(0),
								signalOUT(0) { }
};