/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "Python.h"

// define keywords
string Python::m_ClassKeyWord = "class";
string Python::m_FunctionKeyWord = "def";
string Python::m_ImportKeyWord = "import";
string Python::m_FromKeyWord = "from";
string Python::HorizontalDelimiter = \
	"===========================================================================";

Python::Python(void)
{
	m_Depth = 0;
}

Python::~Python(void)
{
	m_File.close();
}

void Python::CreateFile(
	string SubDirName,
	string FileName)
{
	// create subdir if it does not exist
	string RelPath;
	RelPath = SubDirName;
	RelPath += "\\";
	_mkdir(RelPath.c_str());

	// remove .py file if exists
	// create and open a new .py file
	string szFileName = "";
	szFileName = RelPath;
	szFileName += FileName;
	szFileName += ".py";

	remove(szFileName.c_str());
	m_File.open(szFileName); // open
}

string  Python::CreateImport(
	string ClassName,
	string PackageName)
{
	stringstream out;
	out << Indent();
	if (PackageName == "")
	{
		out << m_ImportKeyWord << " " << ClassName << endl;
	}
	else
	{
		out << m_FromKeyWord << " " << PackageName;
		out << " " << m_ImportKeyWord << " " << ClassName << endl;
	}
	m_File << out.str();
	return out.str();
}

string Python::CreateFunction(
	string FunctionName,
	string ParameterNames,
	bool IsGlobal)
{
	stringstream out;
	out << Indent();
	out << m_FunctionKeyWord << " " << FunctionName;
	out << "(";
	if (!IsGlobal)
	{
		out << "self";
		if (ParameterNames != "")
		{
			out << ", ";
		}
	}
	out << ParameterNames;
	out << "):" << endl;
	m_Depth++;
	m_File << out.str();
	return out.str();
}

string Python::CreateCodeLine(
	string Code,
	bool IdentNewLine)
{
	stringstream out;
	out << Indent();
	out << Code << endl;
	if (IdentNewLine)
	{
		m_Depth++;
	}
	m_File << out.str();
	return out.str();
}

string Python::CreateComment(
	string CommentText,
	unsigned int NumCommentChars)
{
	stringstream out;
	out << Indent();
	if (NumCommentChars < 1)
	{
		NumCommentChars = 1;
	}
	for (unsigned int i = 0; i < NumCommentChars; ++i)
	{
		out << m_CommentChar;
	}
	out << " " << CommentText << endl;
	m_File << out.str();
	return out.str();
}

string Python::CreateDocComment(
	string DocComment)
{
	stringstream out;
	out << Indent();
	for (unsigned int i = 0; i < m_NumDocChars; ++i)
	{
		out << m_DocCommentChar;
	}
	out << " ";
	out << DocComment;
	out << " ";
	for (unsigned int i = 0; i < m_NumDocChars; ++i)
	{
		out << m_DocCommentChar;
	}
	out << endl;

	m_File << out.str();
	return out.str();
}

string Python::CreateEmptyLine()
{
	stringstream out;
	out << Indent();
	out << endl;
	m_File << out.str();
	return out.str();
}

string Python::CloseSection(
	string Comment)
{
	stringstream out;
	if (m_Depth != 0)
	{
		m_Depth--;
	}
	if (Comment != "")
	{
		// Create comment write it into the file
		out << Python::CreateComment("End " + Comment);
	}
	else
	{
		out << Indent();
		out << endl;
		m_File << out.str();
	}
	return out.str();
}

string Python::CreateClass(
	string ClassName,
	string BaseClassName)
{
	stringstream out;
	out << Indent();
	out << m_ClassKeyWord << " " << ClassName;
	out << "(" << BaseClassName << "):" << endl;
	m_Depth++;
	m_File << out.str();
	return out.str();
}

string Python::CreateClass(
	string ClassName,
	vector<string> BaseClassNames,
	bool Reverse)
{
	string szBaseClasses = "";
	if (Reverse)
	{
		for (vector<string>::reverse_iterator it = BaseClassNames.rbegin();
			it != BaseClassNames.rend();
			++it)
		{
			szBaseClasses += *it;
			if (++it != BaseClassNames.rend())
			{
				szBaseClasses += ", ";
			}
			--it;
		}
	}
	else
	{
		for (vector<string>::iterator it = BaseClassNames.begin();
			it != BaseClassNames.end();
			++it)
		{
			szBaseClasses += *it;
			if (++it != BaseClassNames.end())
			{
				szBaseClasses += ", ";
			}
			--it;
		}
	}
	return CreateClass(ClassName, szBaseClasses);
}


string Python::Indent()
{
	stringstream out;
	// print the ident char based on the current depth
	for(unsigned int i = 0; i < m_Depth*m_NumIndentChar; ++i)
	{
		out << m_IndentChar;
	}
	return out.str();
}

