/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#pragma once
#include <string>
#include <sstream>
#include <direct.h>
#include <fstream>
#include <vector>

using namespace std;

class Python
{
public:
  Python(void);
  ~Python(void);

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Creates a file. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ///
  /// <param name="SubDirName"> Pathname of the sub directory. </param>
  /// <param name="FileName">   Filename of the file. </param>
  ////////////////////////////////////////////////////////////////////////////////

  void CreateFile(
    string SubDirName,
    string FileName);

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Creates an import.
	/// <para>"from PackageName import ClassName"</para>
	/// <para>"import ClassName"</para>
	/// </summary>
  ///
  /// <remarks> Zsolt, 7/16/2011. </remarks>
  ///
  /// <param name="ClassName">   Name of the class. </param>
  /// <param name="PackageName"> (optional) name of the package. </param>
  ///
  /// <returns> . </returns>
  ////////////////////////////////////////////////////////////////////////////////

  string  CreateImport(
    string ClassName,
    string PackageName = "");

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Creates the class. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ///
  /// <param name="ClassName">     Name of the class. </param>
  /// <param name="BaseClassName"> (optional) name of the base class. </param>
  ///
  /// <returns> . </returns>
  ////////////////////////////////////////////////////////////////////////////////

  string CreateClass(
    string ClassName,
    string BaseClassName = "");

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Creates the class. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ///
  /// <param name="ClassName">      Name of the class. </param>
  /// <param name="BaseClassNames"> List of names of the base class. </param>
  /// <param name="Reverse">        (optional) the reverse. </param>
  ///
  /// <returns> . </returns>
  ////////////////////////////////////////////////////////////////////////////////

  string CreateClass(
    string ClassName,
    vector<string> BaseClassNames,
    bool Reverse = false);

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Creates a function. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ///
  /// <param name="FunctionName">	  Name of the function. </param>
  /// <param name="ParameterNames"> List of names of the parameters. </param>
  /// <param name="IsGlobal">			  (optional) the is global. </param>
  ///
  /// <returns> . </returns>
  ////////////////////////////////////////////////////////////////////////////////

  string CreateFunction(
    string FunctionName,
    string ParameterNames = "",
    bool IsGlobal = false);

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Creates a code line. </summary>
  ///
  /// <remarks> Zsolt, 7/16/2011. </remarks>
  ///
  /// <param name="Code"> The code. </param>
  ///
  /// <returns> . </returns>
  ////////////////////////////////////////////////////////////////////////////////

  string CreateCodeLine(
    string Code,
    bool IdentNewLine = false);

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Creates a comment. Using # Comment format. </summary>
  ///
  /// <remarks> Zsolt, 7/16/2011. </remarks>
  ///
  /// <param name="CommentText">     The comment text. </param>
  /// <param name="NumCommentChars">
  ///  (optional) number of comment characters. >=1
  /// </param>
  ///
  /// <returns> . </returns>
  ////////////////////////////////////////////////////////////////////////////////

  string CreateComment(
    string CommentText,
    unsigned int NumCommentChars = 1);

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Creates a document comment. Using "DocComment" format. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ///
  /// <param name="DocComment"> The document comment. </param>
  ///
  /// <returns> . </returns>
  ////////////////////////////////////////////////////////////////////////////////

  string CreateDocComment(
    string DocComment);

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Creates an empty line. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ///
  /// <returns> . </returns>
  ////////////////////////////////////////////////////////////////////////////////

  string CreateEmptyLine();

  ////////////////////////////////////////////////////////////////////////////////
  /// <summary> Closes a section. </summary>
  ///
  /// <remarks> Zsolt, 7/18/2011. </remarks>
  ///
  /// <param name="Comment"> (optional) the comment. </param>
  ///
  /// <returns> . </returns>
  ////////////////////////////////////////////////////////////////////////////////

  string CloseSection(
    string Comment = "");

  /// <summary> The horizontal delimiter </summary>
  static string HorizontalDelimiter;

private:

  ofstream m_File;

  /// <summary> The depth </summary>
  unsigned int m_Depth;

  string Indent();

  /// <summary> The class key word </summary>
  static string m_ClassKeyWord;

  /// <summary> The function key word </summary>
  static string m_FunctionKeyWord;

  /// <summary> The import key word </summary>
  static string m_ImportKeyWord;

  /// <summary> from key word </summary>
  static string m_FromKeyWord;

  /// <summary> The comment character </summary>
  static const char m_CommentChar = '#';

  /// <summary> The document comment character </summary>
  static const char m_DocCommentChar = '"';
  /// <summary> Number of document characters </summary>
  static const unsigned int m_NumDocChars = 3;

  /// <summary> Number of identifier characters </summary>
  static const unsigned int m_NumIndentChar = 4;
  /// <summary> The identifier character </summary>
  static const char m_IndentChar = ' ';
};