/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// SimulinkDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SimulinkDlg.h"
#include "Graph.h"
#include "UdmBase.h"

extern string OutputDir;
extern string ModelName;
extern string DependencyDir;

extern set<Udm::Object> SelectedObj;
extern bool bMDAO;
extern bool bUseESMoL;
extern bool bSilentMode;
extern bool bAlgLoops;
bool bCanceledByUser = false;

// CSimulinkDlg dialog

IMPLEMENT_DYNAMIC(CSimulinkDlg, CDialog)

CSimulinkDlg::CSimulinkDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSimulinkDlg::IDD, pParent)
{

}

CSimulinkDlg::~CSimulinkDlg()
{
}

void CSimulinkDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CHBMDAO, m_MDAO);
	DDX_Control(pDX, IDC_CHBSILENT, m_Silent);
	DDX_Control(pDX, IDC_USE_ESMOL, m_UseESMoL);

	DDX_Control(pDX, IDC_LISTTOPROCESS, lbToProcess);
	DDX_Control(pDX, IDC_CHBALGLOOPS, m_AlgLoops);
	DDX_Control(pDX, IDC_EDITPATH, m_OutputPath);
	DDX_Control(pDX, IDC_EDITMODELNAME, m_ModelName);
	DDX_Control(pDX, IDC_EDITDEPENDENCYDIR, m_DependencyDir);
}

BOOL CSimulinkDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	//CString toInsert0;
	//toInsert0.Format("Test String element");
	//this->lbToProcess.AddString(toInsert0);

	for(set<Udm::Object>::iterator soit = SelectedObj.begin();
			soit != SelectedObj.end();
			++soit)
	{
		CString toInsert;
		toInsert.Format(string(DML::MgaObject::Cast(*soit).name()).c_str());
		this->lbToProcess.AddString(toInsert);
	}

	m_ModelName.SetWindowTextA(ModelName.c_str());
	m_OutputPath.SetWindowTextA(OutputDir.c_str());
	m_DependencyDir.SetWindowTextA(DependencyDir.c_str());

	return TRUE;
}


BEGIN_MESSAGE_MAP(CSimulinkDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CSimulinkDlg::OnBnClickedOk)
	ON_BN_CLICKED(IDCANCEL, &CSimulinkDlg::OnBnClickedCancel)
	ON_BN_CLICKED(IDC_CHBMDAO, &CSimulinkDlg::OnBnClickedChbmdao)
	ON_BN_CLICKED(IDC_BTNBROWSEPATH, &CSimulinkDlg::OnBnClickedBtnbrowsepath)
END_MESSAGE_MAP()


// CSimulinkDlg message handlers

void CSimulinkDlg::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here
	OnOK();
	if (m_MDAO.GetCheck() == 1)
	{
		bMDAO = true;
	}
	else
	{
		bMDAO = false;
	}
	bUseESMoL = (m_UseESMoL.GetCheck() == 1);
	if (m_Silent.GetCheck() == 1)
	{
		bSilentMode = true;
	}
	else
	{
		bSilentMode = false;
	}
	if (m_AlgLoops.GetCheck() == 1)
	{
		bAlgLoops = true;
	}
	else
	{
		bAlgLoops = false;
	}

	// FIXME: these need to be saved
	//m_ModelName.SetWindowTextA(ModelName.c_str());
	//m_OutputPath.SetWindowTextA(OutputDir.c_str());
	//m_DependencyDir.SetWindowTextA(DependencyDir.c_str());
}

void CSimulinkDlg::OnBnClickedCancel()
{
	// TODO: Add your control notification handler code here
	OnCancel();
	bCanceledByUser = true;
}


void CSimulinkDlg::OnBnClickedChbmdao()
{
	// TODO: Add your control notification handler code here
	if (m_MDAO.GetCheck() == 1)
	{
		m_AlgLoops.SetCheck(1);
	}
	else
	{
		m_AlgLoops.SetCheck(0);
	}
}


void CSimulinkDlg::OnBnClickedBtnbrowsepath()
{
	// TODO: Add your control notification handler code here
}
