/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#pragma once

#include "Resource.h"
#include "afxwin.h"

////////////////////////////////////////////////////////////////////////////////
/// <summary>
///  Dialog for setting the parameters of the simulink interpreter.
/// </summary>
///
/// <remarks> Zsolt, 8/16/2011. </remarks>
///
/// <seealso cref="T:CDialog"/>
////////////////////////////////////////////////////////////////////////////////

class CSimulinkDlg : public CDialog
{
	DECLARE_DYNAMIC(CSimulinkDlg)

public:
	CSimulinkDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CSimulinkDlg();

// Dialog Data
	enum { IDD = IDD_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	////////////////////////////////////////////////////////////////////////////////
	/// <summary>
	///  Initializes this dialog and the controls within it. Also initializes the
	///  parameters (e.g. output directory) with their default values.
	/// </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	///
	/// <returns>
	///  TRUE if the focus has been left alone, FALSE if it has been set into a
	///  control.
	/// </returns>
	////////////////////////////////////////////////////////////////////////////////

	virtual BOOL OnInitDialog();

	DECLARE_MESSAGE_MAP()
public:

	////////////////////////////////////////////////////////////////////////////////
	/// <summary>
	///  When the user clicks on this OK button all the global parameters will be
	///  set based on their values in the dialog box.
	/// </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	////////////////////////////////////////////////////////////////////////////////

	afx_msg void OnBnClickedOk();
private:
	CButton m_MDAO;
public:
	/// <summary> After all scripts are generated the interpreter
	/// 					 will run the main build script. </summary>
	CButton m_Silent;
	CButton m_UseESMoL;

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> User cancelled the interpreter process. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	////////////////////////////////////////////////////////////////////////////////

	afx_msg void OnBnClickedCancel();
	/// <summary> List of all the containers that will be fully
	/// 					 processed. </summary>
	CListBox lbToProcess;

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> If this is checked the generated build script will
	/// 					 contain MDAO specific information. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	////////////////////////////////////////////////////////////////////////////////

	afx_msg void OnBnClickedChbmdao();
	/// <summary> If this is true each MR (modulated resistor) element
	/// 					 will have a memory block between its input and output
	/// 					 signal. </summary>
	CButton m_AlgLoops;

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> User can browse for the output directory. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	////////////////////////////////////////////////////////////////////////////////

	afx_msg void OnBnClickedBtnbrowsepath();
	/// <summary> Full pathname of the output directory </summary>
	CEdit m_OutputPath;
	/// <summary> Name of the model </summary>
	CEdit m_ModelName;
	/// <summary> Path of the dependency directory. All files will be
	/// 					 copied over to the output directory </summary>
	CEdit m_DependencyDir;
};
