/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef _TBGNODE_H_
#define _TBGNODE_H_

// TODO: MUST review this file

#include "TBond.h"
#include "TJunction.h"
#include "CyPhyML.h"
#include "TBGNode.h"
#include <string>

enum EndPointType {SOURCE, DESTINATION};

class TBGNode
{
public:
	/// <summary> The name </summary>
	string Name;
	/// <summary> Full pathname of the file </summary>
	string Path;
	/// <summary> Name of the type </summary>
	string TypeName;
	/// <summary> The reference for the Bond Graph node </summary>
	CyPhyML::BGNode* Ref;
	/// <summary> Global identifier </summary>
	int ID;
	/// <summary> Number of bonds </summary>
	int NumberOfBonds;
	/// <summary> The bond map </summary>
	map<int, pair<TBond*,EndPointType>> BondMap;

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> Gets the path with out name. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	///
	/// <returns> The path wo name. </returns>
	////////////////////////////////////////////////////////////////////////////////

	string getPathWOName();
	bool operator<(const TBGNode& right) const;

};

#endif // _TBGNODE_H_