/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef _TBOND_H_
#define _TBOND_H_

// TODO: MUST review this file
#include "CyPhyML.h"

class TBond
{
public:
	/// <summary> Unique identifier </summary>
	long uniqueID;
	/// <summary> Global identifier for this the bond </summary>
	int bondID;
	/// <summary> Source for the this bond </summary>
	CyPhyML::BGNode src;
	/// <summary> Destination for the this bond </summary>
	CyPhyML::BGNode dst;
	/// <summary> Full pathname of the file </summary>
	string path;

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> Initializes a new instance of the TBond class. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	///
	/// <param name="uniqueID"> Unique identifier. </param>
	/// <param name="src">		  Source for the bond. </param>
	/// <param name="dst">		  Destination for the bond. </param>
	/// <param name="path">		  Full pathname of the file. </param>
	////////////////////////////////////////////////////////////////////////////////

	TBond(long uniqueID,
				 CyPhyML::BGNode src,
				 CyPhyML::BGNode dst,
				 string path);
};

#endif // _TBOND_H_