/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "TJunction.h"


// TODO: MUST review this file
TJunction::TJunction(CyPhyML::Junction o)
{
	p=o;
	connectioncount=0; 
	//connectioncntp = 1;
	//signplus = 0;
	//signminus = 0;
	
	
	set<CyPhyML::BondJ2E> BondJ2E = o.dstBondJ2E();
	for (set<CyPhyML::BondJ2E>::iterator it = BondJ2E.begin(); it != BondJ2E.end(); it++ )
	{
		bondid.insert(it->uniqueId());
		//signminus++; // represents '-' sign
	}
	connectioncount += BondJ2E.size();
	
	
	set<CyPhyML::BondJ2J> BondJ2J = o.dstBondJ2J();
	for (set<CyPhyML::BondJ2J>::iterator it = BondJ2J.begin(); it != BondJ2J.end(); it++)
	{
		bondid.insert(it->uniqueId());
		//signminus++; // represents '-' sign
	}
	connectioncount += BondJ2J.size();
	
	
	BondJ2J = o.srcBondJ2J();
	for (set<CyPhyML::BondJ2J>::iterator it = BondJ2J.begin(); it != BondJ2J.end(); it++)
	{
		bondid.insert(it->uniqueId());
		//signplus++; // represents '+' sign
	}
	connectioncount += BondJ2J.size();
	
	
	set<CyPhyML::BondE2J> BondE2J = o.srcBondE2J();
	for (set<CyPhyML::BondE2J>::iterator it = BondE2J.begin(); it != BondE2J.end(); it++)
	{
		bondid.insert(it->uniqueId());
		//signplus++; // represents '+' sign
	}
	connectioncount += BondE2J.size();
}