/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef _TJUNCTION_H_
#define _TJUNCTION_H_

#include "CyPhyML.h"

class TJunction
{
public:
	/// <summary> The junction object. </summary>
	CyPhyML::Junction p;
	/// <summary> The connectioncount </summary>
	int connectioncount; // using for SCAP algorithm
	/// <summary> The bondid </summary>
	set<long> bondid;
	/// <summary> The bondid for sign-s </summary>
	set<long> bondid_sign; // for sign-s

	////////////////////////////////////////////////////////////////////////////////
	/// <summary> Initializes a new instance of the TJunction class. </summary>
	///
	/// <remarks> Zsolt, 8/16/2011. </remarks>
	///
	/// <param name="o"> The junction object. </param>
	////////////////////////////////////////////////////////////////////////////////

	TJunction(CyPhyML::Junction o);

	// Needed for insert == means the junction is already added e.g. vector<BGJunction>
	bool operator==(TJunction theOther) const
	{
		if (p.uniqueId() == theOther.p.uniqueId())
			return true;
		else
			return false;
	}
	bool operator==(CyPhyML::Junction theOther) const
	{
		if (p.uniqueId() == theOther.uniqueId())
			return true;
		else
			return false;
	}
};

#endif // _TJUNCTION_H_