/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef _TOOLS_H_
#define _TOOLS_H_

#include "CyPhyML.h"
#include <time.h>
#include <cmath>

// TODO: this should be removed
#define GetSimulinkPath(a) (a)

bool FolderExists(string file);
void CreateFolder(string FolderName);

// in: o is an object, which has position.
// out: X position of the object in the first aspect
int GetObjectXPosition(const CyPhyML::MgaObject &o);
// in: o is an object, which has position.
// out: Y position of the object in the first aspect
int GetObjectYPosition(const CyPhyML::MgaObject &o);

// in: o is an object, which has position.
// in: AspectName: name of the specific aspect
// out: X position of the object in the specified aspect
int GetObjectXPosition(const string position, 
											 const string AspectName = "");
// in: o is an object, which has position.
// in: AspectName: name of the specific aspect
// out: Y position of the object in the specified aspect
int GetObjectYPosition(const string position, 
											 const string AspectName = "");

// This function replaces specific characters in a string to '_' underscores.
// These specific characters is not allowed in the MatLab path.
// in: name of an object
// out: modified name
string GetModifiedName(string name);

// 
// in: path of an object
// out: path with out the object's name
string GetPathWOName(string path);

// This function replaces specific characters in a string to '_' underscores.
// These specific characters is not allowed in the MatLab path.
// in: an object
// out: modified name
string GetModifiedName(Udm::Object &oMga);

string GetParentPath(Udm::Object &oMga);

string GetObjectPath(Udm::Object &oMga);

// Save an error message for an invalid connection object.
void InvalidConnection(CyPhyML::MgaObject &o);

// Verify the connections of Input Output and Local signals.
// This functions save error messages for invalid connections.
int CheckSignalConstraints(set<CyPhyML::SignalConnection> &SignalSet);

// This function determines the input and output variables of a control
// function object using its code attribute.
// in: cf is a control function object.
// out: out is the output variables' names.
// out: out_index is the actual output port after the port mapping.
// out: in is the input variables' names.
// out: in_index is the actual input port after the port mapping.
void GetVariables(vector<string> &out, 
									vector<unsigned int> &out_index,
									vector<string> &in, 
									vector<unsigned int> &in_index, 
									CyPhyML::ControlFunction cf);

bool isNumeric( const char* pszInput, int nNumberBase );

double diffclock(clock_t clock1, clock_t clock2);
string GetElapsedTime(clock_t clock1, clock_t clock2);


void GetReferences(Udm::Object &connection, Udm::Object &srcRef, Udm::Object &dstRef);

string GetSrcLabel1(Udm::Object &connection);
string GetSrcLabel2(Udm::Object &connection);
string GetDstLabel1(Udm::Object &connection);
string GetDstLabel2(Udm::Object &connection);

string GetConnecitonLabel(Udm::Object &connection, string LabelName);

Udm::Object GetBaseType(Udm::Object &obj);

string GetGuid(Udm::Object &subject);

string GetRegNodeValueByName(
	CyPhyML::MgaObject object,
	string regnodeName);

#endif // _TOOLS_H_