/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace CyPhyLauncher
{
    public partial class InterpreterSelectionForm : Form
    {
        public InterpreterSelectionForm()
        {
            InitializeComponent();

            Interpreters = new List<Interpreter>();
        }

        public Interpreter SelectedInterpreter { get; set; }
        public List<Interpreter> Interpreters { get; set; }
        public Config Configuration { get; set; }
        public string Context { get; set; }

        Dictionary<Button, Interpreter> buttons = new Dictionary<Button, Interpreter>();

        public void GenerateInterprterButtons()
        {
            // TODO: remove all buttons
            this.Width = Configuration.ButtonWidth;
            this.Location = new Point(Control.MousePosition.X - (int)this.Width / 2, Control.MousePosition.Y + 10);

            foreach (var interpreter in Interpreters)
            {
                var ipreter = Configuration.Interpreters.FirstOrDefault(x => x.ProgId == interpreter.ProgId);
                if (ipreter == null)
                {
                    ipreter = interpreter;
                }

                if (ipreter.ValidContext != null)
                {
                    if (ipreter.ValidContext.Contains(Context) == false)
                    {
                        continue;
                    }
                }

                Button b = new Button();
                buttons.Add(b, ipreter);
            }

            var items = buttons.OrderBy(x => x.Value.ListId).ThenBy(x => x.Value.DisplayedName);

            int i = 0;
            foreach (var kvp in items)
            {
                var b = kvp.Key;
                var ipreter = kvp.Value;

                b.Text = ipreter.DisplayedName;
                b.Width = Configuration.ButtonWidth;
                b.Location = new Point(b.Location.Y, i * b.Height + Configuration.ButtonHeight);
                b.Anchor = AnchorStyles.None;
                b.Anchor = AnchorStyles.Top | AnchorStyles.Right | AnchorStyles.Left;

                b.BackColor = Configuration.ButtonBackColor;
                b.FlatAppearance.BorderSize = 0;
                b.FlatAppearance.BorderColor = Configuration.ButtonBackColor;
                b.FlatAppearance.MouseOverBackColor = Configuration.ButtonMouseOverBackColor;

                b.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
                b.Name = "btn_interpreter_" + i;
                b.Size = new System.Drawing.Size(Configuration.ButtonWidth, Configuration.ButtonHeight);
                b.UseVisualStyleBackColor = false;

                System.Drawing.Bitmap bmpOut = new System.Drawing.Bitmap(b.Width, b.Height);
                System.Drawing.Graphics g = System.Drawing.Graphics.FromImage(bmpOut);
                int bar_i = 0;
                foreach (var color in ipreter.Colors)
                {
                    g.FillRectangle(new SolidBrush(color), bar_i * Configuration.BarWidth, 0, Configuration.BarWidth, b.Height);
                    bar_i++;
                }

                b.Image = bmpOut;
                b.Click += btn_interpreter_Click;

                this.Controls.Add(b);

                i++;
            }

            int maxI = i > 10 || i < 1 ? 10 : i;
            
            this.Height = (maxI + 1) * Configuration.ButtonHeight;

            this.MinimumSize = new Size(Configuration.ButtonWidth, this.Height);
        }

        private void btn_interpreter_Click(object sender, EventArgs e)
        {
            Interpreter interpreter = null;
            buttons.TryGetValue((Button)sender, out interpreter);
            SelectedInterpreter = interpreter;
            if (SelectedInterpreter != null)
            {
                this.DialogResult = System.Windows.Forms.DialogResult.OK;
            }
            this.Close();
        }


    }
}
