/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "UdmComparator.hpp"
#include "CyPhyML.h"


int main( int argc, char **argv ) {
	if (argc < 2) {
		std::cerr << "Usage: CyPhyMLComparator project1.mga project2.mga" << std::endl;
		return 2;
	}

	Udm::SmartDataNetwork udmSmartDataNetwork1( CyPhyML::diagram );
	udmSmartDataNetwork1.OpenExisting( argv[1], "", Udm::CHANGES_PERSIST_ALWAYS );

	Udm::Object rootObject1 = udmSmartDataNetwork1.GetRootObject();


	Udm::SmartDataNetwork udmSmartDataNetwork2( CyPhyML::diagram );
	udmSmartDataNetwork2.OpenExisting( argv[2], "", Udm::CHANGES_PERSIST_ALWAYS );

	Udm::Object rootObject2 = udmSmartDataNetwork2.GetRootObject();


	UdmComparator udmComparator;

	UdmComparator::StringSet exclusiveClassNameSet;
	exclusiveClassNameSet.insert( "ReferenceCoordinateSystem" );

	UdmComparator::StringStringSetMap exclusiveClassNameAttributeNameSetMap;
	UdmComparator::StringSet exclusiveAttributeNameSet;
	exclusiveAttributeNameSet.insert( "position" );
	exclusiveClassNameAttributeNameSetMap.insert(  std::make_pair( "MgaObject", exclusiveAttributeNameSet )  );

	UdmComparator::ClassNameFilter classNameFilter;
	classNameFilter.setExclusiveClassNameSet( exclusiveClassNameSet );
	classNameFilter.setExclusiveClassNameAttributeNameMap( exclusiveClassNameAttributeNameSetMap );
	udmComparator.setClassNameFilter( classNameFilter );
	
	bool result = false;
//	try {
	result = udmComparator.compareNode( rootObject1, rootObject2 );
//	} catch( udm_exception &u ) {
//		std::cerr << u.what() << std::endl;
//	}

	std::cerr << UdmComparator::Report::get_singleton().getString() << std::endl;

	udmSmartDataNetwork1.CloseNoUpdate();
	udmSmartDataNetwork2.CloseNoUpdate();

	return result ? 1 : 0;
}