/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.Text;
using GME.MGA;
using GME.CSharp;
using System.IO;
using System.Linq;
using System.Windows.Forms;

namespace CyPhyMasterExe
{
    class Program
    {
        [STAThread]
        static void Main(string[] args)
        {
            try
            {
                string ProjectConnStr = args[0];
                string OriginalSubjectID = args[1];
                string ConfigID = args[2];

                MgaProject project = new MgaProject();
                bool ro_mode;
                project.Open(ProjectConnStr, out ro_mode);
                MgaModel originalSubject = null;
                List<MgaReference> testbenchRefs = new List<MgaReference>();
                MgaFCO config = null;
                string configName = null;
                MgaGateway MgaGateway = new MgaGateway(project);
                Queue<META.ComComponent> workflow = null;
                Dictionary<MgaReference, Dictionary<MgaReference, MgaModel>> allExpandedTestbenches = new Dictionary<MgaReference, Dictionary<MgaReference, MgaModel>>();

                CyPhyMasterInterpreter.CyPhyMasterInterpreter master = new CyPhyMasterInterpreter.CyPhyMasterInterpreter();
                master.InfoWriter = System.Console.Out;
                master.ErrorWriter = System.Console.Error;
                master.tbg = new CyPhyMasterInterpreter.TestBenchGateway();
                master.tbg.CyPhy = master;
                master.projectInvoked = project;
                string projectDir = Path.GetDirectoryName(project.ProjectConnStr.Substring("MGA=".Length));

                MgaGateway.PerformInTransaction(delegate
                {
                    master.avmProj = AVM.DDP.MetaAvmProject.Create(projectDir, project);
                    originalSubject = project.GetFCOByID(OriginalSubjectID) as MgaModel;
                    master.OriginalSubject = (GME.MGA.MgaFCO)originalSubject;
                    config = project.GetFCOByID(ConfigID);
                    configName = config.Name;
                    master.SetOutputDir(project, originalSubject as MgaFCO);

                    List<MgaReference> CaRefsToProcess = master.CaRefsToProcess = new List<MgaReference>();
                    if (config.PartOfConns.Count == 0)
                    {
                        // do not export it if already exported.
                        master.tbg.RunCAExporter(CaRefsToProcess, new MgaFCO[] { config });
                    }
                    else
                    {
                        CaRefsToProcess.Add((config.PartOfConns.Cast<MgaConnPoint>().FirstOrDefault().Owner as MgaSimpleConnection).Dst as MgaReference);
                    }

                    if (originalSubject.Meta.Name == "ParametricExploration")
                    {
                        master.Mode = CyPhyMasterInterpreter.CyPhyMasterInterpreter.Mode_enum.ME_DS;
                        workflow = master.GetWorkFlow(originalSubject as MgaFCO);
                        testbenchRefs = originalSubject.ChildFCOs.Cast<IMgaFCO>().OfType<MgaReference>()
                            .Where(r => r.Meta.Name == "TestBenchRef").ToList();
                        foreach (MgaReference testbenchRef in testbenchRefs)
                        {
                            MgaModel testbench = testbenchRef.Referred as MgaModel;
                            MgaReference TLSUT = master.tbg.GetTLSUT(testbench);
                            allExpandedTestbenches[testbenchRef] = master.tbg.InnerExtract(testbench, TLSUT, TLSUT.Referred.RootFCO as MgaModel, testbench.ParentFolder, CaRefsToProcess);
                            master.avmProj.UpdateTestBenchJson(testbenchRef.Referred);
                        }
                        master.Main_ME_DS(allExpandedTestbenches);
                    }
                    else
                    {
                        master.Mode = CyPhyMasterInterpreter.CyPhyMasterInterpreter.Mode_enum.TestBench_DS;
                        workflow = master.GetWorkFlow(originalSubject as MgaFCO);
                        MgaModel testbench = originalSubject;
                        MgaReference TLSUT = master.tbg.GetTLSUT(testbench);
                        master.tbg.InnerExtract(testbench, TLSUT, TLSUT.Referred.RootFCO as MgaModel, testbench.ParentFolder, CaRefsToProcess);
                        master.avmProj.UpdateTestBenchJson(testbench as MgaFCO);
                    }
                }, transactiontype_enum.TRANSACTION_GENERAL);
                master.MgaGateway = MgaGateway;

                bool needConfig = false;
                foreach (var item in master.tbg.fcosToProcess)
                {
                    var fcoWorkflowPair = new KeyValuePair<CyPhyMasterInterpreter.CyPhyMasterInterpreter.FCO, Queue<META.ComComponent>>(
                        new CyPhyMasterInterpreter.CyPhyMasterInterpreter.FCO(item.Key, item.Value), workflow);

                    master.CallInterpreters(fcoWorkflowPair, true, true, needConfig);

                    //master.CallInterpreters(new KeyValuePair<CyPhyMasterInterpreter.CyPhyMasterInterpreter.FCO, Queue<META.ComComponent>>(
                    //    new CyPhyMasterInterpreter.CyPhyMasterInterpreter.FCO(item.Key, item.Value),
                    //    workflow), true);

                    MgaGateway.PerformInTransaction(delegate
                    {
                        if (fcoWorkflowPair.Value.FirstOrDefault() != null)
                        {
                            string interpreterOutputDir = fcoWorkflowPair.Value.FirstOrDefault().Parameters["output_dir"];
                            master.avmProj.SaveSummaryReportJson(interpreterOutputDir, fcoWorkflowPair.Key.Fco);
                        }
                    });
                    //master.SaveDesign(avmProj, item);
                }
                master.AddJobs();

                //MgaGateway.PerformInTransaction(delegate
                //{
                //    master.DBfilenameReal = Path.Combine(workflow.First().Parameters["output_dir"], project.RootFolder.Name + "_DashboardConfig.xml");

                //    master.ExtractDashboardConfig(testbench as MgaFCO);
                //    if (workflow.First().MgaComponent.ComponentProgID == "MGA.Interpreter.CyPhyFormulaEvaluator")
                //        master.ProcessStaticMetrics(project, testbench as MgaFCO);
                //    master.SaveStaticMetricsRealDashboard();
                //},
                //transactiontype_enum.TRANSACTION_NON_NESTED);


                // For debugging interpreters
                //string output = Path.Combine(Directory.GetCurrentDirectory(), Path.GetFileName(ProjectConnStr.Substring("MGA=".Length)));
                //project.Save(@"MGA=" + output);
            }
            catch (Exception e)
            {
                System.Console.Error.WriteLine(e.ToString());
                System.Environment.Exit(5);
            }

        }
    }
}
