import sys
import os
#sys.path.append(r"C:\Program Files\ISIS\Udm\bin")
#if os.environ.has_key("UDM_PATH"):
#    sys.path.append(os.path.join(os.environ["UDM_PATH"], "bin"))
import _winreg as winreg
with winreg.OpenKey(winreg.HKEY_LOCAL_MACHINE, r"Software\META") as software_meta:
    meta_path, _ = winreg.QueryValueEx(software_meta, "META_PATH")
sys.path.append(os.path.join(meta_path, 'bin'))
import udm
import os.path

import win32com.client

def start_pdb():
    ''' Starts pdb, the Python debugger, in a console window
    '''
    import ctypes
    ctypes.windll.kernel32.AllocConsole()
    import sys
    sys.stdout = open('CONOUT$', 'wt')
    sys.stdin = open('CONIN$', 'rt')
    import pdb; pdb.set_trace()


class ComputeClassificationCounts(object):
    _public_methods_ = ['UpdateTestResults']
    _public_attrs_ = []

    def _compute(self, currentobj, json_filename):
        classifications = {}
        sut = [child for child in currentobj.children() if child.type.name=="TopLevelSystemUnderTest"][0]
        import collections
        que = collections.deque()
        que.extend(sut.ref.children())
        while que:
            obj = que.pop()
            que.extend(obj.children())
            def add_classification(component):
                classifications.setdefault(component.Classifications, [])
                classifications[component.Classifications].append(component)
            if obj.type.name == "ComponentRef":
                add_classification(obj.ref)
            if obj.type.name == "Component":
                add_classification(obj)
        
        import json
        with open(json_filename, "r") as json_file:
            json_data = json.load(json_file)
        json_data['Classification_counts'] = dict(((class_, len(members)) for class_, members in classifications.iteritems()))
        with open(json_filename, "w") as json_file:
            json.dump(json_data, json_file, indent=4)


    def UpdateTestResults(self, currentobj, json_filename):
        currentobj = win32com.client.Dispatch(currentobj)
        import _winreg as winreg
        with winreg.OpenKey(winreg.HKEY_LOCAL_MACHINE, r"Software\META") as software_meta:
            meta_path, _ = winreg.QueryValueEx(software_meta, "META_PATH")
        meta_path = str(meta_path)

        # need to open meta DN since it isn't compiled in
        uml_diagram = udm.uml_diagram()
        meta_dn = udm.SmartDataNetwork(uml_diagram)
        import os.path
        CyPhyML_udm = os.path.join(meta_path, r"generated\CyPhyML\models\CyPhyML_udm.xml")
        if not os.path.isfile(CyPhyML_udm):
            CyPhyML_udm = os.path.join(meta_path, r"meta\CyPhyML_udm.xml")
        #start_pdb()
        meta_dn.open(CyPhyML_udm, "")

        dn = udm.SmartDataNetwork(meta_dn.root)
        dn.open(currentobj.Project, "")
        self._compute(dn.convert_gme2udm(currentobj), json_filename)
        dn.close_no_update()
        meta_dn.close_no_update()
        

if __name__=='__main__':
    import _winreg as winreg
    with winreg.OpenKey(winreg.HKEY_LOCAL_MACHINE, r"Software\META") as software_meta:
        meta_path, _ = winreg.QueryValueEx(software_meta, "META_PATH")
    meta_path = str(meta_path)

    # need to open meta DN since it isn't compiled in
    uml_diagram = udm.uml_diagram()
    meta_dn = udm.SmartDataNetwork(uml_diagram)
    import os.path
    CyPhyML_udm = os.path.join(meta_path, r"generated\CyPhyML\models\CyPhyML_udm.xml")
    if not os.path.isfile(CyPhyML_udm):
        CyPhyML_udm = os.path.join(meta_path, r"meta\CyPhyML_udm.xml")
    meta_dn.open(CyPhyML_udm, "")

    dn = udm.SmartDataNetwork(meta_dn.root)
    dn.open(sys.argv[1], "")
    raise NotImplementedException()
    # TODO
    #ComputeClassificationCounts()
    dn.close_no_update()
    meta_dn.close_no_update()

