/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using GME.MGA;

namespace CyPhyMasterInterpreter
{
	public class DesignConfigItem
	{
		public MgaModel DesignConfig { get; set; }

		public List<SelectedItem> ExportedCAs { get; set; }

		public string DisplayedName { get; set; }

		public bool isDirty { get; set; }

		public DesignConfigItem(MgaModel designConfig)
		{
			if (designConfig != null)
			{
                ExportedCAs = new List<SelectedItem>();

				DesignConfig = designConfig;
				DisplayedName = DesignConfig.Name;

				foreach (MgaFCO fco in designConfig.ChildFCOs)
				{
					if (fco.Meta.Name == "ComponentAssemblyRef")
					{
                        if ((fco as MgaReference).Referred != null)
						    ExportedCAs.Add(new ExportedCaItem(fco as MgaReference));
					}
                    else if (fco.Meta.Name == "CWC")
                    {
                        bool hasCARef = false;
                        foreach (MgaConnPoint connpoint in fco.PartOfConns)
                        {
                            // Config2CA
                            MgaSimpleConnection conn = connpoint.Owner as MgaSimpleConnection;
                            MgaFCO other;
                            if (conn.Src.ID == fco.ID)
                                other = conn.Dst;
                            else
                                other = conn.Src;
                            if (other.Meta.Name == "ComponentAssemblyRef")
                                hasCARef = true;
                        }
                        if (!hasCARef)
                        {
                            ExportedCAs.Add(new SelectedItem(fco as MgaFCO));
                        }
                    }
                }

				foreach (MgaAttribute attr in designConfig.Attributes)
				{
					if (attr.Meta.Name == "isDirty")
					{
						isDirty = attr.BoolValue;
					}
				}
			}
			else
			{
				throw new NullReferenceException();
			}
		}

		public override string ToString()
		{
			if (String.IsNullOrEmpty(DisplayedName))
			{
				return "";
			}
			else
			{
				if (isDirty)
				{
					return DisplayedName + " (" + ExportedCAs.Count + ") - [Dirty]";
				}
				else
				{
					return DisplayedName + " (" + ExportedCAs.Count + ")";
				}
			}
		}
	}
}
