/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using System.Runtime.InteropServices;
using System.IO;

namespace CyPhyMasterInterpreter
{
    public class PythonInterop
    {
        public static void RunInterpreter(GME.MGA.MgaProject project, GME.MGA.MgaFCO currentobj, GME.MGA.MgaFCOs selectedobjs, Int32 param)
        {
            string pythonClassName = "MetaScriptPy.MetaScriptPy";
            string pythonPath = @"C:\Users\meta\Documents\MetaScript_TB_Extract";

            dynamic script = CreatePythonComObject(pythonPath, pythonClassName);

            script.Initialize(project);
            script.InvokeEx(project, currentobj, selectedobjs, param);
        }

        [DllImport("kernel32", SetLastError = true, CharSet = CharSet.Unicode)]
        static extern IntPtr LoadLibrary(string lpFileName);

        public static dynamic CreatePythonComObject(string pythonPath, string pythonClassName)
        {
            LoadLibrary(Path.Combine(META.VersionInfo.PythonVEnvPath,
                @"Lib\site-packages\pywin32-217-py2.7-win32.egg\pythoncomloader27.dll"));
            Guid guid = new Guid("D50852FD-9FB2-4503-8608-0A5EB616DB86");
            RegistryKey clsidKey = Registry.CurrentUser.CreateSubKey(String.Format(@"Software\Classes\CLSID\{0}", guid.ToString("B")));
            // clsidKey.SetValue(null, pythonClassName);
            clsidKey.CreateSubKey("InprocServer32").SetValue(null, "pythoncomloader27.dll");
            clsidKey.CreateSubKey("PythonCOM").SetValue(null, pythonClassName);
            clsidKey.CreateSubKey("PythonCOMPath").SetValue(null, pythonPath
                + ";" + Path.Combine(META.VersionInfo.PythonVEnvPath, @"lib"));
            dynamic script = Activator.CreateInstance(Type.GetTypeFromCLSID(guid));
            return script;
        }
    }
}
