/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CyPhyMasterInterpreter.Interpreter;
using META;

namespace CyPhyMasterInterpreter
{
	public class WorkFlowListItem //:IComparer<WorkFlowListItem>
	{
		public ComComponent Interpreter { get; set; }

		public int Id { get; set; }

		public WorkFlowListItem(ComComponent interpreter, int id)
		{
			if (interpreter == null)
			{
				throw new NullReferenceException();
			}
			Interpreter = interpreter;
			Id = id;
		}

		public override string ToString()
		{
			StringBuilder sb = new StringBuilder();
			//string Format = "[{0:" + Id.ToString().Length + ".}]  {1}";
			sb.AppendFormat(
				"[{0}]  {1}",
				Id + 1,
				Interpreter.ToolTip);
			return sb.ToString();
		}

		public static int Compare(WorkFlowListItem x, WorkFlowListItem y)
		{
			if (x.Id > y.Id)
			{
				return 1;
			}
			else if (x.Id < y.Id)
			{
				return -1;
			}
			else
			{
				return 0;
			}
		}
	}
}
