/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "stdafx.h"
#include "UdmApp.h"
#include "UdmConfig.h"
#include "Uml.h"
#include "UdmUtil.h"

#include "UdmConsole.h"

#include "CyPhyMetricEvaluator.h"
#include "CyPhyToolbox.h"

#include <iostream>
#include <fstream>

using namespace std;


// global variables for automation
extern bool Automation;
extern bool Expanded;
extern string OutputDir;
extern bool ConsoleMessagesOn;


/*********************************************************************************/
/* Initialization function. The framework calls it before preparing the backend. */
/* Initialize here the settings in the config global object.					 */
/* Return 0 if successful.														 */
/*********************************************************************************/
int CUdmApp::Initialize()
{


	// TODO: Your initialization code comes here...
	return 0;
}



/* 
Remarks to CUdmApp::UdmMain(...):
0.	The p_backend points to an already open backend, and the framework 
	closes it automatically. DO NOT OPEN OR CLOSE IT!
	To commit changes use p_backend->CommitEditSequence().
	To abort changes use p_backend->AbortEditSequence().
	To save changes to a different file use p_backend->SaveAs() or p_backend->CloseAs().

1.	Focus is the currently open model.

2.	The possible values for param (from GME Mga.idl component_startmode_enum):
	GME_MAIN_START			=   0,
	GME_BROWSER_START		=   1,
	GME_CONTEXT_START		=   2,
	GME_EMBEDDED_START		=   3,
	GME_MENU_START			=  16,
	GME_BGCONTEXT_START		=  18,
	GME_ICON_START			=  32,
	METAMODEL_CHECK_SYNTAX	= 101

 3. The framework catches all the exceptions and reports the error in a message box,
	clean up and close the transactions aborting the changes. You can override this 
	behavior by catching udm_exception. Use udm_exception::what() to form an error 
	message.
*/

/***********************************************/
/* Main entry point for Udm-based Interpreter  */
/***********************************************/

void CUdmApp::UdmMain(
					 Udm::DataNetwork* p_backend,		// Backend pointer(already open!)
					 Udm::Object focusObject,			// Focus object
					 std::set<Udm::Object> selectedObjects,	// Selected objects
					 long param,
					 std::string outDir,
					 bool AutoInvoked)					// Parameters
{	

	// TODO: Your Code Comes Here...
	try
	{
		CyPhyML::TestBench testBench;
		if (focusObject != Udm::null)
		{
			if(Uml::IsDerivedFrom(focusObject.type(), CyPhyML::TestBench::meta))
				testBench = CyPhyML::TestBench::Cast(focusObject);

			// TODO: Himanshu: Make sure that the TestBench contains a fully-specified component assembly (i.e., Expanded == true)
		}

		if(testBench == Udm::null)
		{
			if( Automation == false ) {
				AfxMessageBox("Please open a TestBench model to invoke the interpreter.");
			} else {
				if ( ConsoleMessagesOn == true ) {
					GMEConsole::Console::Info::writeLine("Please open a TestBench model to invoke the interpreter.");
				}
			}
			return;
		}
		
		// 1. Elaborate
		// 2. Updates formulas
		// 3. Collapse
		FormulaEvaluator(testBench, true);

		CyPhyMetricEvaluator cme(testBench);
		cme.evaluate();
		map<std::string, std::string> metricsMap = cme.getMetricMap();
		string cfgId = cme.getCfgUniqueId();
		string cfgName = cme.getCfgName();

		if (Automation)
		{
			outDir = OutputDir;
		}

		std::string fname = outDir+"\\metrics_list.txt";
		std::ofstream metric_file;
		metric_file.open(fname.c_str());
		map<std::string, std::string>::iterator pos;
		metric_file<<"Configuration\t";//<<to_string(_Longlong(cfgId))<<endl;
		for(pos=metricsMap.begin();pos!=metricsMap.end();++pos)
		{
			metric_file<<(*pos).first<<"\t";//<<(*pos).second<<endl;
		}
		metric_file<<endl;
		metric_file<<cfgId<<"_"<<cfgName<<"\t";
		for(pos=metricsMap.begin();pos!=metricsMap.end();++pos)
		{
			metric_file<<(*pos).second<<"\t";
		}
		metric_file<<endl;
		metric_file.close();

		std::string info = fname+" is generated for TestBench: " + (std::string) testBench.name();
		if( Automation == false ) {
			AfxMessageBox(info.c_str());
		} else {
			if ( ConsoleMessagesOn == true ) {
				GMEConsole::Console::Info::writeLine(info.c_str());
			}
		}
	}
	catch (udm_exception &exc)
	{
		GMEConsole::Console::writeLine("MetricEvaluator: Udm exception occured! Exception description: " + (std::string)exc.what(), MSG_ERROR);
	}
	catch (...)
	{
		GMEConsole::Console::writeLine("MetricEvaluator: None Udm exception occured!", MSG_ERROR);
	}											
}
