import os
import sys
import subprocess
import logging
import time

def build_modelica_model(usr_dir, fname, additionalLibs = "", extension=".mo", ):
    cur_dir = os.getcwd()
    omc_dir = os.getenv('OPENMODELICAHOME')
    if omc_dir is None:
        sys.exit('Can not find OpenModelica directory.')
        
    if omc_dir[-1] != '\\': omc_dir = omc_dir+'\\'
    print "current working dir:", cur_dir
    
    full_path_fname = '' + usr_dir + '\\' + fname + extension + ''

    # make the compiler happy
    full_path_fname = full_path_fname.replace("\\","/")
    additionalLibs = additionalLibs.replace("\\","/")

    print 'Generating flat modelica model and source code. (' + full_path_fname + ')'

    cmd_compile = omc_dir+'bin\\omc.exe +q +s "' + full_path_fname + '" '
    if additionalLibs != '': cmd_compile += '"' + additionalLibs + '" '
    cmd_compile = cmd_compile + 'ModelicaServices Modelica'

    print 'Flat model and generated code are ready. (' + full_path_fname + ')'

    print 'Compiling the code into an executable package. (' + fname + ')'

    print 'omc command:', cmd_compile
    
    subprocess.call(cmd_compile, shell=True)
    
    # Add %OPENMODELICAHOME%\MinGW\bin to environment variables
    env_var_mingw = os.path.join(os.getenv('OPENMODELICAHOME'),
                        'mingw',
                        'bin')
    my_env = os.environ
    my_env["PATH"] = env_var_mingw +';'+ my_env["PATH"]


    subprocess.call(omc_dir+'mingw\\bin\\mingw32-make.exe -f "' + fname + '.makefile"', shell=True)

    print 'Done. (' + full_path_fname + ')'

def build_modelica_model_OM(model_name,
                            model_file_name,
                            model_dir = '',
                            msl_version = '3.2'):
    
    log = logging.getLogger()
    working_dir = os.getcwd()

    tool_path = os.path.join(os.getenv('OPENMODELICAHOME'), 'bin')
    mos_file_name = os.path.join(model_name + '.mos')
    model_is_compiled = False

    with open(mos_file_name, 'wb') as file_out:
        lines = []
        lines.append('// OpenModelica script file to run a model')
        
        lines.append('loadModel(Modelica, {"' +
                     msl_version + '"});')
        
        
        if mos_file_name != '':
            #relpath = os.path.relpath(model_dir, mos_file_name)
            relpath = os.path.join(model_dir);
            relpath = relpath.replace('\\','\\\\')
            lines.append('cd("' + relpath + '");')
            lines.append('loadFile("' + model_file_name + '");')

            #relpath = os.path.relpath(os.getcwd(), mos_file_name)
            relpath = os.getcwd()
            relpath = relpath.replace('\\','\\\\')
            lines.append('cd("' + relpath + '");')

        lines.append('translateModel(' + model_name + ');')
        lines.append('getErrorString();')
        file_out.write("\n".join(lines))

    # print used version
    command = os.path.join(tool_path, 'omc') \
            + ' +version > om_version.txt'
            
    
    log.debug("About to call command: {0}".format(command))
    
    return_code = subprocess.call(command, shell=True)
    if return_code != 0:
        log.error('Command failed to execute {0}'.format(command))
        model_is_compiled = False
    else:
        model_is_compiled = True
        
    # get revision number
    om_version = open('om_version.txt', 'r').read().rstrip('\n')
    
    # call modelica compiler
    command = os.path.join(tool_path, 'omc') \
            + ' +q +s ' \
            + mos_file_name \
            + ' > om_compile_msgs.txt'
    
    log.debug("About to call command: {0}".format(command))
    t_1 = time.time()
    return_code = subprocess.call(command, shell=True)
    if return_code != 0:
        log.error('Command failed to execute {0}'.format(command))
        model_is_compiled = False
    else:
        model_is_compiled = True
    
    if not os.path.exists(model_name + '_init.xml'):
            # something went wrong during compilation
            log.error("Compilation of {0} failed".format(model_name))
            return False

    # change current directory to working directory
    cwd = os.getcwd()

    if os.name == 'nt':
        # Windows
        # Make model
        
        # Add %OPENMODELICAHOME%\MinGW\bin to environment variables
        env_var_mingw = os.path.join(os.getenv('OPENMODELICAHOME'),
                                    'mingw',
                                    'bin')
        my_env = os.environ
        my_env["PATH"] = env_var_mingw +';'+ my_env["PATH"]
        command = 'mingw32-make.exe' \
                + ' -f ' \
                + model_name \
                + '.makefile'

        log.debug("About to call command: {0}".format(command))
        
        # compile the model
        return_code = subprocess.call(command, env=my_env, shell=True)
        if return_code != 0:
            log.error('Command failed to execute {0}'\
                          .format(command))
            model_is_compiled = False
        else:
            model_is_compiled = True

    elif os.name == 'posix':
        # Unix
        # make -f model_name.makefile
        command = 'make' \
                + ' -f ' \
                + model_name \
                + '.makefile'

        log.debug("About to call command: {0}".format(command))

        # compile the model
        return_code = subprocess.call(command, shell=True)
        if return_code != 0:
            log.error('Command failed to execute {0}'\
                          .format(command))
            model_is_compiled = False
        else:
            model_is_compiled = True

    t_2 = time.time()

    xml_file = os.path.join(working_dir,
                            model_name + '_init.xml')

    os.chdir(cwd)

    return model_is_compiled

##def main():
##    pass
##
##if __name__ == '__main__':
##    main()




