/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version: 10.0.0.0
//  
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
// ------------------------------------------------------------------------------
namespace CyPhyPET.Templates
{
    using System;
    using System.IO;
    using System.Diagnostics;
    using System.Linq;
    using System.Xml.Linq;
    using System.Collections;
    using System.Collections.Generic;
    using ISIS.GME.Dsml.CyPhyML.Classes;
    
    
    #line 1 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Microsoft.VisualStudio.TextTemplating", "10.0.0.0")]
    public partial class Optimizer : OptimizerBase
    {
        #region ToString Helpers
        /// <summary>
        /// Utility class to produce culture-oriented representation of an object as a string.
        /// </summary>
        public class ToStringInstanceHelper
        {
            private System.IFormatProvider formatProviderField  = global::System.Globalization.CultureInfo.InvariantCulture;
            /// <summary>
            /// Gets or sets format provider to be used by ToStringWithCulture method.
            /// </summary>
            public System.IFormatProvider FormatProvider
            {
                get
                {
                    return this.formatProviderField ;
                }
                set
                {
                    if ((value != null))
                    {
                        this.formatProviderField  = value;
                    }
                }
            }
            /// <summary>
            /// This is called from the compile/run appdomain to convert objects within an expression block to a string
            /// </summary>
            public string ToStringWithCulture(object objectToConvert)
            {
                if ((objectToConvert == null))
                {
                    throw new global::System.ArgumentNullException("objectToConvert");
                }
                System.Type t = objectToConvert.GetType();
                System.Reflection.MethodInfo method = t.GetMethod("ToString", new System.Type[] {
                            typeof(System.IFormatProvider)});
                if ((method == null))
                {
                    return objectToConvert.ToString();
                }
                else
                {
                    return ((string)(method.Invoke(objectToConvert, new object[] {
                                this.formatProviderField })));
                }
            }
        }
        private ToStringInstanceHelper toStringHelperField = new ToStringInstanceHelper();
        public ToStringInstanceHelper ToStringHelper
        {
            get
            {
                return this.toStringHelperField;
            }
        }
        #endregion
        public virtual string TransformText()
        {
            this.GenerationEnvironment = null;
            this.Write(" \r\n");
            this.Write(" \r\n");
            this.Write(@"# ===========================================================================
# Auto generated from Optimizer.tt
# ===========================================================================
# OpenMDAO Assembly Component (Optimization)
from openmdao.main.api import Assembly, set_as_top
from openmdao.lib.drivers.api import ");
            
            #line 22 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(OptimizerType));
            
            #line default
            #line hidden
            this.Write("\r\n\r\n");
            
            #line 24 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
foreach (var item in pet.Children.TestBenchRefCollection)
 {
            
            #line default
            #line hidden
            this.Write("from ");
            
            #line 26 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(item.Name));
            
            #line default
            #line hidden
            this.Write(" import ");
            
            #line 26 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(item.Name));
            
            #line default
            #line hidden
            this.Write("\r\n");
            
            #line 27 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
}
            
            #line default
            #line hidden
            this.Write("\r\nclass ");
            
            #line 29 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(pet.Name));
            
            #line default
            #line hidden
            this.Write("(Assembly):\r\n    \"\"\" Documentation comment for this Assembly. \"\"\"\r\n   \r\n    def _" +
                    "_init__(self):\r\n        super(");
            
            #line 33 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(pet.Name));
            
            #line default
            #line hidden
            this.Write(", self).__init__()\r\n        \r\n        ## Create component instances\r\n");
            
            #line 36 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
        foreach (var item in pet.Children.TestBenchRefCollection)
        {
            
            #line default
            #line hidden
            this.Write("        self.add(\'");
            
            #line 38 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(item.Name));
            
            #line default
            #line hidden
            this.Write("\', ");
            
            #line 38 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(item.Referred.TestBench.Name));
            
            #line default
            #line hidden
            this.Write("())\r\n");
            
            #line 39 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
        }
            
            #line default
            #line hidden
            this.Write("        self.add(\'driver\', ");
            
            #line 40 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(OptimizerType));
            
            #line default
            #line hidden
            this.Write("())\r\n        \r\n        # The type and level attributes of Optimization\r\n        s" +
                    "elf.driver.iprint = 0\r\n        self.driver.itmax  = 30\r\n        self.driver.fdch" +
                    "   = .000001\r\n        self.driver.fdchm  = .000001\r\n\r\n");
            
            #line 48 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
 		foreach (var item in GetDoeOptions())
		{
            
            #line default
            #line hidden
            this.Write("        self.driver.");
            
            #line 50 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(item));
            
            #line default
            #line hidden
            this.Write("\r\n");
            
            #line 51 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
 		}
            
            #line default
            #line hidden
            this.Write("\r\n        # Design Variables\r\n");
            
            #line 54 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
 foreach (var item in pet.Children.OptimizerCollection.FirstOrDefault().Children.DesignVariableCollection)
    {
        string low = "0.0";
        string high = "0.0";
        string range = item.Attributes.Range;
        low = range.Substring(0, range.LastIndexOf(','));
        high = range.Substring(range.LastIndexOf(' '));
        foreach (var conn in item.DstConnections.VariableSweepCollection)
        {
            string name = conn.GenericDstEndRef.Name + "." + conn.GenericDstEnd.Name;
            InOuts += name + ":%f ";
        
            
            #line default
            #line hidden
            this.Write("        \r\n        self.driver.add_parameter(\'");
            
            #line 66 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(name));
            
            #line default
            #line hidden
            this.Write("\', low = ");
            
            #line 66 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(low));
            
            #line default
            #line hidden
            this.Write(", high = ");
            
            #line 66 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(high));
            
            #line default
            #line hidden
            this.Write(") # ");
            
            #line 66 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(item.Attributes.Range));
            
            #line default
            #line hidden
            this.Write("\r\n");
            
            #line 67 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
         }
    } 
            
            #line default
            #line hidden
            this.Write("\r\n        # Objective\r\n");
            
            #line 71 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
 foreach (var item in pet.Children.OptimizerCollection.FirstOrDefault().Children.ObjectiveCollection)
    {
        foreach (var conn in item.SrcConnections.ObjectiveMappingCollection)
        {
            string name = conn.GenericSrcEndRef.Name + "." + conn.GenericSrcEnd.Name;
            InOuts += name + ":%f ";
        
            
            #line default
            #line hidden
            this.Write("        self.driver.add_objective(\'");
            
            #line 78 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(name));
            
            #line default
            #line hidden
            this.Write("\')\r\n");
            
            #line 79 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
        }
    } 
            
            #line default
            #line hidden
            this.Write("\r\n        # Constraints\r\n");
            
            #line 83 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
 foreach (var item in pet.Children.OptimizerCollection.FirstOrDefault().Children.OptimizerConstraintCollection)
    { 
            
            #line default
            #line hidden
            this.Write("        self.driver.add_constraint(\'");
            
            #line 85 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(item.Attributes.MinValue));
            
            #line default
            #line hidden
            this.Write("\') # MinValue of ");
            
            #line 85 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(item.Name));
            
            #line default
            #line hidden
            this.Write("\r\n");
            
            #line 86 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
  } 
            
            #line default
            #line hidden
            this.Write("\r\n\r\n        self.driver.workflow.add([ \\\r\n");
            
            #line 90 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
 foreach (var item in GetWorkflow())
    {
            
            #line default
            #line hidden
            this.Write("            \'");
            
            #line 92 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(item));
            
            #line default
            #line hidden
            this.Write("\', \\\r\n");
            
            #line 93 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
    } 
            
            #line default
            #line hidden
            this.Write("            \r\n        ])\r\n\r\n");
            
            #line 96 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
        foreach (var item in pet.Children.ResultFlowCollection)
        {
            
            #line default
            #line hidden
            this.Write("                \r\n        self.connect(\'");
            
            #line 98 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(item.GenericSrcEndRef.Name + "." + item.GenericSrcEnd.Name));
            
            #line default
            #line hidden
            this.Write("\', \'");
            
            #line 98 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(item.GenericDstEndRef.Name + "." + item.GenericDstEnd.Name));
            
            #line default
            #line hidden
            this.Write("\')\r\n");
            
            #line 99 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
    } 
            
            #line default
            #line hidden
            this.Write("    # End __init__   \r\n# End class\r\n\r\nif __name__ == \"__main__\":\r\n    import time" +
                    "\r\n    \r\n    opt_problem = ");
            
            #line 106 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(pet.Name));
            
            #line default
            #line hidden
            this.Write("()\r\n    set_as_top(opt_problem)\r\n\r\n    tt = time.time()\r\n    opt_problem.run()\r\n\r" +
                    "\n    print \"\\n\"\r\n    print \"Optimizer: %s\" % type(opt_problem.driver)\r\n    print" +
                    " \"Minimum: %f\" % opt_problem.driver.eval_objective()\r\n\r\n    print \"Minimum found" +
                    " at (");
            
            #line 116 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(InOuts));
            
            #line default
            #line hidden
            this.Write(")\" % (\r\n");
            
            #line 117 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
 foreach (var item in pet.Children.OptimizerCollection.FirstOrDefault().Children.DesignVariableCollection)
    {
        foreach (var conn in item.DstConnections.VariableSweepCollection)
        {
            string name = conn.GenericDstEndRef.Name + "." + conn.GenericDstEnd.Name;
        
            
            #line default
            #line hidden
            this.Write("        opt_problem.");
            
            #line 123 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(name));
            
            #line default
            #line hidden
            this.Write(", \\\r\n");
            
            #line 124 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
        }
    } 
    foreach (var item in pet.Children.OptimizerCollection.FirstOrDefault().Children.ObjectiveCollection)
    {
        foreach (var conn in item.SrcConnections.ObjectiveMappingCollection)
        {
            string name = conn.GenericSrcEndRef.Name + "." + conn.GenericSrcEnd.Name;
        
            
            #line default
            #line hidden
            this.Write("        opt_problem.");
            
            #line 132 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(name));
            
            #line default
            #line hidden
            this.Write(", \\\r\n");
            
            #line 133 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
        }
    } 
            
            #line default
            #line hidden
            this.Write("  \r\n    )\r\n\t\r\n    print \"Elapsed time: \", time.time()-tt, \"seconds\"\r\n\r\n# End ");
            
            #line 139 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"
            this.Write(this.ToStringHelper.ToStringWithCulture(pet.Name));
            
            #line default
            #line hidden
            this.Write(".py\r\n\r\n\r\n\r\n");
            return this.GenerationEnvironment.ToString();
        }
        
        #line 143 "C:\META\META_trunk\src\CyPhyPET\Templates\Optimizer.tt"

	public string OptimizerType {get; set;}
	
    public ISIS.GME.Dsml.CyPhyML.Interfaces.ParametricExploration pet { get; set; }    
    public string InOuts {get; set;}
    public List<string> GetWorkflow()
    {
        List<ISIS.GME.Dsml.CyPhyML.Interfaces.TestBenchRef> tbref = pet.Children.TestBenchRefCollection.ToList();
        List<ISIS.GME.Dsml.CyPhyML.Interfaces.TestBenchRef> workflow = new List<ISIS.GME.Dsml.CyPhyML.Interfaces.TestBenchRef>();
        foreach (var item in pet.Children.ObjectiveMappingCollection)
        {
            var tb = tbref.FirstOrDefault(x => x.ID == item.GenericSrcEndRef.ID);
            if (workflow.FirstOrDefault(x => x.ID == tb.ID) == null)
            {
                workflow.Add(tb);
                InsertDependency(workflow, tb);
            }
        }

        var wokflowNames = workflow.Select(x => x.Name).ToList();
		wokflowNames.Reverse();
        return wokflowNames;
    }
    
    private void InsertDependency(List<ISIS.GME.Dsml.CyPhyML.Interfaces.TestBenchRef> workflow, ISIS.GME.Dsml.CyPhyML.Interfaces.TestBenchRef tb)
    {
        var outConns = pet.Children.ResultFlowCollection.Where(x => x.GenericDstEndRef.ID == tb.ID);
		bool cyclic = false;
        foreach (var item in outConns)
        {
            var nexttb = pet.Children.TestBenchRefCollection.FirstOrDefault(x => item.GenericSrcEndRef.ID == x.ID);
            
            if (pet.Children.TestBenchRefCollection.Count() != workflow.Count)
            {
                var tbinlist = workflow.FirstOrDefault(x => x.ID == tb.ID);
                int i = workflow.IndexOf(tbinlist);
                i++;
                if (workflow.FirstOrDefault(x => x.ID == nexttb.ID) == null)
                {
                    workflow.Insert(i, nexttb);
                    InsertDependency(workflow, nexttb);
                }
                else
                {
                    // break loop!
					cyclic = true;
					break;
                    //throw new Exception("cyclic dependency was detected among testbenchrefs");
                }
            }
        }
    }
	
	public string OutputDirectory = "";
	
	
	public string GetRelativeFileName() {
		System.Uri uri1 = new Uri(OutputDirectory + "/", UriKind.RelativeOrAbsolute);
		System.Uri uri2 = new Uri(OutputDirectory + "/", UriKind.RelativeOrAbsolute);
 
		if (uri2.IsAbsoluteUri)
		{
			Uri relativeUri = uri1.MakeRelativeUri(uri2);
			return relativeUri.ToString();
		}
		else
		{
			return OutputDirectory + "/";
		}
	}

	
	private IEnumerable<string> GetDoeOptions() {
		List<string> result = new List<string>();		
		string[] vals = pet.Children.OptimizerCollection.FirstOrDefault().Attributes.Code.Split('\n');
		foreach (var item in vals)
		{
			if (string.IsNullOrEmpty(item) == false)
			{
				result.Add(item);
			}
		}		
		return result;
	}

        
        #line default
        #line hidden
    }
    
    #line default
    #line hidden
    #region Base class
    /// <summary>
    /// Base class for this transformation
    /// </summary>
    [System.CodeDom.Compiler.GeneratedCodeAttribute("Microsoft.VisualStudio.TextTemplating", "10.0.0.0")]
    public class OptimizerBase
    {
        #region Fields
        private global::System.Text.StringBuilder generationEnvironmentField;
        private global::System.CodeDom.Compiler.CompilerErrorCollection errorsField;
        private global::System.Collections.Generic.List<int> indentLengthsField;
        private string currentIndentField = "";
        private bool endsWithNewline;
        private global::System.Collections.Generic.IDictionary<string, object> sessionField;
        #endregion
        #region Properties
        /// <summary>
        /// The string builder that generation-time code is using to assemble generated output
        /// </summary>
        protected System.Text.StringBuilder GenerationEnvironment
        {
            get
            {
                if ((this.generationEnvironmentField == null))
                {
                    this.generationEnvironmentField = new global::System.Text.StringBuilder();
                }
                return this.generationEnvironmentField;
            }
            set
            {
                this.generationEnvironmentField = value;
            }
        }
        /// <summary>
        /// The error collection for the generation process
        /// </summary>
        public System.CodeDom.Compiler.CompilerErrorCollection Errors
        {
            get
            {
                if ((this.errorsField == null))
                {
                    this.errorsField = new global::System.CodeDom.Compiler.CompilerErrorCollection();
                }
                return this.errorsField;
            }
        }
        /// <summary>
        /// A list of the lengths of each indent that was added with PushIndent
        /// </summary>
        private System.Collections.Generic.List<int> indentLengths
        {
            get
            {
                if ((this.indentLengthsField == null))
                {
                    this.indentLengthsField = new global::System.Collections.Generic.List<int>();
                }
                return this.indentLengthsField;
            }
        }
        /// <summary>
        /// Gets the current indent we use when adding lines to the output
        /// </summary>
        public string CurrentIndent
        {
            get
            {
                return this.currentIndentField;
            }
        }
        /// <summary>
        /// Current transformation session
        /// </summary>
        public virtual global::System.Collections.Generic.IDictionary<string, object> Session
        {
            get
            {
                return this.sessionField;
            }
            set
            {
                this.sessionField = value;
            }
        }
        #endregion
        #region Transform-time helpers
        /// <summary>
        /// Write text directly into the generated output
        /// </summary>
        public void Write(string textToAppend)
        {
            if (string.IsNullOrEmpty(textToAppend))
            {
                return;
            }
            // If we're starting off, or if the previous text ended with a newline,
            // we have to append the current indent first.
            if (((this.GenerationEnvironment.Length == 0) 
                        || this.endsWithNewline))
            {
                this.GenerationEnvironment.Append(this.currentIndentField);
                this.endsWithNewline = false;
            }
            // Check if the current text ends with a newline
            if (textToAppend.EndsWith(global::System.Environment.NewLine, global::System.StringComparison.CurrentCulture))
            {
                this.endsWithNewline = true;
            }
            // This is an optimization. If the current indent is "", then we don't have to do any
            // of the more complex stuff further down.
            if ((this.currentIndentField.Length == 0))
            {
                this.GenerationEnvironment.Append(textToAppend);
                return;
            }
            // Everywhere there is a newline in the text, add an indent after it
            textToAppend = textToAppend.Replace(global::System.Environment.NewLine, (global::System.Environment.NewLine + this.currentIndentField));
            // If the text ends with a newline, then we should strip off the indent added at the very end
            // because the appropriate indent will be added when the next time Write() is called
            if (this.endsWithNewline)
            {
                this.GenerationEnvironment.Append(textToAppend, 0, (textToAppend.Length - this.currentIndentField.Length));
            }
            else
            {
                this.GenerationEnvironment.Append(textToAppend);
            }
        }
        /// <summary>
        /// Write text directly into the generated output
        /// </summary>
        public void WriteLine(string textToAppend)
        {
            this.Write(textToAppend);
            this.GenerationEnvironment.AppendLine();
            this.endsWithNewline = true;
        }
        /// <summary>
        /// Write formatted text directly into the generated output
        /// </summary>
        public void Write(string format, params object[] args)
        {
            this.Write(string.Format(global::System.Globalization.CultureInfo.CurrentCulture, format, args));
        }
        /// <summary>
        /// Write formatted text directly into the generated output
        /// </summary>
        public void WriteLine(string format, params object[] args)
        {
            this.WriteLine(string.Format(global::System.Globalization.CultureInfo.CurrentCulture, format, args));
        }
        /// <summary>
        /// Raise an error
        /// </summary>
        public void Error(string message)
        {
            System.CodeDom.Compiler.CompilerError error = new global::System.CodeDom.Compiler.CompilerError();
            error.ErrorText = message;
            this.Errors.Add(error);
        }
        /// <summary>
        /// Raise a warning
        /// </summary>
        public void Warning(string message)
        {
            System.CodeDom.Compiler.CompilerError error = new global::System.CodeDom.Compiler.CompilerError();
            error.ErrorText = message;
            error.IsWarning = true;
            this.Errors.Add(error);
        }
        /// <summary>
        /// Increase the indent
        /// </summary>
        public void PushIndent(string indent)
        {
            if ((indent == null))
            {
                throw new global::System.ArgumentNullException("indent");
            }
            this.currentIndentField = (this.currentIndentField + indent);
            this.indentLengths.Add(indent.Length);
        }
        /// <summary>
        /// Remove the last indent that was added with PushIndent
        /// </summary>
        public string PopIndent()
        {
            string returnValue = "";
            if ((this.indentLengths.Count > 0))
            {
                int indentLength = this.indentLengths[(this.indentLengths.Count - 1)];
                this.indentLengths.RemoveAt((this.indentLengths.Count - 1));
                if ((indentLength > 0))
                {
                    returnValue = this.currentIndentField.Substring((this.currentIndentField.Length - indentLength));
                    this.currentIndentField = this.currentIndentField.Remove((this.currentIndentField.Length - indentLength));
                }
            }
            return returnValue;
        }
        /// <summary>
        /// Remove any indentation
        /// </summary>
        public void ClearIndent()
        {
            this.indentLengths.Clear();
            this.currentIndentField = "";
        }
        #endregion
    }
    #endregion
}
