/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿// -----------------------------------------------------------------------
// <copyright file="TestBench.cs" company="">
// TODO: Update copyright text.
// </copyright>
// -----------------------------------------------------------------------

namespace CyPhySoT
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using GME.MGA;
    using System.IO;

    /// <summary>
    /// TODO: Update summary.
    /// </summary>
    public class TestBench
    {
        public string ProgId { get; set; }
        public Dictionary<string, string> ParametersDict { get; set; }
        public string OutputDirectory { get; set; }
        public string OriginalProjectFileName { get; set; }

        public string Name { get; set; }

        public string RunCommand { get; set; }
        public string ArtifactPattern { get; set; }
        public string Labels { get; set; }
        public string BuildQuery { get; set; }
        public string ResultsZip { get; set; }

        public List<TestBench> UpstreamTestBenches { get; set; }
        public List<TestBench> DownstreamTestBenches { get; set; }

        public MgaProject Project { get; set; }
        private string m_CurrentObjId { get; set; }
        private MgaFCO m_CurrentObj;
        internal MgaFCO CurrentObj
        {
            get
            {
                return m_CurrentObj;
            }
            set
            {
                m_CurrentObjId = value.ID;
                m_CurrentObj = value;
            }
        }
        public MgaFCOs SelectedObjs { get; set; }
        public int ParamInvoke { get; set; }

        public IMgaComponentEx Interpreter { get; set; }


        public TestBench()
        {
            this.ParametersDict = new Dictionary<string, string>();
            this.SelectedObjs = (MgaFCOs)Activator.CreateInstance(Type.GetTypeFromProgID("Mga.MgaFCOs"));
            this.UpstreamTestBenches = new List<TestBench>();
            this.DownstreamTestBenches = new List<TestBench>();
        }

        public void Run()
        {
            var terr = this.Project.BeginTransactionInNewTerr();

            this.CurrentObj = this.Project.GetFCOByID(this.m_CurrentObjId);

            AVM.DDP.MetaAvmProject avmProj = AVM.DDP.MetaAvmProject.Create(Path.GetDirectoryName(OriginalProjectFileName), Project);
            avmProj.SaveSummaryReportJson(this.OutputDirectory, this.CurrentObj);
            avmProj.UpdateResultsJson(this.CurrentObj, this.OutputDirectory);
            // TODO: test bench export??
            
            this.Project.AbortTransaction();

            Type t = Type.GetTypeFromProgID(ProgId);
            var interpreter = Activator.CreateInstance(t) as IMgaComponentEx;
            
            this.Interpreter = interpreter;

            interpreter.Initialize(Project);

            // deserialize parameters and pass those to the interpreter
            foreach (var item in ParametersDict)
            {
                interpreter.ComponentParameter[item.Key] = item.Value;
            }
            interpreter.ComponentParameter["output_dir"] = this.OutputDirectory;
            interpreter.ComponentParameter["automation"] = "true";
            interpreter.ComponentParameter["do_config"] = "false";
            interpreter.ComponentParameter["original_project_file"] = this.OriginalProjectFileName;

            interpreter.InvokeEx(
                Project,
                CurrentObj,
                SelectedObjs,
                ParamInvoke);

            this.RunCommand = interpreter.ComponentParameter["runCommand"] as string;
            this.Labels = interpreter.ComponentParameter["labels"] as string;
            this.BuildQuery = interpreter.ComponentParameter["build_query"] as string;

            if (String.IsNullOrWhiteSpace(interpreter.ComponentParameter["results_zip_py"] as string) == false)
            {
                this.ResultsZip = interpreter.ComponentParameter["results_zip_py"] as string;
            }

            this.Project.BeginTransaction(terr);
            // if some magic happens in the test bench and some interpreters would update the model
            // and they are NOT updating the summary file accordingly we will do it here.
            // RISK: if any interpreter wants to update the summary file like CyPython this could mess up the values.
            avmProj.SaveSummaryReportJson(this.OutputDirectory, this.CurrentObj);

            this.Project.AbortTransaction();
        }

        internal object DoConfig()
        {
            Type t = Type.GetTypeFromProgID(ProgId);
            var interpreter = Activator.CreateInstance(t) as IMgaComponentEx;
            interpreter.Initialize(Project);
            interpreter.ComponentParameter["do_config"] = "true";

            interpreter.InvokeEx(
                Project,
                CurrentObj,
                SelectedObjs,
                ParamInvoke);

            RunCommand = interpreter.ComponentParameter["runCommand"] as string;

            return interpreter.ComponentParameter["config"];
        }


    }
}
