/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#include "ThermalHelper.h"
//#include "ThermalOptions.h"

//#include "UdmConsole.h"
//#include "AssemblyInterface.h"
//#include "..\CyPhy2CAD\CyPhy2CADVisitor.h"

#include "..\CyPhy2CAD\CommonHelper.h"
#include "..\CyPhy2CAD\CADDataCreator.h"
#include <fstream>
#include "..\CyPhy2CAD\CommonUtils.h"

extern string CadXmlOutputDirectory;


/** \brief CreateCADOutputFile for CyPhyML::ComponentAssembly
    \return void
*/
bool CyPhyThermalHelper::CreateCADOutputFile(CyPhyML::ComponentAssembly &assembly, set<CyPhyML::StructuralInterfaceDefinitions> &sids, long startingElement)
{

#if 0
	Udm::SmartDataNetwork dn_assemblyInterface(AssemblyInterface::diagram);

	std::string outFile = "\\" + CleanString(std::string(assembly.name())) + "_Thermal.xml"; 

	dn_assemblyInterface.CreateNew(CadXmlOutputDirectory+outFile, "AssemblyInterface", AssemblyInterface::Assembly::meta);
	AssemblyInterface::Assembly TargetRoot = AssemblyInterface::Assembly::Cast(dn_assemblyInterface.GetRootObject());
	AssemblyInterface::Properties properties = AssemblyInterface::Properties::Create(TargetRoot);
	AssemblyInterface::Units unit = AssemblyInterface::Units::Create(properties);
	unit.Value() = "value1";

	BuildStructuralIfaceMap(sids);
	CADDataCreator myvisitor(CadXmlOutputDirectory, TargetRoot, 1);
	myvisitor.ProcessTopAssembly(assembly);	
	
	dn_assemblyInterface.CloseWithUpdate();
#endif 

#if 0
	CyPhy2CADVisitor myvisitor(TargetTopComponent, 1);

	for (set<CyPhyML::StructuralInterfaceDefinitions>::iterator it = sids.begin(); it != sids.end(); it++)
	{
		CyPhyML::StructuralInterfaceDefinitions sid(*it);
		sid.Accept(myvisitor);
	}

	//myvisitor.PrintStructuralIfaceMap();

	myvisitor.TraverseAssembly(assembly, startingElement);
#endif

	set<CyPhyML::MaterialsBase> materials;
	CADDataCreator myvisitor(CadXmlOutputDirectory, materials, 1);
	if (myvisitor.ProcessTopAssembly(assembly))
	{	
		GMEConsole::Console::writeLine("Generated Thermal CAD Xml File in: " + CadXmlOutputDirectory, MSG_INFO);
		return 1;
	}
	else
		return 0;	

}

/** \brief GenerateCADFile for CyPhyML::ComponentAssembly
    \return void
*/
void CyPhyThermalHelper::GenerateCADFile(CyPhyML::ComponentAssembly &assembly, CyPhyML::RootFolder &rf, long startingElement)
{
	std::set<CyPhyML::StructuralInterfaceDefinitions> sids;
	this->GetStructuralInterfaceDefinitions(rf, sids);

	if (this->CreateCADOutputFile(assembly, sids, startingElement))
	{
		std::vector<std::string> names;
		std::string cleanName = CommonUtil::CleanString(std::string(assembly.name()));
		names.push_back(cleanName);
		this->CreateCADBatFile(names, cleanName);
	}
}

/** \brief GenerateCADFile for set<CyPhyML::ComponentAssembly>
    \return void
*/
void CyPhyThermalHelper::GenerateCADFile(std::set<CyPhyML::ComponentAssembly> &componentAssembly_Set, CyPhyML::RootFolder &rf)
{
	std::set<CyPhyML::StructuralInterfaceDefinitions> sids;
	this->GetStructuralInterfaceDefinitions(rf, sids);

	std::vector<std::string> names;
	std::string batName;
	for (std::set<CyPhyML::ComponentAssembly>::iterator i = componentAssembly_Set.begin(); i != componentAssembly_Set.end(); i++)
	{
		CyPhyML::ComponentAssembly assembly(*i);

		if (CreateCADOutputFile(assembly, sids, -1))
		{
			names.push_back(CommonUtil::CleanString(std::string(assembly.name())));
			batName += (std::string)assembly.name() + "_";
		}
	}

	if (names.size() > 0)
		this->CreateCADBatFile(names, CommonUtil::CleanString(batName));
}

/** \brief GenerateCADFile for CyPhyML::ComponentAssembly
    \return void
*/
void CyPhyThermalHelper::GetStructuralInterfaceDefinitions(CyPhyML::RootFolder &rf, std::set<CyPhyML::StructuralInterfaceDefinitions> &sids)
{
	std::set<CyPhyML::Components> C_Set = rf.Components_kind_children();
	for (std::set<CyPhyML::Components>::const_iterator cIt = C_Set.begin(); cIt != C_Set.end(); cIt++) {
		std::set<CyPhyML::StructuralInterfaceDefinitions> SID_Set = (*cIt).StructuralInterfaceDefinitions_kind_children();
		for (std::set<CyPhyML::StructuralInterfaceDefinitions>::iterator sIt = SID_Set.begin(); sIt != SID_Set.end(); sIt++)
		{
			sids.insert(*sIt);
		}
	}

	std::set<CyPhyML::RootFolder> RootFolder_Set = rf.RootFolder_kind_children();
	for (std::set<CyPhyML::RootFolder>::iterator fIt = RootFolder_Set.begin(); fIt != RootFolder_Set.end(); fIt++)
	{
		CyPhyML::RootFolder childRF(*fIt);
		this->GetStructuralInterfaceDefinitions(childRF, sids);
	}
}

/** \brief FindComponentAssembly for CyPhyML::ComponentAssemblies
    \return void
*/
void CyPhyThermalHelper::FindComponentAssembly(CyPhyML::ComponentAssemblies &CAFolder, std::set<CyPhyML::ComponentAssembly> &ComponentAssembly_Composite_Set)
{
	std::set<CyPhyML::ComponentAssembly> CAChildren_Set = CAFolder.ComponentAssembly_kind_children();
	for (std::set<CyPhyML::ComponentAssembly>::iterator i = CAChildren_Set.begin(); i != CAChildren_Set.end(); i++)
	{
		CyPhyML::ComponentAssembly assembly(*i);
		ComponentAssembly_Composite_Set.insert(assembly);
	}

	std::set<CyPhyML::ComponentAssemblies> CAChildFolder_Set = CAFolder.ComponentAssemblies_kind_children();
	for (std::set<CyPhyML::ComponentAssemblies>::iterator i = CAChildFolder_Set.begin(); i != CAChildFolder_Set.end(); i++)
	{
		CyPhyML::ComponentAssemblies assemblies(*i);
		this->FindComponentAssembly(assemblies, ComponentAssembly_Composite_Set);
	}
}


/** \brief CreateCADBatFile for std::vector<std::string>
    \return void
*/
void CyPhyThermalHelper::CreateCADBatFile(std::vector<std::string> &assemblyNames, std::string fileName)
{
	std::string outFile = CadXmlOutputDirectory + "\\" + fileName + "_Thermal.bat";
	std::ofstream file (outFile.c_str());

	if (!file.is_open())
	{
		GMEConsole::Console::writeLine("Could not start a new bat file." + outFile, MSG_ERROR);
		return;
	}

	file<<"REM\tThe following system environment variables must be defined:"<<"\n";
	file<<"REM\tPROE_ISIS_EXTENSIONS\t// typically set to\tC:\\Program Files\\Proe ISIS Extensions"<<"\n";
	file<<"REM\tPROE_INSTALL_PATH\t// typically set to\tC:\\Progra~1\\proeWi~1.0\\"<<"\n\n";
	file<<"echo off"<<"\n";
	file<<"set EXE=\"%PROE_ISIS_EXTENSIONS%\\bin\\assemble_ptc.exe\""<<"\n";
	file<<"set PROE_START_CMD=\"%PROE_INSTALL_PATH%/bin/proe.exe -g:no_graphics -i:rpc_input\""<<"\n";
	file<<"set WORKING_DIR=\""<<CadXmlOutputDirectory<<"\""<<"\n";

	if (assemblyNames.size() > 1)
		file<<"set EXIT_PROMPT=\"NO\""<<"\n";

	for (std::vector<std::string>::iterator i = assemblyNames.begin(); i != assemblyNames.end(); i++)
	{
		if (i == (assemblyNames.end()-1))
			file<<"\nset EXIT_PROMPT=\"YES\""<<"\n";
		file<<"\nset ASSEMBLY_XML_FILE=\""<<*i<<"_Thermal.xml\""<<"\n";	
		file<<"set LOG_FILE=%ASSEMBLY_XML_FILE%.log"<<"\n";
		file<<"%EXE%     %PROE_START_CMD%    \"%PROE_ISIS_EXTENSIONS%\\.\"     %WORKING_DIR%      %ASSEMBLY_XML_FILE%     %LOG_FILE%     %EXIT_PROMPT%"<<"\n";
	}

	file.close();

	GMEConsole::Console::writeLine("Generated Bat File: " + outFile, MSG_INFO);
}