/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#ifndef THERMAL_HELPER_H
#define THERMAL_HELPER_H

#include "CyPhyML.h"
//#include "stdafx.h"



/** \file
    \brief Definition of CyPhyThermalHelper class that calls traversal code and generates thermal cad model assembly file.	    
*/

class CyPhyThermalHelper
{
public:
	CyPhyThermalHelper(){}	
	~CyPhyThermalHelper() {}

	bool CreateCADOutputFile(CyPhyML::ComponentAssembly &assembly, set<CyPhyML::StructuralInterfaceDefinitions> &sids, long startingElement);
	void GenerateCADFile(CyPhyML::ComponentAssembly &, CyPhyML::RootFolder &, long startingElement);
	void GenerateCADFile(std::set<CyPhyML::ComponentAssembly> &, CyPhyML::RootFolder &);

	void GetStructuralInterfaceDefinitions(CyPhyML::RootFolder &, std::set<CyPhyML::StructuralInterfaceDefinitions> &);
//	void Initialize();
	void CreateCADBatFile(std::vector<std::string> &, std::string);

	void FindComponentAssembly(CyPhyML::ComponentAssemblies &, std::set<CyPhyML::ComponentAssembly> &);
public:
	std::map<long, long> structuralIfaceMap;

private:
//	std::string m_cadXmlOutputDirectory;
};

#endif