/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// ThermalOptions.cpp : implementation file
//

//#include "stdafx.h"
#include "ThermalOptions.h"
#include "afxdialogex.h"

#include "afxdlgs.h"

// ThermalOptions dialog

IMPLEMENT_DYNAMIC(ThermalOptions, CDialogEx)

ThermalOptions::ThermalOptions(CWnd* pParent /*=NULL*/)
	: CDialogEx(ThermalOptions::IDD, pParent),
	m_outputDirectory(_T(""))
{

}

ThermalOptions::~ThermalOptions()
{
}

void ThermalOptions::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_OUTPATH, m_outputDirectory);
}


BEGIN_MESSAGE_MAP(ThermalOptions, CDialogEx)
	ON_BN_CLICKED(IDC_CANCEL_BUTTON, &ThermalOptions::OnBnClickedCancelButton)
	ON_BN_CLICKED(IDC_OK_BUTTON, &ThermalOptions::OnBnClickedOkButton)
	ON_BN_CLICKED(IDC_OUTPUT_DIR_BUTTON, &ThermalOptions::OnBnClickedOutputDirButton)
END_MESSAGE_MAP()


// ThermalOptions message handlers


void ThermalOptions::OnBnClickedCancelButton()
{
	// TODO: Add your control notification handler code here
	this->OnCancel();
}


void ThermalOptions::OnBnClickedOkButton()
{
	// TODO: Add your control notification handler code here
	this->UpdateData(1);
	
	if(m_outputDirectory.IsEmpty())
	{
		AfxMessageBox("You must specify the output directory.", MB_ICONINFORMATION );
	}
	else
	{
		this->OnOK();
	}
}


void ThermalOptions::OnBnClickedOutputDirButton()
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	CFolderPickerDialog outputLoc;
	int dialogReturn(outputLoc.DoModal());
	if (dialogReturn == IDOK) {
		this->m_outputDirectory = outputLoc.GetFolderPath();
		UpdateData(false);
	}
}
