/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#pragma once

#include "resource.h"
#include <string>
#include "afxcmn.h"
#include "afxdialogex.h"


/** \file
    \brief Definition of options selection dialog for Thermal interpreter.		    
*/

// ThermalOptions dialog

class ThermalOptions : public CDialogEx
{
	DECLARE_DYNAMIC(ThermalOptions)

public:
	ThermalOptions(CWnd* pParent = NULL);   // standard constructor
	virtual ~ThermalOptions();

// Dialog Data
	enum { IDD = IDD_THERMAL_OPTIONS };


private:
	CString m_outputDirectory;

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedCancelButton();
	afx_msg void OnBnClickedOkButton();
	afx_msg void OnBnClickedOutputDirButton();


	std::string GetOutputDirectory(){return std::string(m_outputDirectory);}
	void SetOutputDirectory(std::string outDirectory){m_outputDirectory = outDirectory.c_str();}
};
