'''
Created on Jan 25, 2012

@author: anagel
'''
import dashboardschema as ds
import sys
import os
from glob import glob

if __name__ == '__main__':
    import optparse
    parser = optparse.OptionParser()
    parser.add_option("-o", "--output", dest="output", default="-")
    (options, args) = parser.parse_args()
    
    e_dashConfigRootObj = None
    metricIDs = set()
    for dashboardDir in args:
        p_dashconfigxml = dashboardDir + "/IFV_DashboardConfig.xml"

        # support multiple Dashboard GME objects by mapping dup Metric IDs to unused Metric IDs
        metricMap = {}

        # Parse XML for existing DashboardConfig file
        dashroot = ds.parsexml_(p_dashconfigxml)
        rootNode = dashroot.getroot()
        rootClass = ds.RootObjectType()
        if e_dashConfigRootObj is None:
            e_dashConfigRootObj = rootClass.factory()
            e_dashConfigRootObj.build(rootNode)
            for metric in e_dashConfigRootObj.get_Metrics().get_Metric():
                metricIDs.add(metric.ID)
        else:
            dconfig = rootClass.factory()
            dconfig.build(rootNode)
            for metric in dconfig.get_Metrics().get_Metric():
                if metric.ID in metricIDs:
                    for i in range(1, 100):
                        ID = "M{:02d}".format(i)
                        if ID not in metricIDs:
                            break
                    else:
                        raise Exception("Ran out of IDs")
                    metricMap[metric.ID] = ID
                    metric.ID = ID
                    metricIDs.add(ID)
                e_dashConfigRootObj.get_Metrics().add_Metric(metric)
            # TODO: copy Requirements too
        
        # Create a dictionary that maps ID -> Configuration object
        d_configEntries = {}
        e_configsContainer = e_dashConfigRootObj.get_Configurations()
        for e_config in e_configsContainer.get_Configuration():
            s_configName = e_config.ID
            d_configEntries[s_configName] = e_config

        ap_metricfiles = list(glob(dashboardDir + "/*/*/IFV_DashboardConfig.xml")) + list(glob(dashboardDir + "/*/*/Metrics.xml"))

        # Okay, now we need to open the metric files and merge them in.
        for p_metricFile in ap_metricfiles:
            metricroot = ds.parsexml_(p_metricFile)
            metricRootNode = metricroot.getroot()
            metricRootClass = ds.RootObjectType()
            e_metricConfigRootObj = metricRootClass.factory()
            e_metricConfigRootObj.build(metricRootNode)
            
            e_metricsConfigsContainer = e_metricConfigRootObj.get_Configurations()
            for e_metricsConfig in e_metricsConfigsContainer.get_Configuration():
                # Find corresponding object in DashConfig
                e_dcConfigObject = d_configEntries.get(e_metricsConfig.ID)
                if e_dcConfigObject is None:
                    assert e_metricsConfig.ID not in metricMap
                    d_configEntries[e_metricsConfig.ID] = e_metricsConfig
                    e_configsContainer.add_Configuration(e_metricsConfig)
                else:
                    for e_metric in e_metricsConfig.ConfigMetric:
                        if e_metric.DefID == "MXXXXXXXX":
                            continue
                        e_metric.DefID = metricMap.get(e_metric.DefID, e_metric.DefID)
                        e_dcConfigObject.add_ConfigMetric( e_metric )

    if options.output == "-":        
       e_dashConfigRootObj.export(sys.stdout, 0)
    else:
       with open(options.output, 'w') as outfile:
           e_dashConfigRootObj.export(outfile, 0)
    
##    # Retrieve Metrics container, then iterate over Metric objects
##    Metrics_Container = rootObj.get_Metrics()
##    print "List of Metrics:"
##    for metric in Metrics_Container.get_Metric():
##        print "\t%s: %s" % (metric.get_ID(),metric.get_Name())
##        print "\t\tFulfills Requirement %s" % (metric.get_FulfillsRequirement())
##        print "\t\t\t%s %s %s" % (metric.get_TargetType(),metric.get_TargetValue(), metric.get_Units())
##    
##    print ""
##    
##    # Retrieve Requirements container, then iterate over Requirement objects.
##    #   These may go several levels deep -- we'll support three levels.
##    Requirements_Container = rootObj.get_Requirements()
##    print "List of Requirements:"
##    for reqt in Requirements_Container.get_Requirement():
##        print "\t%s: %s" % (reqt.get_ID(),reqt.get_Name())
##        for reqt2 in reqt.get_Requirement():
##            print "\t\t%s: %s" % (reqt2.get_ID(),reqt2.get_Name())
##            for reqt3 in reqt2.get_Requirement():
##                print "\t\t\t%s: %s" % (reqt3.get_ID(),reqt3.get_Name())
##            
##    print ""
##    
##    # Retrieve OptionGroups container, then iterate over OptionGroup objects.
##    OptionGroups_Container = rootObj.get_OptionGroups()
##    print "List of Option Groups:"
##    for optgrp in OptionGroups_Container.get_OptionGroup():
##        print "\t%s: %s" % (optgrp.get_ID(),optgrp.get_Name())
##    
##    print ""
##    
##    # Retrieve Configurations container, and iterate over all configurations.
##    #   For each configuration, iterate over metrics, artifacts, and options,
##    #   printing information about each one.
##    print "List of Configurations:"
##    Configurations = rootObj.get_Configurations()
##    ConfigSet = Configurations.get_Configuration()
##    for config in ConfigSet:
##        print "\t%s: %s" % (config.get_ID(), config.get_Name())
##        for metric in config.get_ConfigMetric():
##            print "\t\tMetric %s: %s" % (metric.get_DefID(), metric.get_Value())
##        for artifact in config.get_ConfigArtifact():
##            print "\t\tArtifact %s: %s" % (artifact.get_DefID(), artifact.get_URI())
##        for option in config.get_ConfigOption():
##            print "\t\tGroup %s: %s: %s" % (option.get_GroupID(),option.get_ID(),option.get_Name()) 