Dashboard = {};

Dashboard.DashboardVisualizer = function (config) {
    $.extend(this, config);
    this.create();
};

Dashboard.DashboardVisualizer.prototype = {
    contentHolderE:null,
    dashboardLocation:null,
    dashboardDataXML:null,
    dashboardDataArray:null,
    dashboardDataTable:null,

    columnCharts:[],

    create:function () {
        var that = this;

        this.dashboardLocation = getParameterByName('resource_url');

        if (this.dashboardLocation) {
            $.ajax({
                url:this.dashboardLocation,
                success:function (data) {
                    trace("Load Success");
                    that.dashboardDataXML = data;
                    that.dashboardDataArray = that.convertToArray(data);
                    that.dashboardDataTable = google.visualization.arrayToDataTable(that.dashboardDataArray);
                },
                error:function () {
                    trace("Load Error");
                },

                complete:function () {
                    trace("Load Complete");
                    that.render();
                }
            });
        }

    },

    renderTitle:function () {
        var divE = $('<div/>', {
            'class':'title',
            'text':this.dashboardLocation.substring(this.dashboardLocation.lastIndexOf('/'), this.dashboardLocation.lastIndexOf('.')) +
                ' metrics visualization'
        });
        this.contentHolderE.append(divE);
        this.contentHolderE.attr('id', 'dashboard');
    },

    renderTable:function () {
        var that = this;

        if (this.dashboardDataTable) {
            var tabsTitleE = $('<h3>Charts for metrics</h3>');
            this.contentHolderE.append(tabsTitleE);

            this.chartHolderTabE = $('<div/>', {
                'id':'columnChartTab'
            });
            this.contentHolderE.append(this.chartHolderTabE);

            var chartHolderTabUlE = $('<ul/>');
            this.chartHolderTabE.append(chartHolderTabUlE);


            $(this.dashboardDataArray[0]).each(function (i, key) {

                if (i > 0) {
                    var chartHolderE = $('<li/>');
                    var chartHolderAE = $('<a/>', {
                        'href':'#columnChart' + i,
                        'text':key
                    });
                    chartHolderE.append(chartHolderAE);
                    chartHolderTabUlE.append(chartHolderE);
                }
            });
            var numChartsReady = 0;
            var visualizers = [];

            var filtersTitleE = $('<h3>Filters for metrics</h3>');
            this.contentHolderE.append(filtersTitleE);

            var filtersE = $('<ul/>', {
                'class':'filterList'
            });
            that.contentHolderE.append(filtersE);
            var sliders = [];

            $(this.dashboardDataArray[0]).each(function (i, key) {

                if (i > 0) {
                    var chartHolderE = $('<div/>', {
                        'id':'columnChart' + i
                    });
                    that.chartHolderTabE.append(chartHolderE);

                    var columnChart = new google.visualization.ChartWrapper({
                        'chartType':'ColumnChart',
                        'containerId':'columnChart' + i,
                        'options':{
                            //'width':300,
                            'height':300,
                            'legend':'none',
                            'title':key,
                            //'chartArea':{'left':15, 'top':15, 'right':0, 'bottom':0},
                            //'pieSliceText':'label'
                            series:[
                                {color:'#999'}
                            ],
                            hAxis:{textStyle:{fontName:'Trebuchet MS'}},
                            vAxis:{textStyle:{fontName:'Trebuchet MS'}},
                            tooltip:{textStyle:{fontName:'Trebuchet MS'}}
                        },

                        // Instruct the piechart to use colums 0 (Name) and 3 (Donuts Eaten)
                        // from the 'data' DataTable.
                        'view':{'columns':[0, i]}
                    });

                    that.columnCharts.push(['columnChart' + i , columnChart]);

                    google.visualization.events.addListener(columnChart, 'ready', function (e) {
                        numChartsReady++;
                        if (numChartsReady == that.dashboardDataArray[0].length - 1) {
                            that.chartHolderTabE.tabs({
                                show:function (event, ui) {
                                    $(that.columnCharts).each(function () {
                                        if (this[0] == ui.panel.id) {
                                            this[1].draw();
                                        }
                                    });
                                }});
                        }
                    });


                    visualizers.push(columnChart);

                    var slider1E = $('<li/>', {
                        'id':'slider' + i,
                        'class':'slider'
                    });
                    filtersE.append(slider1E);


                    // calculate increments
                    var unitIncrement = 1;
                    var blockIncrement = 10;
                    var metricValues = [];
                    $(that.dashboardDataArray).each(function (j) {
                        if (j > 0) {
                            metricValues.push(this[i]);
                        }
                    });

                    var range = Math.max.apply(Math, metricValues) - Math.min.apply(Math, metricValues);
                    unitIncrement = range / 100;
                    blockIncrement = range / 10;

                    // Define a slider control for the Age column.
                    var slider = new google.visualization.ControlWrapper({
                        'controlType':'NumberRangeFilter',
                        'containerId':'slider' + i,
                        'maxValue':Math.max.apply(Math, metricValues),
                        'options':{
                            'filterColumnLabel':key,
                            'ui':{
                                'labelStacking':'vertical',
                                'cssClass':'control-slider',
                                'unitIncrement':unitIncrement,
                                'blockIncrement':blockIncrement
                            }
                        }
                    });
                    sliders.push(slider);

                    google.visualization.events.addListener(slider, 'ready', function (e) {
                        // add css
                        $('.google-visualization-controls-slider-thumb').each(function () {
                            $(this).removeClass('google-visualization-controls-slider-thumb');
                            $(this).addClass('controls-slider-thumb');
                        });

                        $('.google-visualization-controls-slider-handle').each(function () {
                            $(this).removeClass('google-visualization-controls-slider-handle');
                            $(this).addClass('controls-slider-handle');
                        });

                        $('.google-visualization-controls-rangefilter-thumblabel').each(function () {
                            $(this).removeClass('google-visualization-controls-rangefilter-thumblabel');
                            $(this).addClass('controls-rangefilter-thumblabel');
                        })
                    });
                }
            });
            // Define a category picker control for the Gender column
            var categoryPicker = new google.visualization.ControlWrapper({
                'controlType':'CategoryFilter',
                'containerId':'control2',
                'options':{
                    'filterColumnLabel':'Gender',
                    'ui':{
                        'labelStacking':'vertical',
                        'allowTyping':false,
                        'allowMultiple':false
                    }
                }
            });


            var tableTitleE = $('<h3>Table view for metrics</h3>');
            this.contentHolderE.append(tableTitleE);

            var tableHolderE = $('<div/>', {
                'id':'tableHolder'
            });
            this.contentHolderE.append(tableHolderE);

            // Define a table
            var table = new google.visualization.ChartWrapper({
                'chartType':'Table',
                'containerId':'tableHolder',
                'options':{
                    'showRowNumber':true,
                    'cssClassNames':{
                        'headerRow':'headerRow',
                        'tableRow':'tableRow',
                        'oddTableRow':'oddTableRow',
                        'selectedTableRow':'selectedTableRow',
                        'hoverTableRow':'hoverTableRow',
                        'headerCell':'headerCell',
                        'tableCell':'tableCell',
                        'rowNumberCell':'rowNumberCell'
                    }
                    //'width': '900px'
                }
            });

            visualizers.push(table);

            // Create a dashboard
            this.dashboard = new google.visualization.Dashboard(document.getElementById('dashboard')).
                // Establish bindings, declaring the both the slider and the category
                // picker will drive both charts.
                //bind([slider, categoryPicker], [pie, table]).
                bind(sliders, visualizers).
                //bind([table]).
                // Draw the entire dashboard.
                draw(this.dashboardDataTable);
        }

    },

    render:function () {
        var that = this;
        this.renderTitle();
        this.renderTable();
        window.onresize = function () {
            $(that.columnCharts).each(function () {
                if (!$('#' + this[0]).hasClass('ui-tabs-hide')) {
                    this[1].draw();
                }
            })
        };
    },


    convertToArray:function (inputXml) {
        var result = [];
        // column headers
        var row = [];
        row.push('Configuration');
        var metrics = [];
        $(inputXml).find('Metric').each(function () {
            row.push($(this).attr('Name') + ' [' + $(this).attr('Units') + ']');
            metrics.push(this);
        });
        result.push(row);
        // configurations
        $(inputXml).find('Configuration').each(function () {
            row = [];
            row.push($(this).attr('Name'));
            var config = $(this);
            $(metrics).each(function () {
                var metric = $(this);
                var found = false;
                config.find('ConfigMetric').each(function () {
                    if ($(this).attr('DefID') == metric.attr('ID')) {
                        // metric values
                        row.push(Number($(this).attr('Value')));
                        found = true;
                    }
                });
                if (!found) {
                    row.push(0.0);
                }
            });
            result.push(row);
        });
        return result;
    }
};