#!/usr/bin/env python
# -*- coding: utf-8 -*- 

#
# Generated Fri Oct 14 14:54:03 2011 by generateDS.py version 2.6b.
#

import sys
import getopt
import re as re_

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError("Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip(): 
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class MetricType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, FulfillsRequirement=None, Name=None, TargetType=None, Units=None, TargetValue=None, ID=None):
        self.FulfillsRequirement = _cast(None, FulfillsRequirement)
        self.Name = _cast(None, Name)
        self.TargetType = _cast(None, TargetType)
        self.Units = _cast(None, Units)
        self.TargetValue = _cast(None, TargetValue)
        self.ID = _cast(None, ID)
        pass
    def factory(*args_, **kwargs_):
        if MetricType.subclass:
            return MetricType.subclass(*args_, **kwargs_)
        else:
            return MetricType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_FulfillsRequirement(self): return self.FulfillsRequirement
    def set_FulfillsRequirement(self, FulfillsRequirement): self.FulfillsRequirement = FulfillsRequirement
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_TargetType(self): return self.TargetType
    def set_TargetType(self, TargetType): self.TargetType = TargetType
    def get_Units(self): return self.Units
    def set_Units(self, Units): self.Units = Units
    def get_TargetValue(self): return self.TargetValue
    def set_TargetValue(self, TargetValue): self.TargetValue = TargetValue
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def export(self, outfile, level, namespace_='', name_='MetricType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetricType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetricType'):
        if self.FulfillsRequirement is not None and 'FulfillsRequirement' not in already_processed:
            already_processed.append('FulfillsRequirement')
            outfile.write(' FulfillsRequirement=%s' % (quote_attrib(self.FulfillsRequirement), ))
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            outfile.write(' Name=%s' % (self.gds_format_string(quote_attrib(self.Name).encode(ExternalEncoding), input_name='Name'), ))
        if self.TargetType is not None and 'TargetType' not in already_processed:
            already_processed.append('TargetType')
            outfile.write(' TargetType=%s' % (quote_attrib(self.TargetType), ))
        if self.Units is not None and 'Units' not in already_processed:
            already_processed.append('Units')
            outfile.write(' Units=%s' % (quote_attrib(self.Units), ))
        if self.TargetValue is not None and 'TargetValue' not in already_processed:
            already_processed.append('TargetValue')
            outfile.write(' TargetValue=%s' % (quote_attrib(self.TargetValue), ))
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            outfile.write(' ID=%s' % (self.gds_format_string(quote_attrib(self.ID).encode(ExternalEncoding), input_name='ID'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='MetricType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MetricType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.FulfillsRequirement is not None and 'FulfillsRequirement' not in already_processed:
            already_processed.append('FulfillsRequirement')
            showIndent(outfile, level)
            outfile.write('FulfillsRequirement = %s,\n' % (self.FulfillsRequirement,))
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            showIndent(outfile, level)
            outfile.write('Name = "%s",\n' % (self.Name,))
        if self.TargetType is not None and 'TargetType' not in already_processed:
            already_processed.append('TargetType')
            showIndent(outfile, level)
            outfile.write('TargetType = %s,\n' % (self.TargetType,))
        if self.Units is not None and 'Units' not in already_processed:
            already_processed.append('Units')
            showIndent(outfile, level)
            outfile.write('Units = %s,\n' % (self.Units,))
        if self.TargetValue is not None and 'TargetValue' not in already_processed:
            already_processed.append('TargetValue')
            showIndent(outfile, level)
            outfile.write('TargetValue = %s,\n' % (self.TargetValue,))
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            showIndent(outfile, level)
            outfile.write('ID = "%s",\n' % (self.ID,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('FulfillsRequirement', node)
        if value is not None and 'FulfillsRequirement' not in already_processed:
            already_processed.append('FulfillsRequirement')
            self.FulfillsRequirement = value
        value = find_attr_value_('Name', node)
        if value is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            self.Name = value
        value = find_attr_value_('TargetType', node)
        if value is not None and 'TargetType' not in already_processed:
            already_processed.append('TargetType')
            self.TargetType = value
        value = find_attr_value_('Units', node)
        if value is not None and 'Units' not in already_processed:
            already_processed.append('Units')
            self.Units = value
        value = find_attr_value_('TargetValue', node)
        if value is not None and 'TargetValue' not in already_processed:
            already_processed.append('TargetValue')
            self.TargetValue = value
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            self.ID = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class MetricType


class MetricsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Metric=None):
        if Metric is None:
            self.Metric = []
        else:
            self.Metric = Metric
    def factory(*args_, **kwargs_):
        if MetricsType.subclass:
            return MetricsType.subclass(*args_, **kwargs_)
        else:
            return MetricsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Metric(self): return self.Metric
    def set_Metric(self, Metric): self.Metric = Metric
    def add_Metric(self, value): self.Metric.append(value)
    def insert_Metric(self, index, value): self.Metric[index] = value
    def export(self, outfile, level, namespace_='', name_='MetricsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetricsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetricsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='MetricsType', fromsubclass_=False):
        for Metric_ in self.Metric:
            Metric_.export(outfile, level, namespace_, name_='Metric')
    def hasContent_(self):
        if (
            self.Metric
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='MetricsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Metric=[\n')
        level += 1
        for Metric_ in self.Metric:
            showIndent(outfile, level)
            outfile.write('model_.MetricType(\n')
            Metric_.exportLiteral(outfile, level, name_='MetricType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Metric':
            obj_ = MetricType.factory()
            obj_.build(child_)
            self.Metric.append(obj_)
# end class MetricsType


class RequirementsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Requirement=None):
        if Requirement is None:
            self.Requirement = []
        else:
            self.Requirement = Requirement
    def factory(*args_, **kwargs_):
        if RequirementsType.subclass:
            return RequirementsType.subclass(*args_, **kwargs_)
        else:
            return RequirementsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Requirement(self): return self.Requirement
    def set_Requirement(self, Requirement): self.Requirement = Requirement
    def add_Requirement(self, value): self.Requirement.append(value)
    def insert_Requirement(self, index, value): self.Requirement[index] = value
    def export(self, outfile, level, namespace_='', name_='RequirementsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RequirementsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RequirementsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='RequirementsType', fromsubclass_=False):
        for Requirement_ in self.Requirement:
            Requirement_.export(outfile, level, namespace_, name_='Requirement')
    def hasContent_(self):
        if (
            self.Requirement
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RequirementsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Requirement=[\n')
        level += 1
        for Requirement_ in self.Requirement:
            showIndent(outfile, level)
            outfile.write('model_.RequirementType(\n')
            Requirement_.exportLiteral(outfile, level, name_='RequirementType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Requirement':
            obj_ = RequirementType.factory()
            obj_.build(child_)
            self.Requirement.append(obj_)
# end class RequirementsType


class RootObjectType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Artifacts=None, Configurations=None, Metrics=None, Requirements=None, OptionGroups=None):
        self.Artifacts = Artifacts
        self.Configurations = Configurations
        self.Metrics = Metrics
        self.Requirements = Requirements
        self.OptionGroups = OptionGroups
    def factory(*args_, **kwargs_):
        if RootObjectType.subclass:
            return RootObjectType.subclass(*args_, **kwargs_)
        else:
            return RootObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Artifacts(self): return self.Artifacts
    def set_Artifacts(self, Artifacts): self.Artifacts = Artifacts
    def get_Configurations(self): return self.Configurations
    def set_Configurations(self, Configurations): self.Configurations = Configurations
    def get_Metrics(self): return self.Metrics
    def set_Metrics(self, Metrics): self.Metrics = Metrics
    def get_Requirements(self): return self.Requirements
    def set_Requirements(self, Requirements): self.Requirements = Requirements
    def get_OptionGroups(self): return self.OptionGroups
    def set_OptionGroups(self, OptionGroups): self.OptionGroups = OptionGroups
    def export(self, outfile, level, namespace_='', name_='RootObjectType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RootObjectType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RootObjectType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='RootObjectType', fromsubclass_=False):
        if self.Artifacts:
            self.Artifacts.export(outfile, level, namespace_, name_='Artifacts', )
        if self.Configurations:
            self.Configurations.export(outfile, level, namespace_, name_='Configurations', )
        if self.Metrics:
            self.Metrics.export(outfile, level, namespace_, name_='Metrics', )
        if self.Requirements:
            self.Requirements.export(outfile, level, namespace_, name_='Requirements', )
        if self.OptionGroups:
            self.OptionGroups.export(outfile, level, namespace_, name_='OptionGroups', )
    def hasContent_(self):
        if (
            self.Artifacts is not None or
            self.Configurations is not None or
            self.Metrics is not None or
            self.Requirements is not None or
            self.OptionGroups is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RootObjectType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Artifacts is not None:
            showIndent(outfile, level)
            outfile.write('Artifacts=model_.ArtifactsType(\n')
            self.Artifacts.exportLiteral(outfile, level, name_='Artifacts')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Configurations is not None:
            showIndent(outfile, level)
            outfile.write('Configurations=model_.ConfigurationsType(\n')
            self.Configurations.exportLiteral(outfile, level, name_='Configurations')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Metrics is not None:
            showIndent(outfile, level)
            outfile.write('Metrics=model_.MetricsType(\n')
            self.Metrics.exportLiteral(outfile, level, name_='Metrics')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.Requirements is not None:
            showIndent(outfile, level)
            outfile.write('Requirements=model_.RequirementsType(\n')
            self.Requirements.exportLiteral(outfile, level, name_='Requirements')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.OptionGroups is not None:
            showIndent(outfile, level)
            outfile.write('OptionGroups=model_.OptionGroupsType(\n')
            self.OptionGroups.exportLiteral(outfile, level, name_='OptionGroups')
            showIndent(outfile, level)
            outfile.write('),\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Artifacts':
            obj_ = ArtifactsType.factory()
            obj_.build(child_)
            self.set_Artifacts(obj_)
        elif nodeName_ == 'Configurations':
            obj_ = ConfigurationsType.factory()
            obj_.build(child_)
            self.set_Configurations(obj_)
        elif nodeName_ == 'Metrics':
            obj_ = MetricsType.factory()
            obj_.build(child_)
            self.set_Metrics(obj_)
        elif nodeName_ == 'Requirements':
            obj_ = RequirementsType.factory()
            obj_.build(child_)
            self.set_Requirements(obj_)
        elif nodeName_ == 'OptionGroups':
            obj_ = OptionGroupsType.factory()
            obj_.build(child_)
            self.set_OptionGroups(obj_)
# end class RootObjectType


class ConfigurationsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Configuration=None):
        if Configuration is None:
            self.Configuration = []
        else:
            self.Configuration = Configuration
    def factory(*args_, **kwargs_):
        if ConfigurationsType.subclass:
            return ConfigurationsType.subclass(*args_, **kwargs_)
        else:
            return ConfigurationsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Configuration(self): return self.Configuration
    def set_Configuration(self, Configuration): self.Configuration = Configuration
    def add_Configuration(self, value): self.Configuration.append(value)
    def insert_Configuration(self, index, value): self.Configuration[index] = value
    def export(self, outfile, level, namespace_='', name_='ConfigurationsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConfigurationsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ConfigurationsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ConfigurationsType', fromsubclass_=False):
        for Configuration_ in self.Configuration:
            Configuration_.export(outfile, level, namespace_, name_='Configuration')
    def hasContent_(self):
        if (
            self.Configuration
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ConfigurationsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Configuration=[\n')
        level += 1
        for Configuration_ in self.Configuration:
            showIndent(outfile, level)
            outfile.write('model_.ConfigurationType(\n')
            Configuration_.exportLiteral(outfile, level, name_='ConfigurationType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Configuration':
            obj_ = ConfigurationType.factory()
            obj_.build(child_)
            self.Configuration.append(obj_)
# end class ConfigurationsType


class ArtifactsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Artifact=None):
        if Artifact is None:
            self.Artifact = []
        else:
            self.Artifact = Artifact
    def factory(*args_, **kwargs_):
        if ArtifactsType.subclass:
            return ArtifactsType.subclass(*args_, **kwargs_)
        else:
            return ArtifactsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Artifact(self): return self.Artifact
    def set_Artifact(self, Artifact): self.Artifact = Artifact
    def add_Artifact(self, value): self.Artifact.append(value)
    def insert_Artifact(self, index, value): self.Artifact[index] = value
    def export(self, outfile, level, namespace_='', name_='ArtifactsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ArtifactsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ArtifactsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ArtifactsType', fromsubclass_=False):
        for Artifact_ in self.Artifact:
            Artifact_.export(outfile, level, namespace_, name_='Artifact')
    def hasContent_(self):
        if (
            self.Artifact
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ArtifactsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Artifact=[\n')
        level += 1
        for Artifact_ in self.Artifact:
            showIndent(outfile, level)
            outfile.write('model_.ArtifactType(\n')
            Artifact_.exportLiteral(outfile, level, name_='ArtifactType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Artifact':
            obj_ = ArtifactType.factory()
            obj_.build(child_)
            self.Artifact.append(obj_)
# end class ArtifactsType


class OptionGroupsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, OptionGroup=None):
        if OptionGroup is None:
            self.OptionGroup = []
        else:
            self.OptionGroup = OptionGroup
    def factory(*args_, **kwargs_):
        if OptionGroupsType.subclass:
            return OptionGroupsType.subclass(*args_, **kwargs_)
        else:
            return OptionGroupsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_OptionGroup(self): return self.OptionGroup
    def set_OptionGroup(self, OptionGroup): self.OptionGroup = OptionGroup
    def add_OptionGroup(self, value): self.OptionGroup.append(value)
    def insert_OptionGroup(self, index, value): self.OptionGroup[index] = value
    def export(self, outfile, level, namespace_='', name_='OptionGroupsType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OptionGroupsType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OptionGroupsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='OptionGroupsType', fromsubclass_=False):
        for OptionGroup_ in self.OptionGroup:
            OptionGroup_.export(outfile, level, namespace_, name_='OptionGroup')
    def hasContent_(self):
        if (
            self.OptionGroup
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='OptionGroupsType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('OptionGroup=[\n')
        level += 1
        for OptionGroup_ in self.OptionGroup:
            showIndent(outfile, level)
            outfile.write('model_.OptionGroupType(\n')
            OptionGroup_.exportLiteral(outfile, level, name_='OptionGroupType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'OptionGroup':
            obj_ = OptionGroupType.factory()
            obj_.build(child_)
            self.OptionGroup.append(obj_)
# end class OptionGroupsType


class OptionGroupType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, Name=None):
        self.ID = _cast(None, ID)
        self.Name = _cast(None, Name)
        pass
    def factory(*args_, **kwargs_):
        if OptionGroupType.subclass:
            return OptionGroupType.subclass(*args_, **kwargs_)
        else:
            return OptionGroupType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def export(self, outfile, level, namespace_='', name_='OptionGroupType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OptionGroupType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OptionGroupType'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            outfile.write(' ID=%s' % (self.gds_format_string(quote_attrib(self.ID).encode(ExternalEncoding), input_name='ID'), ))
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            outfile.write(' Name=%s' % (self.gds_format_string(quote_attrib(self.Name).encode(ExternalEncoding), input_name='Name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='OptionGroupType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='OptionGroupType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            showIndent(outfile, level)
            outfile.write('ID = "%s",\n' % (self.ID,))
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            showIndent(outfile, level)
            outfile.write('Name = "%s",\n' % (self.Name,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            self.ID = value
        value = find_attr_value_('Name', node)
        if value is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            self.Name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class OptionGroupType


class ArtifactType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Type=None, ID=None, Name=None):
        self.Type = _cast(None, Type)
        self.ID = _cast(None, ID)
        self.Name = _cast(None, Name)
        pass
    def factory(*args_, **kwargs_):
        if ArtifactType.subclass:
            return ArtifactType.subclass(*args_, **kwargs_)
        else:
            return ArtifactType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def export(self, outfile, level, namespace_='', name_='ArtifactType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ArtifactType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ArtifactType'):
        if self.Type is not None and 'Type' not in already_processed:
            already_processed.append('Type')
            outfile.write(' Type=%s' % (self.gds_format_string(quote_attrib(self.Type).encode(ExternalEncoding), input_name='Type'), ))
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            outfile.write(' ID=%s' % (self.gds_format_string(quote_attrib(self.ID).encode(ExternalEncoding), input_name='ID'), ))
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            outfile.write(' Name=%s' % (self.gds_format_string(quote_attrib(self.Name).encode(ExternalEncoding), input_name='Name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ArtifactType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ArtifactType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.Type is not None and 'Type' not in already_processed:
            already_processed.append('Type')
            showIndent(outfile, level)
            outfile.write('Type = "%s",\n' % (self.Type,))
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            showIndent(outfile, level)
            outfile.write('ID = "%s",\n' % (self.ID,))
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            showIndent(outfile, level)
            outfile.write('Name = "%s",\n' % (self.Name,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Type', node)
        if value is not None and 'Type' not in already_processed:
            already_processed.append('Type')
            self.Type = value
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            self.ID = value
        value = find_attr_value_('Name', node)
        if value is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            self.Name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ArtifactType


class RequirementType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Tier=None, ID=None, Name=None, Requirement=None):
        self.Tier = _cast(int, Tier)
        self.ID = _cast(None, ID)
        self.Name = _cast(None, Name)
        if Requirement is None:
            self.Requirement = []
        else:
            self.Requirement = Requirement
    def factory(*args_, **kwargs_):
        if RequirementType.subclass:
            return RequirementType.subclass(*args_, **kwargs_)
        else:
            return RequirementType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Requirement(self): return self.Requirement
    def set_Requirement(self, Requirement): self.Requirement = Requirement
    def add_Requirement(self, value): self.Requirement.append(value)
    def insert_Requirement(self, index, value): self.Requirement[index] = value
    def get_Tier(self): return self.Tier
    def set_Tier(self, Tier): self.Tier = Tier
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def export(self, outfile, level, namespace_='', name_='RequirementType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RequirementType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='RequirementType'):
        if self.Tier is not None and 'Tier' not in already_processed:
            already_processed.append('Tier')
            outfile.write(' Tier="%s"' % self.gds_format_integer(self.Tier, input_name='Tier'))
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            outfile.write(' ID=%s' % (self.gds_format_string(quote_attrib(self.ID).encode(ExternalEncoding), input_name='ID'), ))
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            outfile.write(' Name=%s' % (self.gds_format_string(quote_attrib(self.Name).encode(ExternalEncoding), input_name='Name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='RequirementType', fromsubclass_=False):
        for Requirement_ in self.Requirement:
            Requirement_.export(outfile, level, namespace_, name_='Requirement')
    def hasContent_(self):
        if (
            self.Requirement
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='RequirementType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.Tier is not None and 'Tier' not in already_processed:
            already_processed.append('Tier')
            showIndent(outfile, level)
            outfile.write('Tier = %d,\n' % (self.Tier,))
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            showIndent(outfile, level)
            outfile.write('ID = "%s",\n' % (self.ID,))
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            showIndent(outfile, level)
            outfile.write('Name = "%s",\n' % (self.Name,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Requirement=[\n')
        level += 1
        for Requirement_ in self.Requirement:
            showIndent(outfile, level)
            outfile.write('model_.RequirementType(\n')
            Requirement_.exportLiteral(outfile, level, name_='RequirementType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Tier', node)
        if value is not None and 'Tier' not in already_processed:
            already_processed.append('Tier')
            try:
                self.Tier = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            self.ID = value
        value = find_attr_value_('Name', node)
        if value is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            self.Name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Requirement':
            obj_ = RequirementType.factory()
            obj_.build(child_)
            self.Requirement.append(obj_)
# end class RequirementType


class ConfigurationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, ID=None, Name=None, ConfigArtifact=None, ConfigMetric=None, ConfigOption=None):
        self.ID = _cast(None, ID)
        self.Name = _cast(None, Name)
        if ConfigArtifact is None:
            self.ConfigArtifact = []
        else:
            self.ConfigArtifact = ConfigArtifact
        if ConfigMetric is None:
            self.ConfigMetric = []
        else:
            self.ConfigMetric = ConfigMetric
        if ConfigOption is None:
            self.ConfigOption = []
        else:
            self.ConfigOption = ConfigOption
    def factory(*args_, **kwargs_):
        if ConfigurationType.subclass:
            return ConfigurationType.subclass(*args_, **kwargs_)
        else:
            return ConfigurationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ConfigArtifact(self): return self.ConfigArtifact
    def set_ConfigArtifact(self, ConfigArtifact): self.ConfigArtifact = ConfigArtifact
    def add_ConfigArtifact(self, value): self.ConfigArtifact.append(value)
    def insert_ConfigArtifact(self, index, value): self.ConfigArtifact[index] = value
    def get_ConfigMetric(self): return self.ConfigMetric
    def set_ConfigMetric(self, ConfigMetric): self.ConfigMetric = ConfigMetric
    def add_ConfigMetric(self, value): self.ConfigMetric.append(value)
    def insert_ConfigMetric(self, index, value): self.ConfigMetric[index] = value
    def get_ConfigOption(self): return self.ConfigOption
    def set_ConfigOption(self, ConfigOption): self.ConfigOption = ConfigOption
    def add_ConfigOption(self, value): self.ConfigOption.append(value)
    def insert_ConfigOption(self, index, value): self.ConfigOption[index] = value
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def export(self, outfile, level, namespace_='', name_='ConfigurationType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConfigurationType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ConfigurationType'):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            outfile.write(' ID=%s' % (self.gds_format_string(quote_attrib(self.ID).encode(ExternalEncoding), input_name='ID'), ))
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            outfile.write(' Name=%s' % (self.gds_format_string(quote_attrib(self.Name).encode(ExternalEncoding), input_name='Name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ConfigurationType', fromsubclass_=False):
        for ConfigArtifact_ in self.ConfigArtifact:
            ConfigArtifact_.export(outfile, level, namespace_, name_='ConfigArtifact')
        for ConfigMetric_ in self.ConfigMetric:
            ConfigMetric_.export(outfile, level, namespace_, name_='ConfigMetric')
        for ConfigOption_ in self.ConfigOption:
            ConfigOption_.export(outfile, level, namespace_, name_='ConfigOption')
    def hasContent_(self):
        if (
            self.ConfigArtifact or
            self.ConfigMetric or
            self.ConfigOption
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ConfigurationType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            showIndent(outfile, level)
            outfile.write('ID = "%s",\n' % (self.ID,))
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            showIndent(outfile, level)
            outfile.write('Name = "%s",\n' % (self.Name,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('ConfigArtifact=[\n')
        level += 1
        for ConfigArtifact_ in self.ConfigArtifact:
            showIndent(outfile, level)
            outfile.write('model_.ConfigArtifactType(\n')
            ConfigArtifact_.exportLiteral(outfile, level, name_='ConfigArtifactType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('ConfigMetric=[\n')
        level += 1
        for ConfigMetric_ in self.ConfigMetric:
            showIndent(outfile, level)
            outfile.write('model_.ConfigMetricType(\n')
            ConfigMetric_.exportLiteral(outfile, level, name_='ConfigMetricType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('ConfigOption=[\n')
        level += 1
        for ConfigOption_ in self.ConfigOption:
            showIndent(outfile, level)
            outfile.write('model_.ConfigOptionType(\n')
            ConfigOption_.exportLiteral(outfile, level, name_='ConfigOptionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            self.ID = value
        value = find_attr_value_('Name', node)
        if value is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            self.Name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'ConfigArtifact':
            obj_ = ConfigArtifactType.factory()
            obj_.build(child_)
            self.ConfigArtifact.append(obj_)
        elif nodeName_ == 'ConfigMetric':
            obj_ = ConfigMetricType.factory()
            obj_.build(child_)
            self.ConfigMetric.append(obj_)
        elif nodeName_ == 'ConfigOption':
            obj_ = ConfigOptionType.factory()
            obj_.build(child_)
            self.ConfigOption.append(obj_)
# end class ConfigurationType


class ConfigMetricType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, DefID=None, Value=None):
        self.DefID = _cast(None, DefID)
        self.Value = _cast(None, Value)
        pass
    def factory(*args_, **kwargs_):
        if ConfigMetricType.subclass:
            return ConfigMetricType.subclass(*args_, **kwargs_)
        else:
            return ConfigMetricType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DefID(self): return self.DefID
    def set_DefID(self, DefID): self.DefID = DefID
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def export(self, outfile, level, namespace_='', name_='ConfigMetricType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConfigMetricType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ConfigMetricType'):
        if self.DefID is not None and 'DefID' not in already_processed:
            already_processed.append('DefID')
            outfile.write(' DefID=%s' % (self.gds_format_string(quote_attrib(self.DefID).encode(ExternalEncoding), input_name='DefID'), ))
        if self.Value is not None and 'Value' not in already_processed:
            already_processed.append('Value')
            outfile.write(' Value=%s' % (self.gds_format_string(quote_attrib(self.Value).encode(ExternalEncoding), input_name='Value'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ConfigMetricType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ConfigMetricType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.DefID is not None and 'DefID' not in already_processed:
            already_processed.append('DefID')
            showIndent(outfile, level)
            outfile.write('DefID = "%s",\n' % (self.DefID,))
        if self.Value is not None and 'Value' not in already_processed:
            already_processed.append('Value')
            showIndent(outfile, level)
            outfile.write('Value = "%s",\n' % (self.Value,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('DefID', node)
        if value is not None and 'DefID' not in already_processed:
            already_processed.append('DefID')
            self.DefID = value
        value = find_attr_value_('Value', node)
        if value is not None and 'Value' not in already_processed:
            already_processed.append('Value')
            self.Value = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ConfigMetricType


class ConfigArtifactType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, DefID=None, URI=None):
        self.DefID = _cast(None, DefID)
        self.URI = _cast(None, URI)
        pass
    def factory(*args_, **kwargs_):
        if ConfigArtifactType.subclass:
            return ConfigArtifactType.subclass(*args_, **kwargs_)
        else:
            return ConfigArtifactType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_DefID(self): return self.DefID
    def set_DefID(self, DefID): self.DefID = DefID
    def get_URI(self): return self.URI
    def set_URI(self, URI): self.URI = URI
    def export(self, outfile, level, namespace_='', name_='ConfigArtifactType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConfigArtifactType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ConfigArtifactType'):
        if self.DefID is not None and 'DefID' not in already_processed:
            already_processed.append('DefID')
            outfile.write(' DefID=%s' % (self.gds_format_string(quote_attrib(self.DefID).encode(ExternalEncoding), input_name='DefID'), ))
        if self.URI is not None and 'URI' not in already_processed:
            already_processed.append('URI')
            outfile.write(' URI=%s' % (self.gds_format_string(quote_attrib(self.URI).encode(ExternalEncoding), input_name='URI'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ConfigArtifactType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ConfigArtifactType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.DefID is not None and 'DefID' not in already_processed:
            already_processed.append('DefID')
            showIndent(outfile, level)
            outfile.write('DefID = "%s",\n' % (self.DefID,))
        if self.URI is not None and 'URI' not in already_processed:
            already_processed.append('URI')
            showIndent(outfile, level)
            outfile.write('URI = "%s",\n' % (self.URI,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('DefID', node)
        if value is not None and 'DefID' not in already_processed:
            already_processed.append('DefID')
            self.DefID = value
        value = find_attr_value_('URI', node)
        if value is not None and 'URI' not in already_processed:
            already_processed.append('URI')
            self.URI = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ConfigArtifactType


class ConfigOptionType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Name=None, ID=None, GroupID=None):
        self.Name = _cast(None, Name)
        self.ID = _cast(None, ID)
        self.GroupID = _cast(None, GroupID)
        pass
    def factory(*args_, **kwargs_):
        if ConfigOptionType.subclass:
            return ConfigOptionType.subclass(*args_, **kwargs_)
        else:
            return ConfigOptionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Name(self): return self.Name
    def set_Name(self, Name): self.Name = Name
    def get_ID(self): return self.ID
    def set_ID(self, ID): self.ID = ID
    def get_GroupID(self): return self.GroupID
    def set_GroupID(self, GroupID): self.GroupID = GroupID
    def export(self, outfile, level, namespace_='', name_='ConfigOptionType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ConfigOptionType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ConfigOptionType'):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            outfile.write(' Name=%s' % (self.gds_format_string(quote_attrib(self.Name).encode(ExternalEncoding), input_name='Name'), ))
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            outfile.write(' ID=%s' % (self.gds_format_string(quote_attrib(self.ID).encode(ExternalEncoding), input_name='ID'), ))
        if self.GroupID is not None and 'GroupID' not in already_processed:
            already_processed.append('GroupID')
            outfile.write(' GroupID=%s' % (self.gds_format_string(quote_attrib(self.GroupID).encode(ExternalEncoding), input_name='GroupID'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ConfigOptionType', fromsubclass_=False):
        pass
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='ConfigOptionType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.Name is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            showIndent(outfile, level)
            outfile.write('Name = "%s",\n' % (self.Name,))
        if self.ID is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            showIndent(outfile, level)
            outfile.write('ID = "%s",\n' % (self.ID,))
        if self.GroupID is not None and 'GroupID' not in already_processed:
            already_processed.append('GroupID')
            showIndent(outfile, level)
            outfile.write('GroupID = "%s",\n' % (self.GroupID,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('Name', node)
        if value is not None and 'Name' not in already_processed:
            already_processed.append('Name')
            self.Name = value
        value = find_attr_value_('ID', node)
        if value is not None and 'ID' not in already_processed:
            already_processed.append('ID')
            self.ID = value
        value = find_attr_value_('GroupID', node)
        if value is not None and 'GroupID' not in already_processed:
            already_processed.append('GroupID')
            self.GroupID = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ConfigOptionType


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'MetricType'
        rootClass = MetricType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag, 
        namespacedef_='')
    return rootObj


def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'MetricType'
        rootClass = MetricType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="MetricType",
        namespacedef_='')
    return rootObj


def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'MetricType'
        rootClass = MetricType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from dashboardschema import *\n\n')
    sys.stdout.write('import dashboardschema as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "ArtifactType",
    "ArtifactsType",
    "ConfigArtifactType",
    "ConfigMetricType",
    "ConfigOptionType",
    "ConfigurationType",
    "ConfigurationsType",
    "MetricType",
    "MetricsType",
    "OptionGroupType",
    "OptionGroupsType",
    "RequirementType",
    "RequirementsType",
    "RootObjectType"
    ]
