#USAGE OF DASHBOARD_1, 

#REQUIRED MODULES
#MatPlotLib
#numpy
#64-bit windows does NOT support 32-bit numpy installers. 
#A 64 bit installer can be found --HERE--> http://www.lfd.uci.edu/~gohlke/pythonlibs/

#TO DO
#-Add axis labels and config names to bar plot
#-Add MAUT capability to bar plot
#-Add scatterplot returns in read_Weights

import scatterplot1
import scatterplot2

def input(xmlinput):
    import sys
    import dashboardschema as ds
    #Target types == 'Maximize' 'Minimize' 'Is' 'Is Not'
    #STEP 1: READ AND PARSE XML
    dashroot = ds.parsexml_('%s' %xmlinput)
    rootNode = dashroot.getroot()
    rootClass = ds.RootObjectType()
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    
    #STEP 2: ORGANIZE INTO DICTS
    #DefDct = {}
    #ReqDct = {}
    CnfDct = {}
    #MAINDICT
    #There are three dictionaries which are passed by xmlinput (if requested)
    #Definitional Dict
    # - This stores what all of the metrics and options are
    #Requirement Dict
    # - This stores all requirements for the metrics
    #Config Dicts
    # - Each component is stored as a dictionary
    
    #DICT STRUCTURE
    #DefDct -> Metrics & Options -> Codes, Descriptions, Target Types, Targets
    #ReqDct -> Codes, Descriptions -> This seems useless.
    #CnfDct -> Metrics & Options -> Codes and Values (no desc)
    
    #--------------------------------------------------
    #CURRENTLY NOT ENABLED FOR REQUIREMENTS AND DEFINITIONS
    #DEFDCT
    #Metrics = {}
    #Metrics_Container = rootObj.get_Metrics()
    #for metric in Metrics_Container:
        #Metric_Name = metric.get_Name()
        #exec(("%s = {'ID' : '%s', 'TargetType' : '%s', 'TargetValue' : '%s'" \
              #% (Metric_Name,metric.get_ID(),metric.get_TargetType(),metric.get_TargetValue())))
        #exec(("Metrics['%s'] = %s" % (Metric_Name,Metric_Name)))
    
    OptionGroup = {}
    OptionGroups_Container = rootObj.get_OptionGroups()
    for option in OptionGroups_Container.get_OptionGroup():
        OptionGroup[option.get_ID()] = option.get_Name()
        
    #--------------------------------------------------
        
    #CnfDct
    Configurations = rootObj.get_Configurations()
    ConfigSet = Configurations.get_Configuration()
    for config in ConfigSet:       
        metrics = {}
        for metric in config.get_ConfigMetric():
            exec(("metrics['%s'] =  metric.get_Value()" % (metric.get_DefID())))
        options = {}
        for option in config.get_ConfigOption():
            exec(("options['%s'] = {'ID' : '%s', 'Name' : '%s' ,'GroupName' : '%s'}" %(option.get_GroupID(),option.get_ID(),option.get_Name(),OptionGroup[option.get_GroupID()])))
        exec(("%s = {'Name' : '%s', 'Metrics' : metrics, 'Options' : options}" %(config.get_ID(), config.get_Name())))
        exec(("CnfDct['%s'] = %s" %(config.get_ID(),config.get_ID())))
    
    return (CnfDct)

def read_weights(xmlweights):
    
    #WEIGHTS STRUCTURE
    #Weights consist of 1st tier and 2nd tier weights. The total weight for each
    #criteria takes the form of a 2nd level weight multiplied by it's 1st tier
    #counterpart. This is taken in by this function from the XML file. Ideally, 
    #the XML file should have the 2nd tier weights grouped by first tier weight.
    #Outputs only exist for second tier weights, since these should be what maps
    #to the configurations.
    #WtsDct = {MetricID : {Value & Weight}}
    WtsDct = {}
    
    from xml.dom import minidom
    
    xmlwts = minidom.parse(xmlweights)
    Tier1_ = xmlwts.firstChild.getElementsByTagName('Tier1_Input')
    for slider in Tier1_:
        Tier1_ID = slider.attributes["ID"].value
        Tier1_name = slider.attributes["Name"].value
        Tier2_children = slider.childNodes
        WtSlEle = Tier2_children.pop(1)
        Tier1_Wt = WtSlEle.firstChild.data
        Tier2_ = []
        for child in Tier2_children:
            if child.nodeType == 1:
                cDct = {}
                cDct['Value'] = float(Tier1_Wt) * float(child.getElementsByTagName('Weighting_Slider_position')[0].firstChild.data)
                cDct['Type'] = str(child.attributes['Type'].value)
                cDct['Name'] = str(child.attributes['Name'].value)
                cDct['Tier1'] = str(Tier1_ID)
                cDct['Tier1_name'] = str(Tier1_name)
                if int(child.getElementsByTagName('Requirement_Check')[0].firstChild.data):
                    if child.attributes['FormType'].value == 'Slider':
                        cDct['Req'] = str(child.getElementsByTagName('Requirement_Slider_position')[0].firstChild.data)
                    else:
                        cDct['Req'] = str(child.getElementsByTagName('Requirement_Drop_position')[0].firstChild.data)
                else: cDct['Req'] = 'UNUSED'
                exec(("WtsDct['%s'] = cDct" % str(child.attributes['ID'].value)))
    #See example weight structure in debug function
    
    SctList = []
    
    Chart_Data = xmlwts.firstChild.getElementsByTagName('Chart_Data')[0]
    Metrics = Chart_Data.childNodes
    metriclist = []
    metriclist.append(str(Metrics[1].firstChild.data))
    metriclist.append(str(Metrics[3].firstChild.data))
    metriclist.append(str(Metrics[5].firstChild.data))
    metriclist.append(str(Metrics[7].firstChild.data))
    metriclist2 = []
    for metric in metriclist:
        if len(str(metric)) == 1:
            metriclist2.append('M0' + str(metric))
        else:
            metriclist2.append('M' + str(metric))
          
    SctList = [(metriclist2[0],metriclist2[1]),(metriclist2[2],metriclist2[3])]

    ParList = []
    tierlist = []
    tierlist2 = []
    Par_Data = xmlwts.firstChild.getElementsByTagName('Chart_Data')[1]
    Tiers = Par_Data.childNodes
    tierlist.append(str(Tiers[1].firstChild.data))
    tierlist.append(str(Tiers[3].firstChild.data))
    for tier in tierlist:
        if len(str(tier)) == 1:
            tierlist2.append('T20' + str(tier))
        else:
            tierlist2.apend('T2' + str(Tier))
            
    ParList = tierlist2

    return (WtsDct,SctList,ParList)



def TOPSIS_ranking(CfgDct,WtsDct):
    #This function will have two inputs, the performance characteristics and the
    #weights dictionary.
    
    #STEPS IN TOPSIS METHOD
    
    #1 REBUILD TO LISTS
    #2 NORMALIZE LIST TO SUM OF SQUARES
    #3 MULTIPLY BY WEIGHT FACTOR
    #4 COMPUTE DISTANCES FROM IDEAL POS AND NEG
    #5 COMPUTE RELATIVE CLOSENESSES
    # -- Each list represents a single metric. Each metric must have a list.
    for config in CfgDct:
        CfgDct[config]['Tier1wts'] = {}    
    Metrics_List = []
    Config_List = []
    T1Dct = {}
    for config in CfgDct:
        Config_List.append(config)
        T1Dct[config] = {}
    Pos_Value_List = [0]*len(Config_List)
    Neg_Value_List = [0]*len(Config_List)
    for metric in WtsDct:
        Metr = []
        for config in Config_List:
            Metr.append(float(CfgDct[config]['Metrics'][metric]))
        norm = pow(sum([pow(i,2) for i in Metr]),0.5)
        weight = WtsDct[metric]['Value']
        Metr = [(i/norm) * weight for i in Metr]
        if (WtsDct[metric]['Type'] == ('Max')) or (WtsDct[metric]['Type'] == ('Target')):
            PosMetr = [pow((max(Metr) - i),2) for i in Metr]
            NegMetr = [pow((min(Metr) - i),2) for i in Metr]
        elif WtsDct[metric]['Type'] == 'Min':
            PosMetr = [pow((min(Metr) - i),2) for i in Metr]
            NegMetr = [pow((max(Metr) - i),2) for i in Metr]
        exec("%s = Metr" %metric)
        Pos_Value_List = [i+j for i,j in zip(Pos_Value_List,PosMetr)]
        Neg_Value_List = [i+j for i,j in zip(Neg_Value_List,NegMetr)]  
        Metrics_List.append(metric)
        
        Tier1 = WtsDct[metric]['Tier1']
        
        try:
            for configs in zip(Config_List,PosMetr,NegMetr):
                config = configs[0]
                PosMetr_ = configs[1]
                NegMetr_ = configs[2]
                T1Dct[config][Tier1]['Pos'] = T1Dct[config][Tier1]['Pos'] + PosMetr_
                T1Dct[config][Tier1]['Neg'] = T1Dct[config][Tier1]['Neg'] + NegMetr_
        except KeyError:
            for configs in zip(Config_List,PosMetr,NegMetr):
                config = configs[0]
                PosMetr_ = configs[1]
                NegMetr_ = configs[2]
                T1Dct[config][Tier1] = {'Pos':PosMetr_, 'Neg':NegMetr_}
        
    max_sum = 0.0
    for config in T1Dct:
        sum_ = 0.0
        for Tier1 in T1Dct[config]:
            try:
                CfgDct[config]['Tier1wts'][Tier1] = T1Dct[config][Tier1]['Neg'] / (T1Dct[config][Tier1]['Pos'] + T1Dct[config][Tier1]['Neg'])
            except ZeroDivisionError:
                CfgDct[config]['Tier1wts'][Tier1] = 0
            sum_ = sum_ + CfgDct[config]['Tier1wts'][Tier1]
        if max_sum < sum_:
            max_sum = sum_
        
    for config in T1Dct:
        for Tier1 in T1Dct[config]:
            CfgDct[config]['Tier1wts'][Tier1] = CfgDct[config]['Tier1wts'][Tier1] / max_sum
        
    Rel_Value_List = [j / (i + j) for i,j in zip(Pos_Value_List,Neg_Value_List)]
    Rel_Value_List = [i/max(Rel_Value_List) for i in Rel_Value_List]
        
    #2 Normalize all lists
    
    from operator import itemgetter
    rankedopts = sorted(zip(Config_List, Rel_Value_List), key=itemgetter(1), reverse=True)
    
    return(rankedopts,CfgDct)

def MAUT_ranking(CfgDct,WtsDct):
    #This function will have two inputs, the performance characteristics and the
    #weights dictionary.
    
    #STEPS IN MAUT METHOD
    
    #1 REBUILD TO LISTS
    #2 NORMALIZE LIST TO SUM OF SQUARES
    #3 MULTIPLY BY WEIGHT FACTOR
    #4 COMPUTE DISTANCES FROM IDEAL POS AND NEG
    #5 COMPUTE RELATIVE CLOSENESSES
    # -- Each list represents a single metric. Each metric must have a list.
    
    #SETUP LISTS
    T1Dct = {}
    for config in CfgDct:
        CfgDct[config]['Tier1wts'] = {}    
        T1Dct[config] = {}
    Metrics_List = []
    Config_List = []
    for config in CfgDct:
        Config_List.append(config)
    Value_List = [0]*len(Config_List)
  
    
    #ITERATE ACROSS LISTS
    for metric in WtsDct:
        Metr = []
        for config in Config_List:
            Metr.append(float(CfgDct[config]['Metrics'][metric]))
        minMetr = min(Metr)
        maxMetr = max(Metr)
        weight = WtsDct[metric]['Value']
        Metr = [i*weight for i in Metr]
        if maxMetr == minMetr:
            Metr = [0.5]*len(Metr)
        else:
            Metr = [(i - minMetr)/(maxMetr-minMetr) for i in Metr]
        if WtsDct[metric]['Type'] == ('Min' or 'Target'):
            Metr = [abs(1 - i) for i in Metr]
        exec("%s = Metr" %metric)
        Value_List = [(i+j) for i,j in zip(Value_List,Metr)] 
        Metrics_List.append(metric)
        
        Tier1 = WtsDct[metric]['Tier1']
        
        try:
            for configs in zip(Config_List,Metr):
                config = configs[0]
                Metr_ = configs[1]
                T1Dct[config][Tier1]['Value'] = T1Dct[config][Tier1]['Value'] + Metr_
        except KeyError:
            for configs in zip(Config_List,Metr):
                config = configs[0]
                Metr_ = configs[1]
                T1Dct[config][Tier1] = {'Value':Metr_,}
        
    max_sum = 0.0
    for config in T1Dct:
        sum_ = 0.0
        for Tier1 in T1Dct[config]:
            CfgDct[config]['Tier1wts'][Tier1] = T1Dct[config][Tier1]['Value']
            sum_ = sum_ + CfgDct[config]['Tier1wts'][Tier1]
        if max_sum < sum_:
            max_sum = sum_
        
    for config in T1Dct:
        for Tier1 in T1Dct[config]:
            CfgDct[config]['Tier1wts'][Tier1] = CfgDct[config]['Tier1wts'][Tier1] / max_sum
        
    #2 Normalize all lists
    
    from operator import itemgetter
    rankedopts = sorted(zip(Config_List, Value_List), key=itemgetter(1), reverse=True)
 
    return(rankedopts,CfgDct)

def MeetsReqs(CfgDct,WtsDct):
    CfgList = []
    for config in CfgDct:
        CfgList.append(config)
        CfgDct[config]['Feasible'] = 1
    for metric in WtsDct:
        Req = (WtsDct[metric]['Req'])
        
        
        if Req != 'UNUSED':
            Req = float(Req)
            Type = WtsDct[metric]['Type']
            if Type == 'Max':
                CfgList_ = CfgList[:]
                for config in CfgList_:
                    X = float(CfgDct[config]['Metrics'][metric])
                    if X < Req:
                        CfgList.pop(CfgList.index(config))
                        CfgDct[config]['Feasible'] = 0
            elif Type == 'Min':
                CfgList_ = CfgList[:]
                for config in CfgList_:
                    if float(CfgDct[config]['Metrics'][metric]) > Req:
                        CfgList.pop(CfgList.index(config))
                        CfgDct[config]['Feasible'] = 0
            else: #Type == 'Target'
                CfgList_ = CfgList[:]
                for config in CfgList_:
                    if float(CfgDct[config]['Metrics'][metric]) != Req:
                        CfgList.pop(CfgList.index(config))
                        CfgDct[config]['Feasible'] = 0
                        
                        
        
    return(CfgList,CfgDct)

def GenOuts(GenList,CfgDct,WtsDct):
    from xml.dom import minidom
    #from xml.dom import ext
    
    py2xml = minidom.Document() #minidom.parse('Outputs_Setup.xml')
    root_element = py2xml.createElement("Configurations")
    for config in GenList:
        if type(config) == tuple:
            config = config[0]
        xml_config = py2xml.createElement("Configuration")
        xml_config.setAttribute('ID',config)
        xml_config.setAttribute('Feasible',str(CfgDct[config]['Feasible']))
        #xml_config.setAttribute('Name',CfgDct[config]['Name'])
        xml_config.setAttribute('Name','Design ID')
        
        metriclist = []
        for metrics in CfgDct[config]['Metrics']:
            metriclist.append(metrics)
        metriclist.sort()
        for metrics in metriclist:
            metric = py2xml.createElement('ConfigMetric')
            metric.setAttribute('ID',metrics)
            metric.setAttribute('Name',WtsDct[metrics]['Name'])
            metric.setAttribute('Value',CfgDct[config]['Metrics'][metrics])
            xml_config.appendChild(metric)
        
        optionslist = []
        metricID = 'P0'
        for options in CfgDct[config]['Options']:
            optionslist.append(options)
        optionslist.sort()
        for options in optionslist:      
            option = py2xml.createElement('ConfigOption')
            metricID = 'P' + str(int(metricID[1:]) + 1)
            option.setAttribute('ID',metricID)
            option.setAttribute('Value',CfgDct[config]['Options'][options]['Name'])
            option.setAttribute('Name',CfgDct[config]['Options'][options]['GroupName'])
            xml_config.appendChild(option)
        root_element.appendChild(xml_config)
    py2xml.appendChild(root_element)
    xmlfinal = py2xml.toprettyxml()
    with open('OUTPUTS.xml', 'w') as f:
        f.write(xmlfinal)
    #outputs_file.close()
    
def PythonWrapper(RankType):
    import time
    import Dashboard_1
    import paretoplot as parp
    t1 = time.time()
    CfgDct = Dashboard_1.input("sampleconfigs.xml")
    (WtsDct,SctList,ParList) = Dashboard_1.read_weights("USER_INPUT_2.xml")
    if RankType == 'MAUT':
        (CfgList,CfgDct) = Dashboard_1.MAUT_ranking(CfgDct,WtsDct)
    elif RankType == 'TOPSIS':
        (CfgList,CfgDct) = Dashboard_1.TOPSIS_ranking(CfgDct,WtsDct)
    else:
        print 'Unknown ranking type'
        time.sleep(2)
        raise Exception("Bad RankType value")
    (MeetsList,CfgDct) = MeetsReqs(CfgDct,WtsDct)
    MeetsList2 = [i for i,j in CfgList]
    MeetsList3 = [i for i in MeetsList2 if i in MeetsList]
    FailsList = [i for i in MeetsList2 if i not in MeetsList]
    CfgList2 = MeetsList3 + FailsList
    GenList = CfgList2[0:10]
    
    PlotList = CfgList
    PlotList2 = [i for i,j in PlotList]
    PlotList3 = []
    
    for item in GenList:
        PlotList3.append(PlotList[PlotList2.index(item)])
    
    t2 = time.time()
    print(t2 - t1)
    Dashboard_1.GenOuts(GenList,CfgDct,WtsDct)
    t3 = time.time()
    print(t3 - t2)
    Dashboard_1.PyPlot(WtsDct,CfgDct, PlotList3, RankType)
    t4 = time.time()
    scatterplot1.skattaplot1(CfgList,WtsDct,CfgDct,SctList)
    scatterplot2.skattaplot2(CfgList,WtsDct,CfgDct,SctList)
    parp.paretoplot(CfgDct,ParList,WtsDct)
    print(t4 - t3)
    return()

def PyPlot(WtsDct,CfgDct, CfgList_, Type):
    from pylab import *
    totalVal = 0
    #from pylab import pie, figure, axes, title, savefig
    
    NameList = []
    ValueList = []
    T1Dct = {}
    for metric in WtsDct:
        totalVal = totalVal + float(WtsDct[metric]['Value'])
        ValueList.append(WtsDct[metric]['Value'])
        NameList.append(WtsDct[metric]['Name'])
        T1Dct[WtsDct[metric]['Tier1']] = WtsDct[metric]['Tier1_name']
    ValueList = [float(i)/totalVal*100 for i in ValueList]

    explode=tuple([0.05]*len(ValueList))
    colors=('b', 'g', 'r', 'c', 'm', 'y', 'w', 'Silver','Gray','Maroon','Purple','DarkGoldenRod','Coral','Crimson','DarkKhaki','LightGreen','Lime','MediumSlateBlue','MediumOrchid','LightSteelBlue','PeachPuff','RosyBrown','Thistle')
    
    figure(figsize=(8,8))
    ax = axes([0.29, 0.25, 0.47, 0.5])
    patches = pie(ValueList, colors=colors, explode=explode, autopct='%1.f%%', shadow=False, labels=NameList)
    title('Weights Breakdown')

    savefig('plot2')
    
    #TOPSIS BAR PLOT----------------------------------------------------------
    #STEPS FOR METAX CODE:
    #1 - Extract data and put intp lists

    #Step 1:
    figure(figsize=(8,8))
    CfgList = CfgList_[::-1] #Select top 10 configs to plot
    TierList = []
    k = 0
    
    if Type == 'TOPSIS':
        for configs in CfgList:
            config = configs[0]
            RankVal = configs[1]
            configsum = 0
            for tier in CfgDct[config]['Tier1wts']:
                configsum = configsum + float(CfgDct[config]['Tier1wts'][tier])
            for tier in CfgDct[config]['Tier1wts']:
                bar_value = CfgDct[config]['Tier1wts'][tier]*RankVal/configsum
                try:
                    exec("%s.append(bar_value)" %(tier))
                except NameError:
                    exec("%s = [bar_value]" %(tier))
                    TierList.append(tier)
        TierList.sort()
        for tier in TierList:
            exec("%s = tuple(%s)" %(tier,tier))
            
            
        height = 0.35
        N = len(CfgList)
        
        ind = np.arange(N) + 0.5 - height/2
        
        left = tuple([0] * N)
        
        k = 0
        for tier_ in TierList:
            exec("tier = %s" %(tier_))
            exec("p%i = plt.barh(ind, tier, height, left, color='%s')" %(k, colors[k]))
            left = [i + j for i,j in zip(left,tier)]
            k = k + 1
        title('TOPSIS ranking')
        
    elif Type == 'MAUT':
        for configs in CfgList:
            config = configs[0]
            for tier in CfgDct[config]['Tier1wts']:
                try:
                    exec("%s.append(CfgDct[config]['Tier1wts'][tier])" %(tier))
                except NameError:
                    exec("%s = [CfgDct[config]['Tier1wts'][tier]]" %(tier))
                    TierList.append(tier)
        TierList.sort()
        for tier in TierList:
            exec("%s = tuple(%s)" %(tier,tier))
                
        N = len(CfgList)
        height = 0.35
        ind = np.arange(N) + 0.5 - height/2
        left = tuple([0] * N)
        
        k = 0
        for tier_ in TierList:
            exec("tier = %s" %(tier_))
            exec("p%i = plt.barh(ind, tier, height, left, color='%s')" %(k, colors[k]))
            left = [i + j for i,j in zip(left,tier)]
            k = k + 1
        title('OEC ranking')
    
    #Add a horizontal line above the infeasible cases
    pval = left[0]
    x = 1.0
    for val in left[1:]:
        if val < pval:
            plot([0,1],[x,x],'r')
            text(0.8,x-0.23,'infeasible cases',fontsize=9, style = 'italic', color = 'red')
        else:
            pval = val
            x = x+1
            
    
    
    #Add a legend
    nametup = tuple([i for i,j in CfgList])
    xlabel('Factors sorted by tier')
    yticks(ind+height/2., nametup )
    legendlist = []
    TierList2 = [T1Dct[i] for i in TierList]
    for i in range(0,k):
        exec("item = p%i[0]" %i)
        item
        legendlist.append(item)    
    legend( legendlist, TierList2, loc=3 )
    
    savefig('plot1')
    return()
               

if __name__ == '__main__':
    import Dashboard_1
    import scatterplot1 as sct1
    import scatterplot2 as sct2
    CfgDct = Dashboard_1.input("sampleconfigs.xml")
    (WtsDct,SctList,ParList) = Dashboard_1.read_weights("USER_INPUT_2.xml")                
    #CfgList = Dashboard_1.TOPSIS_ranking(CfgDct,WtsDct)
    (CfgList,CfgDct) = Dashboard_1.TOPSIS_ranking(CfgDct,WtsDct)
    (MeetsList,CfgDct) = MeetsReqs(CfgDct,WtsDct)
    GenOuts(CfgList,CfgDct,WtsDct)
    PyPlot(WtsDct,CfgDct, CfgList, 'TOPSIS')
    sct1.skattaplot1(CfgList,WtsDct,CfgDct,SctList)
    sct2.skattaplot2(CfgList,WtsDct,CfgDct,SctList)
    #Dash_Barred()
    print CfgList