def paretoplot(CfgDct,ParList,WtsDct):
    
    import Veusz.embed as veusz
    from operator import itemgetter
        
    # Create full lists of all feasible and infeasible data for pareto plot generation
    
    TierX = ParList[1]
    TierY = ParList[0]
    X1 = []
    X2 = []
    feas_label = []
    tier_X_feas = []
    tier_Y_feas = []
    infeas_label = []
    tier_X_infeas = []
    tier_Y_infeas = []
    CfgList = []
    for config in CfgDct:
        X1.append(CfgDct[config]['Tier1wts'][TierX])
        X2.append(CfgDct[config]['Tier1wts'][TierY])
        CfgList.append(config)
        
    for config in CfgDct:
        if CfgDct[config]['Feasible']:
            tier_X_feas.append(CfgDct[config]['Tier1wts'][TierX])
            tier_Y_feas.append(CfgDct[config]['Tier1wts'][TierY])
            feas_label.append(config)
            # other feasible configurations
        else:
            tier_X_infeas.append(CfgDct[config]['Tier1wts'][TierX])
            tier_Y_infeas.append(CfgDct[config]['Tier1wts'][TierY])
            infeas_label.append(config)
    
    # Generate ordered list of points to build pareto frontier
    # Steps in listing points:
    #1: Make new lists of distances from ideals to account for max/min preferences
    #2: Zip metric 1/2 data together to form x/y pairs along with dist from ideals
    #3: Eliminate all data away from the ideal of metric 2 from ideal met 1
    #4: Eliminate all data away from the ideal of met 1 from met 2
    #5: Starting with leftmost ideal data location (should be max):
    #6a: Identify next point and calculate line from x/y pairs
    #6b: For each next point: 
    #    if below line, select as new point and recauculate line
    #    if above, discard previous and backcheck to see if above
    #    once below, recauculate line and proceed to next point
    #7: End on last point
    
    #1
    all_tier_X = X1
    all_tier_Y = X2
    
    #X1 = [max(X1) - x for x in X1]
    #X2 = [max(X2) - x for x in X2]
    
    #2    
    ParList = zip(X1,X2,all_tier_X,all_tier_Y,CfgList)
    
    #3
    ParList = sorted(ParList, key=itemgetter(0))
    ind = 0
    for line in ParList:
        if line[1] == max(X2):
            ind2 = ind
        ind = ind + 1
    ParList = ParList[ind2:]
    
    ##4
    ParList = sorted(ParList, key = itemgetter(1))
    ind = 0
    for line in ParList:
        if line[0] == max(X1):
            ind2 = ind
        ind = ind + 1
    ParList = ParList[ind2:]
        
    #5    
    #Currently, values are sorted in order of met 2
    #Start from bottom of Met 2 (max Met 1) and move across
    
    if len(ParList) > 2:
        ParList2 = ParList[0:2]
        
        rearY = ParList[0][0]
        rearX = ParList[0][1]
        frontY = ParList[1][0]
        frontX = ParList[1][1]
        for line in ParList[2:]:
            intercept = (frontY-rearY)/(frontX-rearX)*(line[1]-rearX) + rearY
            if line[0] < intercept:
                rearY = frontY
                rearX = frontX
                frontY = line[0]
                frontX = line[1]
                ParList2.append(line)
            else: #above or on line:
                ParList2.pop()
                ncomplete = 1
                while ncomplete:
                    if len(ParList2) > 1:
                        frontY = ParList2[-1][0]
                        frontX = ParList2[-1][1]
                        rearY = ParList2[-2][0]
                        rearX = ParList2[-2][1]
                        intercept = (frontY-rearY)/(frontX-rearX)*(line[1]-rearX) + rearY
                        if line[0] < intercept:
                            rearY = frontY
                            rearX = frontX
                            frontY = line[0]
                            frontX = line[1]
                            ParList2.append(line)
                            ncomplete = 0
                        else:
                            ParList2.pop()
                    else:
                        ncomplete = 0
                        frontY = line[0]
                        frontX = line[1]
                        ParList2.append(line)
    else:
        ParList2 = ParList
                        
    ParX = [i for x,y,i,j,k in ParList2]
    ParY = [j for x,y,i,j,k in ParList2]
    
    TierDct = {}
    for metric in WtsDct:
        TierDct[WtsDct[metric]['Tier1']] = WtsDct[metric]['Tier1_name']
    
    g = veusz.Embedded('Paretoplot')
    g.EnableToolbar()
    
    feasstring = str.join("\n",feas_label)
    infeasstring = str.join("\n",infeas_label)
    #textstring = ''' '2'\nu'thing2'\n'thing1'\n'thuing3'\n'thing4' '''
    g.ImportString(u'f_label(text)',feasstring)
    g.ImportString(u'i_label(text)',infeasstring)
    
     # Create page to hold graph
    g.Add('page', name='page1', autoadd=False)
    g.To('page1')
    g.Set('width', '24.4cm')
    g.Set('height', '16.3cm')
    
    # Create graph to hold data
    g.Add('graph', name=u'Paretoplot', autoadd=False)
    g.To(u'Paretoplot')
    g.Add('axis', name='x', autoadd=True)
    g.To('x')
    g.Set('label', u'%s' %(TierDct[TierX]))
    g.Set('autoExtend', True)
    g.Set('autoExtendZero', True)
    g.Set('lowerPosition', 0.0)
    g.Set('upperPosition', 1.0)
    g.Set('otherPosition', 0.0)
    g.To('..')
    g.Add('axis', name='y', autoadd=False)
    g.To('y')
    g.Set('label', u'%s' %(TierDct[TierY]))
    g.Set('autoExtend', True)
    g.Set('autoExtendZero', True)
    g.Set('direction', 'vertical')
    g.To('..')
    
    #Pareto plot
    g.Add('xy', name=u'Pareto Frontier', autoadd=False)
    g.To(u'Pareto Frontier')
    g.Set('xData', ParX)
    g.Set('yData', ParY)
    g.Set('marker', u'none')
    g.Set('PlotLine/color', u'blue')
    g.Set('PlotLine/width', u'1pt')
    g.Set('PlotLine/style', u'dashed')
    g.Set('key', u'Pareto Frontier')
    g.To('..')
    
    #Feasible and infeasible data
    g.Add('xy', name=u'infeasible', autoadd=False)
    g.To(u'infeasible')
    g.Set('xData', tier_X_infeas)
    g.Set('yData', tier_Y_infeas)
    g.Set('marker', u'diamond')
    g.Set('markerSize', u'2pt')
    g.Set('scalePoints', [])
    g.Set('PlotLine/color', u'red')
    g.Set('PlotLine/width', u'0pt')
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'red')
    g.Set('MarkerFill/color', u'red')
    g.Set('key', u'Infeasible Points')
    g.Set('labels',u'i_label')
    g.To('..')
    g.Add('xy', name=u'feasible', autoadd=False)
    g.To(u'feasible')
    g.Set('xData', tier_X_feas)
    g.Set('yData', tier_Y_feas)
    g.Set('markerSize', u'2pt')
    g.Set('thinfactor', 1)
    g.Set('key', u'')
    g.Set('labels', u'')
    g.Set('scalePoints', [])
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'green')
    g.Set('MarkerLine/transparency', 100)
    g.Set('MarkerFill/color', u'green')
    g.Set('key', u'Feasible Points')
    g.Set('labels',u'f_label')
    g.To('..')
    
    g.Add('key', name='key1', autoadd=False)
    g.To('key1')
    g.Set('Text/size', u'14pt')
    g.Set('Border/hide', True)
    g.Set('horzPosn', u'left')
    g.To('..')
    
    # zoom out
    g.Zoom(0.8)
    
    g.Export('plot7.png', color=True, page=0)
    
    g.Close()
    return()

if __name__ == '__main__':
    import paretoplot as parp
    import Dashboard_1 as dash
    CfgDct = dash.input("sampleconfigs.xml")
    (WtsDct,SctList,ParList) = dash.read_weights("USER_INPUT_2.xml")                
    (CfgList,CfgDct) = dash.TOPSIS_ranking(CfgDct,WtsDct)
    (MeetsList,CfgDct) = dash.MeetsReqs(CfgDct,WtsDct)
    parp.paretoplot(CfgDct,ParList,WtsDct)