# This code generates scatterplot1

def skattaplot1(CfgList,WtsDct,CfgDct,SctList):
    Metric1 = SctList[0][0]
    Metric2 = SctList[0][1]
    
    Type1 = WtsDct[Metric1]['Type']
    Type2 = WtsDct[Metric2]['Type']
    
    pareto = 0
    if ((Type1 == 'Min')|(Type1 == 'Max')) & ((Type2 == 'Min')|(Type2 == 'Max')):
        pareto = 1
    
    import Veusz.embed as veusz
    from operator import itemgetter
    
    # Define lists for infeasible configurations metric values
    metric_1_infeas=[]
    metric_2_infeas=[]
    
    # Define lists for feasible (not top ten) configurations metric values
    metric_1_feas=[]
    metric_2_feas=[]
    
    feas_label = []
    infeas_label = []
    
    # Populate lists with coordinates for scatterplots
    CfgList = CfgList[0:10]
    CfgList = [i for i,j in CfgList]
    for config in CfgDct:
        if CfgDct[config]['Feasible']:
            metric_1_feas.append(CfgDct[config]['Metrics'][Metric1])
            metric_2_feas.append(CfgDct[config]['Metrics'][Metric2])
            feas_label.append(config)
            # other feasible configurations
        else:
            metric_1_infeas.append(CfgDct[config]['Metrics'][Metric1])
            metric_2_infeas.append(CfgDct[config]['Metrics'][Metric2])
            infeas_label.append(config)
            #infeasbile configurations
            
    if pareto:
        # Create full lists of all feasible and infeasible data for pareto plot generation
        all_metric_1 = []
        all_metric_2 = []
    
        for config in CfgDct:
            all_metric_1.append(float(CfgDct[config]['Metrics'][Metric1]))
            all_metric_2.append(float(CfgDct[config]['Metrics'][Metric2]))
        
        # Generate ordered list of points to build pareto frontier
        # Steps in listing points:
        #1: Make new lists of distances from ideals to account for max/min preferences
        #2: Zip metric 1/2 data together to form x/y pairs along with dist from ideals
        #3: Eliminate all data away from the ideal of metric 2 from ideal met 1
        #4: Eliminate all data away from the ideal of met 1 from met 2
        #5: Starting with leftmost ideal data location (should be max):
        #6a: Identify next point and calculate line from x/y pairs
        #6b: For each next point: 
        #    if below line, select as new point and recauculate line
        #    if above, discard previous and backcheck to see if above
        #    once below, recauculate line and proceed to next point
        #7: End on last point
        
        #1
        X1 = all_metric_1[:]
        X2 = all_metric_2[:]
        
        if Type1 == 'Min':
            X1 = [max(X1) - x for x in X1]
        
        if Type2 == 'Min':
            X2 = [max(X2) - x for x in X2]
        
        #2    
        ParList = zip(X1,X2,all_metric_1,all_metric_2)
        
        #3
        ParList = sorted(ParList, key=itemgetter(0))
        ind = 0
        for line in ParList:
            if line[1] == max(X2):
                ind2 = ind
            ind = ind + 1
        ParList = ParList[ind2:]
        
        #4
        ParList = sorted(ParList, key = itemgetter(1))
        ind = 0
        for line in ParList:
            if line[0] == max(X1):
                ind2 = ind
            ind = ind + 1
        ParList = ParList[ind2:]
            
        #5    
        #Currently, values are sorted in order of met 2
        #Start from bottom of Met 2 (max Met 1) and move across
        
        ParList2 = ParList[0:2]
        
        rearY = ParList[0][0]
        rearX = ParList[0][1]
        frontY = ParList[1][0]
        frontX = ParList[1][1]
        for line in ParList[2:]:
            intercept = (frontY-rearY)/(frontX-rearX)*(line[1]-rearX) + rearY
            if line[0] < intercept:
                rearY = frontY
                rearX = frontX
                frontY = line[0]
                frontX = line[1]
                ParList2.append(line)
            else: #above or on line:
                ParList2.pop()
                ncomplete = 1
                while ncomplete:
                    if len(ParList2) > 1:
                        frontY = ParList2[-1][0]
                        frontX = ParList2[-1][1]
                        rearY = ParList2[-2][0]
                        rearX = ParList2[-2][1]
                        intercept = (frontY-rearY)/(frontX-rearX)*(line[1]-rearX) + rearY
                        if line[0] < intercept:
                            rearY = frontY
                            rearX = frontX
                            frontY = line[0]
                            frontX = line[1]
                            ParList2.append(line)
                            ncomplete = 0
                        else:
                            ParList2.pop()
                    else:
                        ncomplete = 0
                        frontY = line[0]
                        frontX = line[1]
                        ParList2.append(line)
                
    ParX = [i for x,y,i,j in ParList2]
    ParY = [j for x,y,i,j in ParList2]
    
    # Following section compilies data to build the constraint lines on the scatterplot
    # Determine constraint values for Metric1 and Metric2
    for metric in WtsDct:
        C1 = (WtsDct[Metric1]['Req'])
        C2 = (WtsDct[Metric2]['Req'])
        
    if C1 != 'UNUSED':
        C1 = float(C1)
        
    if C2 != 'UNUSED':
        C2 = float(C2)
        
    # Find max and min values of the metrics
    # This ensures that the lines will fit inside the plot area nicely
    Metric1plot = []
    Metric2plot = []
    
    for config in CfgDct:
        
        Metric1plot.append(float(CfgDct[config]['Metrics'][Metric1]))
        Metric2plot.append(float(CfgDct[config]['Metrics'][Metric2]))
    
    Metric1_min = .99*float(min(Metric1plot))   
    Metric1_max = 1.01*float(max(Metric1plot))
    Metric1_avg = (Metric1_min+Metric1_max)/2
    Metric2_min = .99*float(min(Metric2plot))
    Metric2_max = 1.01*float(max(Metric2plot))
    Metric2_avg = (Metric2_min+Metric2_max)/2
        
    #print Metric1_min
    #print Metric1_max
    #print Metric2_min
    #print Metric2_max
      
    #if Metric2_min > C2:
        #Metric2_min = C2
    #elif Metric2_max < C2:
        #Metric2_max = C2
        
    #if Metric1_min > C1:
        #Metric1_min = C1
    #elif Metric1_max < C1:
        #Metric1_max = C1
        
    # Generate x and y datasets for the constraint lines    
    C1x = [C1, C1]
    C1y = [Metric2_min, Metric2_max]
    
    C2x = [Metric1_min, Metric1_max]
    C2y = [C2, C2]
    
    if Type2 == 'Min':
        C2lim = Metric2_max
    else:
        C2lim = Metric2_min
            
    if Type1 == 'Min':
        C1lim = Metric1_max
    else:
        C1lim = Metric1_min
            
            
    g = veusz.Embedded('Scatterplot1')
    g.EnableToolbar()
    
    feasstring = str.join("\n",feas_label)
    infeasstring = str.join("\n",infeas_label)
    #textstring = ''' '2'\nu'thing2'\n'thing1'\n'thuing3'\n'thing4' '''
    g.ImportString(u'f_label(text)',feasstring)
    g.ImportString(u'i_label(text)',infeasstring)
     
    # Create page to hold graph
    g.Add('page', name='page1', autoadd=False)
    g.To('page1')
    g.Set('width', '24.4cm')
    g.Set('height', '16.3cm')
    
    # Create graph to hold data
    g.Add('graph', name=u'Scatterplot1', autoadd=False)
    g.To(u'Scatterplot1')
    g.Add('axis', name='x', autoadd=False)
    g.To('x')
    g.Set('label', u'%s' %(WtsDct[Metric1]['Name']))
    g.Set('autoExtend', False)
    g.Set('autoExtendZero', False)
    g.Set('lowerPosition', 0.0)
    g.Set('upperPosition', 1.0)
    g.Set('otherPosition', 0.0)
    g.To('..')
    g.Add('axis', name='y', autoadd=False)
    g.To('y')
    g.Set('label', u'%s' %(WtsDct[Metric2]['Name']))
    g.Set('autoExtend', False)
    g.Set('autoExtendZero', False)
    g.Set('direction', 'vertical')
    g.To('..')
    
    # Add constraint lines
    
    # Constraints plotted using xy
    #for C2 in ReqDct:
    if C2 != 'UNUSED':
        g.Add('xy', name=u'Metric 2 Constraint', autoadd=False)
        g.To(u'Metric 2 Constraint')
        g.Set('xData', C2x)
        g.Set('yData', C2y)
        g.Set('marker', u'none')
        g.Set('PlotLine/color', u'red')
        g.Set('PlotLine/width', u'1pt')
        g.Set('PlotLine/style', u'dashed')
        g.Set('key', u'Infeasible: Fails %s' % (WtsDct[Metric2]['Name']))
        g.To('..')
        
        g.Add('polygon', name='polygon2', autoadd=False)
        g.To('polygon2')
        g.Set('yPos', [C2, C2lim, C2lim, C2])
        g.Set('xPos', [Metric1_min, Metric1_min, Metric1_max, Metric1_max])
        g.Set('positioning', u'axes')
        g.Set('Line/color', u'black')
        g.Set('Line/width', u'1pt')
        g.Set('Line/hide', True)
        g.Set('Fill/style', u'backward diagonals')
        g.Set('Fill/transparency', 50)
        g.To('..')
                
    #for C1 in ReqDct:
    if C1 != 'UNUSED':
        g.Add('xy', name=u'Metric 1 Constraint', autoadd=False)
        g.To(u'Metric 1 Constraint')
        g.Set('xData', C1x)
        g.Set('yData', C1y)
        g.Set('marker', u'none')
        g.Set('PlotLine/color', u'red')
        g.Set('PlotLine/width', u'1pt')
        g.Set('PlotLine/style', u'dot1')
        g.Set('key', u'Infeasible: Fails %s' %(WtsDct[Metric1]['Name']))
        g.To('..')
        
        g.Add('polygon', name='polygon1', autoadd=False)
        g.To('polygon1')
        g.Set('xPos', [C1, C1lim, C1lim, C1])
        g.Set('yPos', [Metric2_min, Metric2_min, Metric2_max, Metric2_max])
        g.Set('positioning', u'axes')
        g.Set('Line/color', u'black')
        g.Set('Line/width', u'1pt')
        g.Set('Line/hide', True)
        g.Set('Fill/style', u'forward diagonals')
        g.Set('Fill/transparency', 50)
        g.To('..')

    ##Pareto Plot Addition
    #if pareto:
        #g.Add('xy', name=u'Pareto Frontier', autoadd=False)
        #g.To(u'Pareto Frontier')
        #g.Set('xData', ParX)
        #g.Set('yData', ParY)
        #g.Set('marker', u'none')
        #g.Set('PlotLine/color', u'blue')
        #g.Set('PlotLine/width', u'1pt')
        #g.Set('PlotLine/style', u'dashed')
        #g.Set('key', u'Pareto Frontier')
        #g.To('..')
    textlist = ['''thing1''','thing2','thing3']
    textstring = str.join("\n",textlist)    
    #textstring = ''' '2'\nu'thing2'\n'thing1'\n'thuing3'\n'thing4' '''
    g.ImportString(u'label_copy(text)',textstring)
  
    g.Add('xy', name=u'infeasible', autoadd=False)
    g.To(u'infeasible')
    g.Set('xData', metric_1_infeas)
    g.Set('yData', metric_2_infeas)
    g.Set('marker', u'diamond')
    g.Set('markerSize', u'2pt')
    g.Set('scalePoints', [])
    g.Set('PlotLine/color', u'red')
    g.Set('PlotLine/width', u'0pt')
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'red')
    g.Set('MarkerFill/color', u'red')
    g.Set('key', u'Infeasible Points')
    g.Set('labels', u'label_copy')
    g.Set('labels',u'i_label')
    g.To('..')
    g.Add('xy', name=u'feasible', autoadd=False)
    g.To(u'feasible')
    g.Set('xData', metric_1_feas)
    g.Set('yData', metric_2_feas)
    g.Set('markerSize', u'2pt')
    g.Set('thinfactor', 1)
    g.Set('key', u'')
    g.Set('labels', u'')
    g.Set('scalePoints', [])
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'green')
    g.Set('MarkerLine/transparency', 100)
    g.Set('MarkerFill/color', u'green')
    g.Set('key', u'Feasible Points')
    g.Set('labels',u'f_label')
    g.To('..')
    
    #g.Add('polygon', name='polygon1', autoadd=False)
    #g.To('polygon1')
    #g.Set('xData', [C1, C1lim, C1lim, C1])
    ##g.Set('xPos', [0,0,1,1])
    #g.Set('yData', [Metric2_min, Metric2_min, Metric2_max, Metric2_max])
    ##g.Set('yPos', [0,1,1,0])
    #g.Set('Line/color', u'black')
    #g.Set('Line/width', u'1pt')
    ##g.Set('Line/hide', True)
    #g.Set('Fill/style', u'forward diagonals')
    #g.Set('Fill/transparency', 0)
    ##g.To('..')

    # zoom out
    g.Zoom(0.8)
    
    g.Export('plot5.png', color=True, page=0)
    
    g.Close()
    return()
    
if __name__ == '__main__':
    import scatterplot1 as sct1
    import Dashboard_1 as dash
    CfgDct = dash.input("sampleconfigs.xml")
    (WtsDct,SctList,ParList) = dash.read_weights("USER_INPUT_2.xml")                
    (CfgList,CfgDct) = dash.TOPSIS_ranking(CfgDct,WtsDct)
    dash.MeetsReqs(CfgDct,WtsDct)
    sct1.skattaplot1(CfgList,WtsDct,CfgDct,SctList)