#This code generates scatterplot2

def skattaplot2(CfgList,WtsDct,CfgDct,SctList):
    Metric1 = SctList[1][0]
    Metric2 = SctList[1][1]
    
    Type1 = WtsDct[Metric1]['Type']
    Type2 = WtsDct[Metric2]['Type']
    
    pareto = 0
    if ((Type1 == 'Min')|(Type1 == 'Max')) & ((Type2 == 'Min')|(Type2 == 'Max')):
        pareto = 1
    
    import Veusz.embed as veusz
    from operator import itemgetter
    
    # Define lists for top ten configurations metric values
    metric_1_rank1=[]
    metric_2_rank1=[]
    metric_1_rank2=[]
    metric_2_rank2=[]
    metric_1_rank3=[]
    metric_2_rank3=[]
    metric_1_rank4=[]
    metric_2_rank4=[]
    metric_1_rank5=[]
    metric_2_rank5=[]
    metric_1_rank6=[]
    metric_2_rank6=[]
    metric_1_rank7=[]
    metric_2_rank7=[]
    metric_1_rank8=[]
    metric_2_rank8=[]
    metric_1_rank9=[]
    metric_2_rank9=[]
    metric_1_rank10=[]
    metric_2_rank10=[]
    
    # Define lists for infeasible configurations metric values
    metric_1_infeas=[]
    metric_2_infeas=[]
    
    # Define lists for feasible (not top ten) configurations metric values
    metric_1_feas=[]
    metric_2_feas=[]
    
    # Populate lists with coordinates for scatterplots
    CfgList = CfgList[0:10]
    CfgList = [i for i,j in CfgList]
    for config in CfgDct:
        if config in CfgList and CfgDct[config]['Feasible']:
            k = CfgList.index(config)+1
            exec("metric_1_rank%i.append(CfgDct[config]['Metrics'][Metric1])" %(k))
            exec("metric_2_rank%i.append(CfgDct[config]['Metrics'][Metric2])" %(k))
        elif CfgDct[config]['Feasible']:
            metric_1_feas.append(CfgDct[config]['Metrics'][Metric1])
            metric_2_feas.append(CfgDct[config]['Metrics'][Metric2])
            # other feasible configurations
        else:
            metric_1_infeas.append(CfgDct[config]['Metrics'][Metric1])
            metric_2_infeas.append(CfgDct[config]['Metrics'][Metric2])
            #infeasbile configurations      
        
    if pareto:
        # Create full lists of all feasible and infeasible data for pareto plot generation
        all_metric_1 = []
        all_metric_2 = []
    
        for config in CfgDct:
            all_metric_1.append(float(CfgDct[config]['Metrics'][Metric1]))
            all_metric_2.append(float(CfgDct[config]['Metrics'][Metric2]))
        
        # Generate ordered list of points to build pareto frontier
        # Steps in listing points:
        #1: Make new lists of distances from ideals to account for max/min preferences
        #2: Zip metric 1/2 data together to form x/y pairs along with dist from ideals
        #3: Eliminate all data away from the ideal of metric 2 from ideal met 1
        #4: Eliminate all data away from the ideal of met 1 from met 2
        #5: Starting with leftmost ideal data location (should be max):
        #6a: Identify next point and calculate line from x/y pairs
        #6b: For each next point: 
        #    if below line, select as new point and recauculate line
        #    if above, discard previous and backcheck to see if above
        #    once below, recauculate line and proceed to next point
        #7: End on last point
        
        #1
        X1 = all_metric_1[:]
        X2 = all_metric_2[:]
        
        if Type1 == 'Min':
            X1 = [x - max(X1) for x in X1]
        
        if Type2 == 'Min':
            X2 = [max(X2) - x for x in X2]
        
        #2    
        ParList = zip(X1,X2,all_metric_1,all_metric_2)
        
        #3
        ParList = sorted(ParList, key=itemgetter(0))
        ind = 0
        for line in ParList:
            if line[1] == max(X2):
                ind2 = ind
            ind = ind + 1
        ParList = ParList[ind2:]
        
        #4
        ParList = sorted(ParList, key = itemgetter(1))
        ind = 0
        for line in ParList:
            if line[0] == max(X1):
                ind2 = ind
            ind = ind + 1
        ParList = ParList[ind2:]
            
        #5    
        #Currently, values are sorted in order of met 2
        #Start from bottom of Met 2 (max Met 1) and move across
        
        ParList2 = ParList[0:2]
        
        rearY = ParList[0][0]
        rearX = ParList[0][1]
        frontY = ParList[1][0]
        frontX = ParList[1][1]
        for line in ParList[2:]:
            intercept = (frontY-rearY)/(frontX-rearX)*(line[1]-rearX) + rearY
            if line[0] < intercept:
                rearY = frontY
                rearX = frontX
                frontY = line[0]
                frontX = line[1]
                ParList2.append(line)
            else: #above or on line:
                ParList2.pop()
                ncomplete = 1
                while ncomplete:
                    if len(ParList2) > 1:
                        frontY = ParList2[-1][0]
                        frontX = ParList2[-1][1]
                        rearY = ParList2[-2][0]
                        rearX = ParList2[-2][1]
                        intercept = (frontY-rearY)/(frontX-rearX)*(line[1]-rearX) + rearY
                        if line[0] < intercept:
                            rearY = frontY
                            rearX = frontX
                            frontY = line[0]
                            frontX = line[1]
                            ParList2.append(line)
                            ncomplete = 0
                        else:
                            ParList2.pop()
                    else:
                        ncomplete = 0
                        frontY = line[0]
                        frontX = line[1]
                        ParList2.append(line)
                
        ParX = [i for x,y,i,j in ParList2]
        ParY = [j for x,y,i,j in ParList2]
    
    # Following section compilies data to build the constraint lines on the scatterplot
    # Determine constraint values for Metric1 and Metric2
    for metric in WtsDct:
        C1 = WtsDct[Metric1]['Req']
        C2 = WtsDct[Metric2]['Req']
        
    # Find max and min values of the metrics
    # This ensures that the lines will fit inside the plot area nicely
    Metric1plot = []
    Metric2plot = []
    
    for config in CfgDct:
        
        Metric1plot.append(float(CfgDct[config]['Metrics'][Metric1]))
        Metric2plot.append(float(CfgDct[config]['Metrics'][Metric2]))
    
    Metric1_min = .99*float(min(Metric1plot))   
    Metric1_max = 1.01*float(max(Metric1plot))
    Metric1_avg = (Metric1_min+Metric1_max)/2
    Metric2_min = .99*float(min(Metric2plot))
    Metric2_max = 1.01*float(max(Metric2plot))
    Metric2_avg = (Metric2_min+Metric2_max)/2
        
    #print Metric1_min
    #print Metric1_max
    #print Metric2_min
    #print Metric2_max
    
    #if Metric2_min > C2:
        #Metric2_min = C2
    #elif Metric2_max < C2:
        #Metric2_max = C2
        
    #if Metric1_min > C1:
        #Metric1_min = C1
    #elif Metric1_max < C1:
        #Metric1_max = C1
 
    # Generate x and y datasets for the constraint lines    
    C1x = [C1, C1]
    C1y = [Metric2_min, Metric2_max]
    
    C2x = [Metric1_min, Metric1_max]
    C2y = [C2, C2]
      
    g = veusz.Embedded('Scatterplot2')
    g.EnableToolbar()
     
    # Create page to hold graph
    g.Add('page', name='page1', autoadd=False)
    g.To('page1')
    g.Set('width', '24.4cm')
    g.Set('height', '16.3cm')
    
    # Create graph to hold data
    g.Add('graph', name=u'Scatterplot2', autoadd=False)
    g.To(u'Scatterplot2')
    g.Add('axis', name='x', autoadd=False)
    g.To('x')
    g.Set('label', u'%s' %(WtsDct[Metric1]['Name']))
    g.Set('autoExtend', False)
    g.Set('autoExtendZero', False)
    g.Set('lowerPosition', 0.0)
    g.Set('upperPosition', 1.0)
    g.Set('otherPosition', 0.0)
    g.To('..')
    g.Add('axis', name='y', autoadd=False)
    g.To('y')
    g.Set('label', u'%s' %(WtsDct[Metric2]['Name']))
    g.Set('autoExtend', False)
    g.Set('autoExtendZero', False)
    g.Set('direction', 'vertical')
    g.To('..')
    
    # Add constraint lines
    
    # Constraints plotted using xy
    #ReqDct = {'C1':C1,'C2':C2}

    #for C2 in ReqDct:
    if C2 != 'UNUSED':
        g.Add('xy', name=u'Metric 2 Constraint', autoadd=False)
        g.To(u'Metric 2 Constraint')
        g.Set('xData', C2x)
        g.Set('yData', C2y)
        g.Set('marker', u'none')
        g.Set('PlotLine/color', u'red')
        g.Set('PlotLine/width', u'1pt')
        g.Set('PlotLine/style', u'dashed')
        g.To('..')
        #else:
            #g.Add('xy', name=u'Metric 2 Constraint', autoadd=False)
            #g.To(u'Metric 2 Constraint')
            #g.Set('xData', C2x)
            #g.Set('yData', [Metric2_avg,Metric2_avg])
            #g.Set('marker', u'none')
            #g.Set('PlotLine/color', u'red')
            #g.Set('PlotLine/width', u'1pt')
            #g.Set('PlotLine/style', u'dashed')
            #g.Set('PlotLine/transparency', 100)
            #g.To('..')
                
    #for C1 in ReqDct:
    if C1 != 'UNUSED':
        g.Add('xy', name=u'Metric 1 Constraint', autoadd=False)
        g.To(u'Metric 1 Constraint')
        g.Set('xData', C1x)
        g.Set('yData', C1y)
        g.Set('marker', u'none')
        g.Set('PlotLine/color', u'red')
        g.Set('PlotLine/width', u'1pt')
        g.Set('PlotLine/style', u'dashed')
        g.To('..')
        #else:
            #g.Add('xy', name=u'Metric 2 Constraint', autoadd=False)
            #g.To(u'Metric 2 Constraint')
            #g.Set('xData', [Metric1_avg,Metric1_avg])
            #g.Set('yData', C1y)
            #g.Set('marker', u'none')
            #g.Set('PlotLine/color', u'red')
            #g.Set('PlotLine/width', u'1pt')
            #g.Set('PlotLine/style', u'dashed')
            #g.Set('PlotLine/transparency', 100)
            #g.To('..')

    #Pareto Plot Addition
    if pareto:
        g.Add('xy', name=u'Pareto Frontier', autoadd=False)
        g.To(u'Pareto Frontier')
        g.Set('xData', ParX)
        g.Set('yData', ParY)
        g.Set('marker', u'none')
        g.Set('PlotLine/color', u'blue')
        g.Set('PlotLine/width', u'1pt')
        g.Set('PlotLine/style', u'dashed')
        g.To('..')
  
    g.Add('xy', name=u'infeasible', autoadd=False)
    g.To(u'infeasible')
    g.Set('xData', metric_1_infeas)
    g.Set('yData', metric_2_infeas)
    g.Set('marker', u'diamond')
    g.Set('markerSize', u'2pt')
    g.Set('scalePoints', [])
    g.Set('PlotLine/color', u'red')
    g.Set('PlotLine/width', u'0pt')
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'red')
    g.Set('MarkerFill/color', u'red')
    g.To('..')
    g.Add('xy', name=u'feasible', autoadd=False)
    g.To(u'feasible')
    g.Set('xData', metric_1_feas)
    g.Set('yData', metric_2_feas)
    g.Set('markerSize', u'2pt')
    g.Set('thinfactor', 1)
    g.Set('key', u'')
    g.Set('labels', u'')
    g.Set('scalePoints', [])
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'green')
    g.Set('MarkerLine/transparency', 100)
    g.Set('MarkerFill/color', u'green')
    g.To('..')
    
    g.Add('xy', name=u'1', autoadd=False)
    g.To(u'1')
    g.Set('xData', metric_1_rank1)
    g.Set('yData', metric_2_rank1)
    g.Set('markerSize', u'2pt')
    g.Set('thinfactor', 1)
    g.Set('key', u'')
    #g.Set('labels', CfgDct.keys()[0])
    g.Set('scalePoints', [])
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'black')
    g.Set('MarkerFill/color', u'green')
    g.To('..')
    
    g.Add('xy', name=u'2', autoadd=False)
    g.To(u'2')
    g.Set('xData', metric_1_rank2)
    g.Set('yData', metric_2_rank2)
    g.Set('markerSize', u'2pt')
    g.Set('thinfactor', 1)
    g.Set('key', u'')
    #g.Set('labels', CfgDct.keys()[1])
    g.Set('scalePoints', [])
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'black')
    g.Set('MarkerFill/color', u'green')
    g.To('..')
    
    g.Add('xy', name=u'3', autoadd=False)
    g.To(u'3')
    g.Set('xData', metric_1_rank3)
    g.Set('yData', metric_2_rank3)
    g.Set('markerSize', u'2pt')
    g.Set('thinfactor', 1)
    g.Set('key', u'')
    #g.Set('labels', CfgDct.keys()[2])
    g.Set('scalePoints', [])
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'black')
    g.Set('MarkerFill/color', u'green')
    g.To('..')
    
    g.Add('xy', name=u'4', autoadd=False)
    g.To(u'4')
    g.Set('xData', metric_1_rank4)
    g.Set('yData', metric_2_rank4)
    g.Set('markerSize', u'2pt')
    g.Set('thinfactor', 1)
    g.Set('key', u'')
    #g.Set('labels', CfgDct.keys()[3])
    g.Set('scalePoints', [])
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'black')
    g.Set('MarkerFill/color', u'green')
    g.To('..')
    
    g.Add('xy', name=u'5', autoadd=False)
    g.To(u'5')
    g.Set('xData', metric_1_rank5)
    g.Set('yData', metric_2_rank5)
    g.Set('markerSize', u'2pt')
    g.Set('thinfactor', 1)
    g.Set('key', u'')
    #g.Set('labels', CfgDct.keys()[4])
    g.Set('scalePoints', [])
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'black')
    g.Set('MarkerFill/color', u'green')
    g.To('..')
    
    g.Add('xy', name=u'6', autoadd=False)
    g.To(u'6')
    g.Set('xData', metric_1_rank6)
    g.Set('yData', metric_2_rank6)
    g.Set('markerSize', u'2pt')
    g.Set('thinfactor', 1)
    g.Set('key', u'')
    #g.Set('labels', u'6')
    g.Set('scalePoints', [])
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'black')
    g.Set('MarkerFill/color', u'green')
    g.To('..')
    
    g.Add('xy', name=u'7', autoadd=False)
    g.To(u'7')
    g.Set('xData', metric_1_rank7)
    g.Set('yData', metric_2_rank7)
    g.Set('markerSize', u'2pt')
    g.Set('thinfactor', 1)
    g.Set('key', u'')
    #g.Set('labels', u'7')
    g.Set('scalePoints', [])
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'black')
    g.Set('MarkerFill/color', u'green')
    g.To('..')
    
    g.Add('xy', name=u'8', autoadd=False)
    g.To(u'8')
    g.Set('xData', metric_1_rank8)
    g.Set('yData', metric_2_rank8)
    g.Set('markerSize', u'2pt')
    g.Set('thinfactor', 1)
    g.Set('key', u'')
    #g.Set('labels', u'8')
    g.Set('scalePoints', [])
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'black')
    g.Set('MarkerFill/color', u'green')
    g.To('..')
    
    g.Add('xy', name=u'9', autoadd=False)
    g.To(u'9')
    g.Set('xData', metric_1_rank9)
    g.Set('yData', metric_2_rank9)
    g.Set('markerSize', u'2pt')
    g.Set('thinfactor', 1)
    g.Set('key', u'')
    #g.Set('labels', u'9')
    g.Set('scalePoints', [])
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'black')
    g.Set('MarkerFill/color', u'green')
    g.To('..')
    
    g.Add('xy', name=u'10', autoadd=False)
    g.To(u'10')
    g.Set('xData', metric_1_rank10)
    g.Set('yData', metric_2_rank10)
    g.Set('markerSize', u'2pt')
    g.Set('thinfactor', 1)
    g.Set('key', u'')
    #g.Set('labels', u'10')
    g.Set('scalePoints', [])
    g.Set('PlotLine/transparency', 100)
    g.Set('MarkerLine/color', u'black')
    g.Set('MarkerFill/color', u'green')
    
    # zoom out
    g.Zoom(0.8)
    
    g.Export('plot6.png', color=True, page=0)
    
    g.Close()
    return()
    
if __name__ == '__main__':
    import scatterplot2 as sct2
    import Dashboard_1 as dash
    CfgDct = dash.input("sampleconfigs.xml")
    (WtsDct,SctList,ParList) = dash.read_weights("USER_INPUT_2.xml")                
    (CfgList,CfgDct) = dash.TOPSIS_ranking(CfgDct,WtsDct)
    dash.MeetsReqs(CfgDct,WtsDct)
    sct2.skattaplot2(CfgList,WtsDct,CfgDct,SctList)