/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using AVM;
using AVM.META.Design;
using Complexity;

namespace METADesignInterchange2ComplexityLib
{
    public static class METADesign2Complexity
    {
        private static List<AVM.META.Design.ComponentInstance> RecursivelyGetAllComponentInstances(Compound c_root)
        {
            List<AVM.META.Design.ComponentInstance> lci_rtn = new List<AVM.META.Design.ComponentInstance>();

            if (c_root.ComponentInstances != null)
            {
                lci_rtn.InsertRange(0, c_root.ComponentInstances);
            }
            
            if (c_root.Containers != null)
            {
                foreach (Compound c in c_root.Containers.Where(c => c is Compound))
                {
                    lci_rtn.InsertRange(0, RecursivelyGetAllComponentInstances(c));
                }
            }
            
            return lci_rtn;
        }
        private static List<AVM.META.Design.ComponentInstance> RecursivelyGetAllComponentInstances(DesignModel dm_root)
        {
            List<AVM.META.Design.ComponentInstance> lci_rtn = new List<AVM.META.Design.ComponentInstance>();
            foreach (Compound c in dm_root.Containers.Where(c => c is Compound))
            {
                lci_rtn.InsertRange(0, RecursivelyGetAllComponentInstances(c));
            }
            return lci_rtn;
        }

        public static Complexity.Design Design2Complexity(DesignModel dm_input)
        {
            Complexity.Design d_main = new Complexity.Design();
            d_main.ComponentInstances = new List<Complexity.ComponentInstance>();
            d_main.Connections = new List<Complexity.Connection>();

            d_main.AVMID = dm_input.DesignID;
            d_main.Name = dm_input.Name;

            Dictionary<PortInstance, Complexity.ComponentInstance> d_piToCIMap = new Dictionary<PortInstance, Complexity.ComponentInstance>();
            foreach (AVM.META.Design.ComponentInstance ci in RecursivelyGetAllComponentInstances(dm_input))
            {
                Complexity.ComponentInstance cci_new = new Complexity.ComponentInstance();
                cci_new.AVMID = ci.ComponentID;
                cci_new.Name = ci.Name;
                cci_new.Complexity = 1;
                cci_new.DistributionType = Complexity.DistributionTypeEnum.None;

                d_main.ComponentInstances.AddItem(cci_new);

                foreach (PortInstance pi in ci.PortInstances.Where(pi => pi is PortInstance))
                {
                    d_piToCIMap.Add(pi, cci_new);
                }
            }

            foreach (PortConnector pc in dm_input.Connectors.Where(pc => pc is PortConnector))
            {
                foreach (PortInstance pi_1 in pc.EndPoints)
                {
                    foreach (PortInstance pi_2 in pc.EndPoints.Where(pi2 => pi2 != pi_1))
                    {
                        Complexity.Connection cc_new = new Complexity.Connection();
                        d_main.Connections.AddItem(cc_new);
                        cc_new.src = d_piToCIMap[pi_1];
                        cc_new.dst = d_piToCIMap[pi_2];
                        cc_new.Complexity = 0.1;
                        cc_new.DistributionType = Complexity.DistributionTypeEnum.None;
                    }
                }
            }
            
            return d_main;
        }
    }
}
