/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#pragma once

#include "Resource.h"
#include "afxwin.h"
#include "afxcmn.h"

#include "DesertHelper.h"
// CConstraintAddDialog dialog

class CConstraintAddDialog : public CDialog
{
	DECLARE_DYNAMIC(CConstraintAddDialog)

public:
	CConstraintAddDialog(CWnd* pParent = NULL);   // standard constructor
	CConstraintAddDialog(DesertHelper *deserthelper_ptr, CWnd* pParent = NULL);
	virtual ~CConstraintAddDialog();

// Dialog Data
	enum { IDD = IDD_ADD_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
public:
	CString m_name;
	CString m_expression;
	CListBox m_funclist;
	int m_cyphyObjId;
	afx_msg void OnBnClickedInsertbtn();
	afx_msg void OnLbnDblclkFunctionlist();
	virtual BOOL OnInitDialog();
	afx_msg void OnEnChangeExpressionedit();
private:
	CEdit c_expredit;
	CEdit c_nameedit;
	CTreeCtrl m_spacetree;
	DesertHelper *dhelper_ptr;
	bool m_editExpression;
	map<HTREEITEM, int> spaceTreeMap;

	void InsertFuncString();
	void FillDesignSpaceTree();
	void FillDesignSpaceTree(DesertIface::Element &elem, HTREEITEM parent);
public:
	afx_msg void OnEnSetfocusExpressionedit();
	afx_msg void OnEnSetfocusNameedit();
	afx_msg void OnTvnSelchangedSpacetree(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedOk();
};