/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
// ConstraintMainDialog.cpp : implementation file
//

#include "stdafx.h"
#include "ConstraintMainDialog.h"
#include "ConstraintEditDialog.h"
#include "ConstraintAddDialog.h"
#include "DesertConfigDialog.h"
#include "Uml.h"
#include "UmlExt.h"
#include "CyPhyML.h"

#include "DSESelectorDialog.h"

#include "desertdll.h"

#define WTIMES	1.6
// CConstraintMainDialog dialog

IMPLEMENT_DYNAMIC(CConstraintMainDialog, CDialog)

CConstraintMainDialog::CConstraintMainDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CConstraintMainDialog::IDD, pParent), m_gmeWindow(NULL)
{
	m_pToolTip = NULL;
	refresh_needed = true;
	applyAll = false;
	currConListPosition = 0;
}

CConstraintMainDialog::CConstraintMainDialog(DesertHelper *deserthelper_ptr, CWnd* pParent /*=NULL*/)
	: CDialog(CConstraintMainDialog::IDD, pParent), dhelper_ptr(deserthelper_ptr)
{
	m_pToolTip = NULL;
	refresh_needed = true;
	applyAll = false;
	currConListPosition = 0;
}

CConstraintMainDialog::~CConstraintMainDialog()
{
	if(m_pToolTip)
		delete m_pToolTip;
}

void CConstraintMainDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CONSTRAINTLIST, m_listctrl);
	DDX_Control(pDX, IDC_EDITBTN, m_btEdit);
	DDX_Control(pDX, IDC_VALIDATEBTN, m_btValidate);
	DDX_Control(pDX, IDC_COMMITBTN, m_btCommit);
	DDX_Control(pDX, IDC_RESTARTBTN, m_btRestart);
	DDX_Control(pDX, IDC_APPLYBTN, m_btApply);
	DDX_Control(pDX, IDC_APPLYALLBTN, m_btApplyAll);
	DDX_Control(pDX, IDC_BACKBTN, m_btBack);
	DDX_Control(pDX, IDC_FORWARDBTN, m_btForward);
	DDX_Control(pDX, IDC_GENCFGBTN, m_btGenCfgs);
	DDX_Control(pDX, IDC_SELECTBTN, m_btSelect);
}

BEGIN_MESSAGE_MAP(CConstraintMainDialog, CDialog)
//	ON_BN_CLICKED(IDC_ADDBTN, &CConstraintMainDialog::OnBnClickedAddbtn)
	ON_WM_DESTROY()
	ON_NOTIFY( LVN_GETINFOTIP, IDC_CONSTRAINTLIST, OnInfoTip )
	ON_BN_CLICKED(IDC_EDITBTN, &CConstraintMainDialog::OnBnClickedEditbtn)
	ON_BN_CLICKED(IDC_COMMITBTN, &CConstraintMainDialog::OnBnClickedCommitbtn)
	ON_BN_CLICKED(IDC_APPLYBTN, &CConstraintMainDialog::OnBnClickedApplybtn)
	ON_BN_CLICKED(IDC_APPLYALLBTN, &CConstraintMainDialog::OnBnClickedApplyallbtn)
	ON_BN_CLICKED(IDC_VALIDATEBTN, &CConstraintMainDialog::OnBnClickedValidatebtn)
//	ON_BN_CLICKED(IDC_REMOVEBTN, &CConstraintMainDialog::OnBnClickedRemovebtn)
	ON_BN_CLICKED(IDC_BACKBTN, &CConstraintMainDialog::OnBnClickedBackbtn)
	ON_BN_CLICKED(IDC_FORWARDBTN, &CConstraintMainDialog::OnBnClickedForwardbtn)
	ON_BN_CLICKED(IDC_GENCFGBTN, &CConstraintMainDialog::OnBnClickedGencfgbtn)
	ON_BN_CLICKED(IDOK, &CConstraintMainDialog::OnBnClickedOk)
	ON_NOTIFY(NM_CUSTOMDRAW, IDC_CONSTRAINTLIST, &CConstraintMainDialog::OnNMCustomdrawConstraintlist)
	ON_BN_CLICKED(IDC_SELECTBTN, &CConstraintMainDialog::OnBnClickedSelectbtn)
	ON_BN_CLICKED(IDC_RESTARTBTN, &CConstraintMainDialog::OnBnClickedRestartbtn)
END_MESSAGE_MAP()


// CConstraintMainDialog message handlers
map<int, std::string> CConstraintMainDialog::constraintExprMap;
BOOL CConstraintMainDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	m_listctrl.InsertColumn(0, _T (""), LVCFMT_LEFT, (int)(WTIMES*m_listctrl.GetStringWidth("")),0);
	m_listctrl.InsertColumn(1,_T ("Constraint"), LVCFMT_LEFT, (int)(WTIMES*m_listctrl.GetStringWidth("Constraint")),1);
	m_listctrl.InsertColumn(2, _T("Context"), LVCFMT_LEFT, (int)(WTIMES*m_listctrl.GetStringWidth("Context")),2);
	m_listctrl.InsertColumn(3, _T("Type"), LVCFMT_LEFT, (int)(WTIMES*m_listctrl.GetStringWidth("Type")),3);
	ListView_SetExtendedListViewStyle(m_listctrl.m_hWnd,LVS_EX_CHECKBOXES | LVS_EX_FULLROWSELECT | LVS_EX_INFOTIP);
	m_listctrl.SetColumnNum(4);
	m_listctrl.initHeadListCtr();
//	FillList();
	
//	m_blInited = false;
//	initHeadListCtr();
	//Set up the tooltip
	m_pToolTip = new CToolTipCtrl;
	if(!m_pToolTip->Create(this))
	{
	   TRACE("Unable To create ToolTip\n");
	   return TRUE;
	}

	if (!m_pToolTip->AddTool(&m_btEdit,"Select a constraint and edit"))
	{
	   TRACE("Unable to add Edit button to the tooltip\n");
	}

	if (!m_pToolTip->AddTool(&m_btValidate,"Validate all constraints"))
	{
	   TRACE("Unable to add Validate button to the tooltip\n");
	}

	if (!m_pToolTip->AddTool(&m_btCommit,"Save all changes of the constraints"))
	{
	   TRACE("Unable to add Save button to the tooltip\n");
	}

	if (!m_pToolTip->AddTool(&m_btRestart,"Start the designSpace exploration without constraint applied"))
	{
	   TRACE("Unable to add Restart button to the tooltip\n");
	}

	if (!m_pToolTip->AddTool(&m_btApply,"Apply selected constraints or none to Desert"))
	{
	   TRACE("Unable to add Apply button to the tooltip\n");
	}

	if (!m_pToolTip->AddTool(&m_btApplyAll,"Apply all constraints to Desert"))
	{
	   TRACE("Unable to add ApplyAll button to the tooltip\n");
	}

	if (!m_pToolTip->AddTool(&m_btSelect,"View and prune/down-select design space"))
	{
	   TRACE("Unable to add View/Select button to the tooltip\n");
	}

	if (!m_pToolTip->AddTool(&m_btBack,"Go back configurations"))
	{
	   TRACE("Unable to add Go Back Configurations button to the tooltip\n");
	}

	if (!m_pToolTip->AddTool(&m_btForward,"Go forward configurations"))
	{
	   TRACE("Unable to add Go forward configurations button to the tooltip\n");
	}
	
	if (!m_pToolTip->AddTool(&m_btGenCfgs,"Show the configurations"))
	{
	   TRACE("Unable to add Show the configurations button to the tooltip\n");
	}

	m_pToolTip->Activate(TRUE);
	conIdlist.clear();
	dhelper_ptr->applyConstraints(conIdlist, refresh_needed);
	
	applyAll = false;
	refresh_needed = false;

	FillList();
	FillSizeBox();

	GetDlgItem(IDC_BACKBTN)->EnableWindow(FALSE);
	GetDlgItem(IDC_FORWARDBTN)->EnableWindow(FALSE);

	m_gmeWindow = ::GetActiveWindow();
	if (m_gmeWindow != NULL) // gmeWindow could be NULL if this component is invoked outside of GME
	{
		::EnableWindow(m_gmeWindow, FALSE); // call this after you ShowWindow your window

#ifdef _DEBUG
		CString gmeWindowText;
		::GetWindowText(m_gmeWindow, gmeWindowText.GetBuffer(500), 500);
		gmeWindowText.ReleaseBuffer();
		OutputDebugString(gmeWindowText.GetBuffer()); // prints the title of the GME window, e.g. MetaGME - UML
#endif
	}

	//initialize resize anchor
	BOOL bOk = FALSE;
	bOk = m_resizer.Hook(this);
	ASSERT( bOk);

	bOk = m_resizer.SetAnchor(IDC_CONSTRAINTLIST, ANCHOR_ALL | ANCHOR_TOP | ANCHOR_LEFT);
	ASSERT( bOk);

	bOk = m_resizer.SetAnchor(IDC_STATIC1, ANCHOR_RIGHT);
	ASSERT( bOk);
	bOk = m_resizer.SetAnchor(IDC_STATIC2, ANCHOR_RIGHT);
	ASSERT( bOk);
	bOk = m_resizer.SetAnchor(IDC_STATIC3, ANCHOR_RIGHT);
	ASSERT( bOk);
	bOk = m_resizer.SetAnchor(IDC_STATIC4, ANCHOR_RIGHT);
	ASSERT( bOk);

	bOk = m_resizer.SetAnchor(IDC_EDITBTN, ANCHOR_RIGHT);
	ASSERT( bOk);
	bOk = m_resizer.SetAnchor(IDC_VALIDATEBTN, ANCHOR_RIGHT);
	ASSERT( bOk);
	bOk = m_resizer.SetAnchor(IDC_COMMITBTN, ANCHOR_RIGHT);
	ASSERT( bOk);
	bOk = m_resizer.SetAnchor(IDC_RESTARTBTN, ANCHOR_RIGHT);
	ASSERT( bOk);
	bOk = m_resizer.SetAnchor(IDC_APPLYBTN, ANCHOR_RIGHT);
	ASSERT( bOk);
	bOk = m_resizer.SetAnchor(IDC_APPLYALLBTN, ANCHOR_RIGHT);
	ASSERT( bOk);
	bOk = m_resizer.SetAnchor(IDC_BACKBTN, ANCHOR_RIGHT);
	ASSERT( bOk);
	bOk = m_resizer.SetAnchor(IDC_FORWARDBTN, ANCHOR_RIGHT);
	ASSERT( bOk);
	bOk = m_resizer.SetAnchor(IDC_SELECTBTN, ANCHOR_RIGHT);
	ASSERT( bOk);
	bOk = m_resizer.SetAnchor(IDC_GENCFGBTN, ANCHOR_RIGHT);
	ASSERT( bOk);
	bOk = m_resizer.SetAnchor(IDOK, ANCHOR_RIGHT);
	ASSERT( bOk);
	bOk = m_resizer.SetAnchor(IDC_DSSIZEEDIT, ANCHOR_HORIZONTALLY | ANCHOR_BOTTOM );
	ASSERT( bOk);
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CConstraintMainDialog::OnDestroy()
{
	if (m_gmeWindow != NULL)
	{
		::EnableWindow(m_gmeWindow, TRUE);
	}
}

void CConstraintMainDialog::FillList()
{
	set<std::string> conset;
	if(!refresh_needed)
		dhelper_ptr->getAppliedConstraintSet(conset);
	
	m_listctrl.DeleteAllItems();
	constraintExprMap.clear();
	appliedConSet.clear();
	
	int conSize = dhelper_ptr->getConstraintSize();
	for(int i=0; i<conSize; ++i)
	{
		std::string name, context, expression, ctype;
		if(dhelper_ptr->getConstraint(i, name, context, expression, ctype))
		{
			constraintExprMap[i] = expression;
			//bool constraint_applied = conset.find(name)!=conset.end();
			if(conset.find(name)!=conset.end()) 
				appliedConSet.insert(i);
			if(invalidConstraintName_set.find(CString(name.c_str()))!=invalidConstraintName_set.end())
				invalidConSet.insert(i);

			FillList(i, name, context,ctype);			
		}
		else
		{
			//considering update. This case should not happen!
		}
	}
	m_listctrl.Sort();
}

void CConstraintMainDialog::FillList(int index,const std::string &cons_name, const std::string &cons_context, const std::string &cons_type)
{
	int ret, req, is;
	LV_ITEM item;
	item.state = item.stateMask = 0;	
//	if(constraint_applied)
	{
		item.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;
		item.iImage = LVS_EX_CHECKBOXES;
	}
	//else
	//	item.mask = LVIF_TEXT | LVIF_PARAM;
	item.lParam = 0;
	item.iItem = index;
	
	//item.iSubItem = 0;
	//// first column is the name of the constraint
	//item.pszText = (LPSTR)cons_name.c_str();
	//ret = m_listctrl.InsertItem(&item);
	(void)m_listctrl.AddItem(index, "",(LPSTR)cons_name.c_str(), (LPSTR)cons_context.c_str(), (LPSTR)cons_type.c_str());
	
	m_listctrl.SetColumnWidth(0,35);

	// fix column width
	req = (int)(WTIMES*m_listctrl.GetStringWidth((LPSTR)cons_name.c_str()));
	is = m_listctrl.GetColumnWidth(1);
	if ( is < req ) m_listctrl.SetColumnWidth(1, req);

	//item.iItem = ret;
	//item.mask = LVIF_TEXT;
	//item.iImage = 0;
	//item.lParam = 0;

	// second column 
	//item.iSubItem = 1;
	//item.pszText = (LPSTR)cons_context.c_str();
	//ret = m_listctrl.SetItem(&item);
	//
	// fix column width
	req = (int)(WTIMES*m_listctrl.GetStringWidth((LPSTR)cons_context.c_str()));
	is = m_listctrl.GetColumnWidth(2);
	if ( is < req ) m_listctrl.SetColumnWidth(2, req);

	// third column
	//item.iSubItem = 2;
	//item.pszText = (LPSTR)cons_type.c_str();
	//ret = m_listctrl.SetItem(&item);

	// fix column width
	req = (int)(WTIMES*m_listctrl.GetStringWidth((LPSTR)cons_type.c_str()));
	is = m_listctrl.GetColumnWidth(3);
	if ( is < req ) m_listctrl.SetColumnWidth(3, req);
}

void CConstraintMainDialog::OnInfoTip(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVGETINFOTIP*pInfoTip = reinterpret_cast<NMLVGETINFOTIP*>(pNMHDR);
	ASSERT(pInfoTip);
	
	int i = m_listctrl.GetItemID(pInfoTip->iItem);
	map<int, std::string>::iterator pos = constraintExprMap.find(i);
	if(pos!=constraintExprMap.end())
		pInfoTip->pszText = (LPSTR)(constraintExprMap[i].c_str());
}

void CConstraintMainDialog::OnBnClickedEditbtn()
{
	// TODO: Add your control notification handler code here
	int n = m_listctrl.GetItemCount();
	int sel = -1;
	UINT uSelectedCount = m_listctrl.GetSelectedCount();
	if (uSelectedCount > 0) 
		sel = m_listctrl.GetNextItem(sel, LVNI_SELECTED);
	else
		for(int i=0; i<n&&sel==-1; ++i)
		{
			if(m_listctrl.GetCheck(i)) sel = i;
		}

	if(sel==-1) return;

	int con_index = m_listctrl.GetItemID(sel);
	CConstraintEditDialog editdlg(m_listctrl.GetItemText(sel,1), (CString)(constraintExprMap[con_index].c_str()),dhelper_ptr);
	if(editdlg.DoModal()==IDOK)
	{
		//update the constraint name and expression
		m_listctrl.SetItemText(sel,1,editdlg.m_name);
		constraintExprMap[con_index] = (LPCTSTR)editdlg.m_expression;

		//update the desertIface file
		dhelper_ptr->updateConstraint(con_index, (LPCTSTR)editdlg.m_name, (LPCTSTR)editdlg.m_expression);
//		m_listctrl.SetCheck(sel);
	}
	//refresh_needed = true;
	initConstraints();
}

void CConstraintMainDialog::OnBnClickedCommitbtn()
{
	// TODO: Add your control notification handler code here
	dhelper_ptr->updateCyPhy();
}

void CConstraintMainDialog::OnBnClickedApplybtn()
{
	// TODO: Add your control notification handler code here
	if(refresh_needed)
		dhelper_ptr->closeDesertIfaceBackDN();
	std::string conslist="";
	int cnt = m_listctrl.GetItemCount();
	//set<int> conIdlist;
	conIdlist.clear();
	for(int i=0; i<cnt; ++i)
	{
		if(!m_listctrl.GetCheck(i)) continue;
		conIdlist.insert(m_listctrl.GetItemID(i));
	}

	try{
		dhelper_ptr->applyConstraints(conIdlist, refresh_needed);
		appliedCons.push_back(conIdlist);
		currConListPosition++;
		applyAll = false;
		refresh_needed = false;
	}catch(udm_exception &exc)
	{
		AfxMessageBox(CString(exc.what()));
		//initConstraints();
		//if(dhelper_ptr->isBackNavigable())
		//	dhelper_ptr->goBack();
		//else
		//	initConstraints();
		//return;
		//
	}
	catch(CDesertException *e)
	{
		invalidConstraintName_set.insert(e->GetConstraintName());
		e->Delete();
	}
//	FillSizeBox();
	update();
}

void CConstraintMainDialog::OnBnClickedApplyallbtn()
{
	// TODO: Add your control notification handler code here
	conIdlist.clear();
	if(refresh_needed)
	{
		dhelper_ptr->closeDesertIfaceBackDN();
		dhelper_ptr->applyConstraints(conIdlist, true);
		dspSize = dhelper_ptr->getDesignSpaceSize();
		refresh_needed = false;
	}	//for the purpose to get the correct dspSize
	
	int cnt = m_listctrl.GetItemCount();
	for(int i=0; i<cnt; ++i)
	{
		conIdlist.insert(m_listctrl.GetItemID(i));
	}
//	dhelper_ptr->applyAllConstraints(refresh_needed);
	try{
	dhelper_ptr->applyConstraints(conIdlist, refresh_needed);
	}catch(udm_exception &exc)
	{
//		AfxMessageBox(CString(exc.what()));
	//	initConstraints();
		if(dhelper_ptr->isBackNavigable())
			dhelper_ptr->goBack();
		else
			initConstraints();
		FillList();
		return;
	}
	catch(CDesertException *e)
	{
		invalidConstraintName_set.insert(e->GetConstraintName());
		e->Delete();
		if(dhelper_ptr->isBackNavigable())
			dhelper_ptr->goBack();
		else
			initConstraints();
		FillList();
		return;
	}
	appliedCons.push_back(conIdlist);
	currConListPosition++;
	
	dspSize = dhelper_ptr->getDesignSpaceSize();
	applyAll = true;	
	update();
}

void CConstraintMainDialog::OnBnClickedValidatebtn()
{
	// TODO: Add your control notification handler code here
	if(dhelper_ptr->checkConstraints())
		AfxMessageBox("The constraints are valid.");
	initConstraints();
	FillSizeBox();
}

BOOL CConstraintMainDialog::PreTranslateMessage(MSG* pMsg)
{
	// TODO: Add your specialized code here and/or call the base class
     if (NULL != m_pToolTip)
            m_pToolTip->RelayEvent(pMsg);

	return CDialog::PreTranslateMessage(pMsg);
}

void CConstraintMainDialog::OnBnClickedBackbtn()
{
	// TODO: Add your control notification handler code here
	dhelper_ptr->goBack();
	//FillSizeBox();
	update();
}

void CConstraintMainDialog::OnBnClickedForwardbtn()
{
	// TODO: Add your control notification handler code here
	dhelper_ptr->goForward();
	update();
}

void CConstraintMainDialog::OnBnClickedGencfgbtn()
{
	// TODO: Add your control notification handler code here
	generateConfig();
	update();
}

void CConstraintMainDialog::FillSizeBox()
{
	dspSize = dhelper_ptr->getRealConfigCount();
	// dspSize = dhelper_ptr->getDesignSpaceSize();
	 char buffer[65];
	_i64toa(dspSize, buffer, 10);
	std::string str = "Current no. of configurations: ";
	if(dspSize == -1) {
		str += "Not calculated yet";
	} else if(dspSize == -2) {
		str += "Design Space Too Large";
	} else {
		str += (std::string) buffer;
	}
//	dhelper_ptr->getDesignSpaceSize(dspSize, repSize);
//	CString str; str.Format("Design Space (Encoded): %3.2e        EncodingLength: %6d", dspSize, repSize);
	CEdit *box = (CEdit *)GetDlgItem(IDC_DSSIZEEDIT);
	box->SetWindowText(str.c_str());
}

void CConstraintMainDialog::update()
{
	dhelper_ptr->isBackNavigable() ? GetDlgItem(IDC_BACKBTN)->EnableWindow(true) : GetDlgItem(IDC_BACKBTN)->EnableWindow(FALSE);
	dhelper_ptr->isForwardNavigable() ? GetDlgItem(IDC_FORWARDBTN)->EnableWindow(true) : GetDlgItem(IDC_FORWARDBTN)->EnableWindow(FALSE);
	FillList();
	FillSizeBox();
}

void CConstraintMainDialog::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here
	/*if(!dhelper_ptr->isCfgModelsNull() )
	{
		if(AfxMessageBox("Do you want to save the exported configurations?", MB_ICONQUESTION | MB_YESNO)==IDNO)
		{
			dhelper_ptr->removeCfgs();
		}
	}*/
	CDialog::OnOK();
}

void CConstraintMainDialog::generateConfig()
{
	if(dspSize == -2) 
	{
		if(IDNO==AfxMessageBox("The configurations cannot be shown due to the too large design space.\nPlease apply constraints or use View/Select for further pruning/down-selecting.\n\nDo you want to proceed?",  MB_ICONQUESTION |MB_YESNO |MB_DEFBUTTON2))
			return;
	} 

	if(dhelper_ptr->isLastDesertFinit_2_fail())
	{
		if(applyAll)
			dhelper_ptr->applyAllConstraints(true);
		else
			dhelper_ptr->applyConstraints(conIdlist, true);
	}

	int ret = dhelper_ptr->runDesertFinit_2();
	if(ret<=0) {
		if(ret==0)
			AfxMessageBox("There is no configuration generated.");
		set<int> emptyListOfConstraints;
		dhelper_ptr->applyConstraints(emptyListOfConstraints, true);
		FillSizeBox();
		update();
	}
	else
	{
		CDesertConfigDialog cfgdlg(dhelper_ptr);
		
		if(cfgdlg.DoModal()==100)
		{
			dhelper_ptr->removeCfgsIfEmpty();
			CDialog::OnOK();
		}
		else
		{
			dhelper_ptr->removeCfgsIfEmpty();
			dhelper_ptr->closeDesertIfaceBackDN();
			initConstraints();
		}

	}
}

void CConstraintMainDialog::OnNMCustomdrawConstraintlist(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	NMLVCUSTOMDRAW* pLVCD = reinterpret_cast<NMLVCUSTOMDRAW*>( pNMHDR );

	// Take the default processing unless we set this to something else below.
	*pResult = CDRF_DODEFAULT;

	// First thing - check the draw stage. If it's the control's prepaint
	// stage, then tell Windows we want messages for every item.

	if ( CDDS_PREPAINT == pLVCD->nmcd.dwDrawStage )
	{
		*pResult = CDRF_NOTIFYITEMDRAW;
	}
	else if ( CDDS_ITEMPREPAINT == pLVCD->nmcd.dwDrawStage )
	{
	// This is the notification message for an item. We'll request
	// notifications before each subitem's prepaint stage.

		*pResult = CDRF_NOTIFYSUBITEMDRAW;
	}
	else if ( (CDDS_ITEMPREPAINT | CDDS_SUBITEM) == pLVCD->nmcd.dwDrawStage )
	{
		COLORREF crText;
		int nItem = pLVCD->nmcd.dwItemSpec;
		if( invalidConSet.find(m_listctrl.GetItemID(nItem))!= invalidConSet.end() )
			crText = RGB(255,0,0); //red
		else if ( appliedConSet.find(m_listctrl.GetItemID(nItem))!= appliedConSet.end() )
			crText = RGB(190,190,190);  //grey
		else
			crText = RGB(0,0,0);  //black

		// Store the colors back in the NMLVCUSTOMDRAW struct.
		pLVCD->clrText = crText;
		*pResult = CDRF_DODEFAULT;
	}
}


void CConstraintMainDialog::OnBnClickedSelectbtn()
{
	// TODO: Add your control notification handler code here
	CDSESelectorDialog seldlg(dhelper_ptr);
	if(seldlg.DoModal()==IDCANCEL) return;

	set<int> selectedElems = seldlg.getSelectedElems();
	dhelper_ptr->generateSelectionConstraints(selectedElems);
	initConstraints();
}


void CConstraintMainDialog::OnBnClickedRestartbtn()
{
	// TODO: Add your control notification handler code here
	conIdlist.clear();
	initConstraints();
}

void CConstraintMainDialog::initConstraints()
{
	conIdlist.clear();
	dhelper_ptr->applyConstraints(conIdlist, true);
	//FillSizeBox();
	update();
	applyAll = false;
	refresh_needed = false;
}
