/*
Copyright (C) 2011-2013 Vanderbilt University

Permission is hereby granted, free of charge, to any person obtaining a
copy of this data, including any software or models in source or binary
form, as well as any drawings, specifications, and documentation
(collectively "the Data"), to deal in the Data without restriction,
including without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicense, and/or sell copies of the Data, and to
permit persons to whom the Data is furnished to do so, subject to the
following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE DATA OR THE USE OR OTHER DEALINGS IN THE DATA.  
*/
#pragma once

#include "resource.h"
//#include "UdmBase.h"
#include "afxcmn.h"

#include "DesertHelper.h"
#include "afxwin.h"
// CConstraintMainDialog dialog
#include "CheckHeadCtrl.h"
#include "SortListCtrl.h"

#include "WndResizer.h"

class CConstraintMainDialog : public CDialog
{
	DECLARE_DYNAMIC(CConstraintMainDialog)

public:
	CConstraintMainDialog(CWnd* pParent = NULL);   // standard constructor
	CConstraintMainDialog(DesertHelper *deserthelper_ptr, CWnd* pParent = NULL);  
	virtual ~CConstraintMainDialog();

// Dialog Data
	enum { IDD = IDD_MAIN_DIALOG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
public:
//	afx_msg void OnBnClickedAddbtn();
private:
	CString m_cname;
	CString m_cexpression;
	DesertHelper *dhelper_ptr;
	CToolTipCtrl* m_pToolTip;
	
	set<int> conIdlist;
	list< set<int> > appliedCons;
	int currConListPosition;
	double dspSize;

	set<CString> invalidConstraintName_set;

public:
	static map<int, std::string> constraintExprMap;
	CSortListCtrl m_listctrl;
	virtual BOOL OnInitDialog();
private:
	void FillList();
	void FillList(int index, const std::string &cons_name, const std::string &cons_context, const std::string &cons_type);
	void FillSizeBox();
	afx_msg void OnInfoTip( NMHDR * pNMHDR, LRESULT * pResult );
public:
	afx_msg void OnBnClickedEditbtn();
	afx_msg void OnBnClickedCommitbtn();
	afx_msg void OnBnClickedApplybtn();
	afx_msg void OnBnClickedApplyallbtn();
	afx_msg void OnBnClickedValidatebtn();
//	afx_msg void OnBnClickedRemovebtn();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
private:
	CButton m_btEdit;
	CButton m_btValidate;
	CButton m_btCommit;
	CButton m_btRestart;
	CButton m_btApply;
	CButton m_btApplyAll;

private:
	BOOL	m_blInited;
//	CImageList	m_checkImgList;
//	CCheckHeadCtrl	m_checkHeadCtrl;
//	BOOL initHeadListCtr();
	void generateConfig();
	void update();
	void initConstraints();

	CWndResizer m_resizer;
public:
	afx_msg void OnBnClickedBackbtn();
	afx_msg void OnBnClickedForwardbtn();
	afx_msg void OnBnClickedGencfgbtn();
	CButton m_btBack;
	CButton m_btForward;
	CButton m_btGenCfgs;
	CButton m_btSelect;

private:
	bool refresh_needed;
	bool applyAll;
	/*bool constraint_applied;*/
	set<int> appliedConSet;
	set<int> invalidConSet;

	HWND m_gmeWindow;
public:
	afx_msg void OnDestroy();
	afx_msg void OnBnClickedOk();
	afx_msg void OnNMCustomdrawConstraintlist(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedSelectbtn();	
	afx_msg void OnBnClickedRestartbtn();
};
